# Licensing Information for `PulmoDataSets` Package

This package, `PulmoDataSets`, includes datasets sourced from various R packages. In order to maintain consistency and clarity, a naming convention has been applied where suffixes are added to the dataset names to indicate the type and format of the datasets. The original content of these datasets has not been altered in any way.

## Dataset Licensing Information:

- **respiratory_infections_df**: 
  Originally dat.laopaiboon2015 from the metadat package, licensed under GPL (>= 2). The dataset name has been changed to 'respiratory_infections_df' to indicate that this dataset is a data frame object.

- **tuberculosis_vaccine_df**: 
  Originally dat.colditz1994 from the metadat package, licensed under GPL (>= 2). The dataset name has been changed to 'tuberculosis_vaccine_df' to indicate that this dataset is a data frame object.    

- **pneumonia_influenza_ts**:
  Originally flu from the astsa package, licensed under GPL (>= 2). The dataset name has been changed to 'pneumonia_influenza_ts' to indicate that this dataset is a time series object.

- **lung_cancer_survival_df**: 
  Originally lung from the acro package, licensed under MIT + file LICENSE. The dataset name has been changed to 'lung_cancer_survival_df' to indicate that this dataset is a data frame object.   

- **bronchitis_Cardiff_df**: 
  Originally bronchitis from the gamclass package, licensed under GPL (>= 2). The dataset name has been changed to 'bronchitis_Cardiff_df' to indicate that this dataset is a data frame object.   

- **smoking_UK_tbl_df**: 
  Originally smoking from the openintro package, licensed under GPL-3. The dataset name has been changed to 'smoking_UK_tbl_df' to indicate that this dataset is a tibble object.   

- **nicotine_gum_df**: 
  Originally smoking from the HSAUR3 package, licensed under GPL-2. The dataset name has been changed to 'nicotine_gum_df' to indicate that this dataset is a data frame object.   

- **respiratory_trial_df**: 
  Originally respiratory from the HSAUR3 package, licensed under GPL-2. The dataset name has been changed to 'respiratory_trial_df' to indicate that this dataset is a data frame object.   

- **whooping_cough_ts**: 
  Originally whoops from the DAAG package, licensed under GPL-3. The dataset name has been changed to 'whooping_cough_ts' to indicate that this dataset is a time series object.  

- **whooping_cough_phila_df**: 
  Originally tywhooping from the epimdr package, licensed under GPL-3. The dataset name has been changed to 'whooping_cough_phila_df' to indicate that this dataset is a data frame object.  

- **influenza_us_1975_df**: 
  Originally usflu from the epimdr package, licensed under GPL-3. The dataset name has been changed to 'influenza_us_1975_df' to indicate that this dataset is a data frame object.  

- **whooping_cough_dk_df**: 
  Originally pertcop from the epimdr package, licensed under GPL-3. The dataset name has been changed to 'whooping_cough_dk_df' to indicate that this dataset is a data frame object.   

- **smoking_doctors_df**: 
  Originally breslow from the boot package, licensed under Unlimited. The dataset name has been changed to 'smoking_doctors_df' to indicate that this dataset is a data frame object.   

- **smoking_youth_tbl_df**: 
  Originally CRDS from the LSTbook package, licensed under MIT + file LICENSE. The dataset name has been changed to 'smoking_youth_tbl_df' to indicate that this dataset is a tibble object.   

- **ai_ipn_performance_dt**: 
  Originally IPNs from the R4HCR package, licensed under MIT + file LICENSE. The dataset name has been changed to 'ai_ipn_performance_dt' to indicate that this dataset is a data table object.   

- **lungca_cancer_deaths_df**: 
  Originally LungCa from the R4HCR package, licensed under MIT + file LICENSE. The dataset name has been changed to 'lungca_cancer_deaths_df' to indicate that this dataset is a data frame object.   

- **lung_nodules_detection_dt**: 
  Originally Nodules from the R4HCR package, licensed under MIT + file LICENSE. The dataset name has been changed to 'lung_nodules_detection_dt' to indicate that this dataset is a data table object.  

- **veterans_lung_cancer_df**: 
  Originally veteran from the survival package, licensed under LGPL (>= 2). The dataset name has been changed to 'veterans_lung_cancer_df' to indicate that this dataset is a data frame object.  

- **danish_lung_incidence_df**: 
  Originally eba1977 from the ISwR package, licensed under GPL (>= 2). The dataset name has been changed to 'danish_lung_incidence_df' to indicate that this dataset is a  data frame object.   

- **engwales_cancer_mortality_df**: 
  Originally ewrates from the ISwR package, licensed under GPL (>= 2). The dataset name has been changed to 'engwales_cancer_mortality_df' to indicate that this dataset is a data frame object.   

- **tlc_lung_capacity_df**: 
  Originally tlc from the ISwR package, licensed under GPL (>= 2). The dataset name has been changed to 'tlc_lung_capacity_df' to indicate that this dataset is a data frame object.   

- **neonatal_intubation_times_df**: 
  Originally intubation from the ViSiElse package, licensed under AGPL-3. The dataset name has been changed to 'neonatal_intubation_times_df' to indicate that this dataset is a data frame object.  

- **ohio_children_wheeze_df**: 
  Originally ohio from the geepack package, licensed under GPL (>= 3). The dataset name has been changed to 'ohio_children_wheeze_df' to indicate that this dataset is a data frame object.   

- **respiratory_trial_outcomes_df**: 
  Originally respdis from the geepack package, licensed under GPL (>= 3). The dataset name has been changed to 'respiratory_trial_outcomes_df' to indicate that this dataset is a data frame object.   

- **respiratory_clinical_trial_df**: 
  Originally respiratory from the geepack package, licensed under GPL (>= 3). The dataset name has been changed to 'respiratory_clinical_trial_df' to indicate that this dataset is a data frame object. 

- **UK_female_lung_deaths_ts**: 
  Originally fdeaths from the base R package datasets (R version 4.5.0). This dataset is licensed under GPL-2 or GPL-3, the same license as R. The name has been changed to 'UK_female_lung_deaths_ts' to reflect that it represents a time series object related to female lung disease deaths in the UK. 

- **UK_male_lung_deaths_ts**: 
  Originally mdeaths from the base R package datasets (R version 4.5.0). This dataset is licensed under GPL-2 or GPL-3, consistent with the R license. The name has been changed to 'UK_male_lung_deaths_ts' to indicate that it represents a time series object of male lung disease deaths in the UK. 

- **chicago_pollution_df**: 
  Originally chicagoNMMAPS from the dlnm package, licensed under GPL (>= 2). The dataset name has been changed to 'chicago_pollution_df' to indicate that this dataset is a data frame object. 

- **USMortality_df**: 
  Originally USMortality from the lattice package, licensed under GPL (>= 2). The dataset name has been changed to 'USMortality_df' to indicate that this dataset is a data frame object. 

- **USRegionalMortality_df**: 
  Originally USRegionalMortality from the lattice package, licensed under GPL (>= 2). The dataset name has been changed to 'USRegionalMortality_df' to indicate that this dataset is a data frame object. 

- **air_polution_mortality_df**: 
  Originally ex1123 from the Sleuth3 package, licensed under GPL (>= 2). The dataset name has been changed to 'air_polution_mortality_df' to indicate that this dataset is a data frame object. 

- **children_respiratory_rates_df**: 
  Originally ex0824 from the Sleuth3 package, licensed under GPL (>= 2). The dataset name has been changed to 'children_respiratory_rates_df' to indicate that this dataset is a data frame object. 

- **smoking_lung_cancer_df**: 
  Originally case1803 from the Sleuth3 package, licensed under GPL (>= 2). The dataset name has been changed to 'smoking_lung_cancer_df' to indicate that this dataset is a data frame object. 

- **child_wheeze_pollution_df**: 
  Originally wheeze from the geessbin package, licensed under GPL (>= 2). The dataset name has been changed to 'child_wheeze_pollution_df' to indicate that this dataset is a data frame object. 

- **patients_lung_diseases_tbl_df**
  Dataset from Kaggle (https://www.kaggle.com/datasets/samikshadalvi/lungs-diseases-dataset), licensed under CC0: Public Domain. This dataset captures detailed information about patients suffering from various lung conditions.

- **asthma_patients_tbl_df**
  Dataset from Kaggle (https://www.kaggle.com/datasets/jatinthakur706/copd-asthma-patient-dataset), licensed under CC0: Public Domain. This is dataset which contains data of about 300 Patients who suffered from asthma in a duration of 3 years.


## License

All datasets in this package are provided under the same licenses as their original sources. The licensing information and any specific attribution required for each dataset can be found within their respective packages. The user must adhere to the licensing terms specified by each original source.

This package, `PulmoDataSets`, is licensed under the GPL-3 License.
