/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.common.util.preprocessor.detector.scheduling;

import choco.cp.common.util.preprocessor.detector.scheduling.AbstractSchedulingDectector;
import choco.cp.common.util.preprocessor.detector.scheduling.DisjunctiveGraph;
import choco.cp.common.util.preprocessor.detector.scheduling.DisjunctiveModel;
import choco.cp.model.CPModel;
import choco.kernel.model.constraints.TemporalConstraint;
import java.util.BitSet;

public class PrecReductionModelDetector
extends AbstractSchedulingDectector {
    public PrecReductionModelDetector(CPModel model, DisjunctiveModel disjMod) {
        super(model, disjMod);
    }

    @Override
    public void apply() {
        BitSet[] reduction = this.disjMod.copyPrecGraph();
        DisjunctiveGraph.floydMarshallReduction(reduction);
        this.disjMod.unsetPrecClosure();
        BitSet[] transitive = this.disjMod.copyPrecGraph();
        DisjunctiveGraph.andNot(transitive, reduction);
        for (int i = 0; i < transitive.length; ++i) {
            int j = transitive[i].nextSetBit(0);
            while (j >= 0) {
                TemporalConstraint ct;
                if (this.disjMod.containsConstraint(i, j) && (ct = (TemporalConstraint)this.disjMod.getConstraint(i, j)).isInPreprocess() && ct.backwardSetup() == 0 && ct.forwardSetup() == 0) {
                    this.disjMod.deleteArc(i, j);
                    this.delete(ct);
                }
                j = transitive[i].nextSetBit(j + 1);
            }
        }
    }
}

