/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.converter;

import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.dmg.pmml.DataType;
import org.jpmml.converter.Feature;
import org.jpmml.converter.FeatureUtil;
import org.jpmml.converter.ObjectFeature;
import org.jpmml.converter.PMMLEncoder;

public class ArrayFeature
extends ObjectFeature {
    private List<Feature> features = null;

    public ArrayFeature(PMMLEncoder encoder, List<Feature> features) {
        super(encoder, ArrayFeature.getName(features), ArrayFeature.getDataType(features));
        this.setFeatures(features);
    }

    public List<Feature> getFeatures() {
        return this.features;
    }

    private void setFeatures(List<Feature> features) {
        this.features = Objects.requireNonNull(features);
    }

    private static String getName(List<Feature> features) {
        return features.stream().map(feature -> FeatureUtil.getName(feature)).collect(Collectors.joining(", ", "[", "]"));
    }

    public static DataType getDataType(List<Feature> features) {
        Set dataTypes = features.stream().map(feature -> feature.getDataType()).collect(Collectors.toSet());
        return (DataType)Iterables.getOnlyElement(dataTypes);
    }
}

