/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.stats.tests;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.stats.ProbabilityType;
import jdplus.toolkit.base.api.stats.StatisticalTest;
import jdplus.toolkit.base.api.stats.TestType;
import jdplus.toolkit.base.core.dstats.Chi2;
import jdplus.toolkit.base.core.dstats.F;
import jdplus.toolkit.base.core.stats.DescriptiveStatistics;
import jdplus.toolkit.base.core.stats.samples.Sample;
import jdplus.toolkit.base.core.stats.tests.AdvancedOneWayAnova;
import jdplus.toolkit.base.core.stats.tests.TestsUtility;
import lombok.Generated;

public final class Variances {
    public static StatisticalTest bartlett(Sample[] seqs) {
        double vp = 0.0;
        int k = seqs.length;
        int N = 0;
        double q = 0.0;
        double lv = 0.0;
        for (int i = 0; i < k; ++i) {
            int ni = seqs[i].observationsCount();
            double vi = seqs[i].variance();
            N += ni;
            double nim1 = ni - 1;
            vp += nim1 * vi;
            q += 1.0 / nim1;
            lv += nim1 * Math.log(vi);
        }
        double chi = ((double)(N - k) * Math.log(vp /= (double)(N - k)) - lv) / (1.0 + (q -= 1.0 / (double)(N - k)) / (double)(3 * (k - 1)));
        return TestsUtility.testOf(chi, new Chi2(k - 1), TestType.Upper);
    }

    public static double cochranC(Sample[] data, int sequence) {
        Variances.checkEqualLength(data);
        double num = 0.0;
        double denom = 0.0;
        for (int i = 0; i < data.length; ++i) {
            double var = data[i].variance();
            if (i == sequence) {
                num = var;
            }
            denom += var;
        }
        return num / denom;
    }

    public static double[] cochranC(Sample[] data) {
        int i;
        Variances.checkEqualLength(data);
        double[] vars = new double[data.length];
        double all = 0.0;
        for (i = 0; i < data.length; ++i) {
            double var = data[i].variance();
            all += var;
            vars[i] = var;
        }
        i = 0;
        while (i < data.length) {
            int n = i++;
            vars[n] = vars[n] / all;
        }
        return vars;
    }

    public static double cochranCriticalValue(double alpha, int N, int n) {
        F f = new F(n - 1, (N - 1) * (n - 1));
        return 1.0 / (1.0 + (double)(N - 1) / f.getProbabilityInverse(alpha / (double)N, ProbabilityType.Upper));
    }

    public static AdvancedOneWayAnova levene(Sample[] samples) {
        AdvancedOneWayAnova anova = new AdvancedOneWayAnova();
        for (int i = 0; i < samples.length; ++i) {
            double ybar = samples[i].mean();
            DoubleSeq z = samples[i].data().fn(x -> Math.abs(x - ybar));
            anova.add(new AdvancedOneWayAnova.Group("g" + (i + 1), z));
        }
        return anova;
    }

    public static AdvancedOneWayAnova brownForsythe(Sample[] samples) {
        AdvancedOneWayAnova anova = new AdvancedOneWayAnova();
        for (int i = 0; i < samples.length; ++i) {
            double ybar = DescriptiveStatistics.of(samples[i].data()).getMedian();
            DoubleSeq z = samples[i].data().fn(x -> Math.abs(x - ybar));
            anova.add(new AdvancedOneWayAnova.Group("g" + (i + 1), z));
        }
        return anova;
    }

    private static void checkEqualLength(Sample[] data) {
        if (data.length < 2) {
            throw new IllegalArgumentException();
        }
        int n = data[0].observationsCount();
        for (int i = 1; i < data.length; ++i) {
            if (data[i].observationsCount() == n) continue;
            throw new IllegalArgumentException();
        }
    }

    @Generated
    private Variances() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

