/*
 * Decompiled with CFR 0.152.
 */
package sample;

import dag.Dag;
import java.util.Arrays;
import sample.SingleNodes;
import vcf.BasicGL;
import vcf.GL;

public class SingleBaumLevel {
    private static final int INITIAL_CAPACITY = 400;
    private static final float MIN_VALUE = 1.4E-43f;
    private final Dag dag;
    private final GL gl;
    private int marker = -1;
    private int sample = -1;
    private int size = 0;
    private int capacity = 400;
    private int[] edges1 = new int[400];
    private int[] edges2 = new int[400];
    private float[] fwdValues = new float[400];
    private float[] bwdValues = new float[400];
    private float fwdValueSum = 0.0f;
    private float bwdValueSum = 0.0f;
    private int nGenotypes = 0;
    private float[] gtProbs = new float[3];

    public SingleBaumLevel(Dag dag, GL gL) {
        if (!dag.markers().equals(gL.markers())) {
            throw new IllegalArgumentException("inconsistent markers");
        }
        this.dag = dag;
        this.gl = gL;
    }

    public void setForwardValues(SingleNodes singleNodes, int n, int n2) {
        this.marker = n;
        this.sample = n2;
        this.nGenotypes = this.gl.marker(n).nGenotypes();
        this.size = 0;
        this.fwdValueSum = 0.0f;
        this.bwdValueSum = 0.0f;
        this.initializeGtProbs();
        this.setStates(singleNodes);
        this.setChildNodes(singleNodes);
    }

    private void initializeGtProbs() {
        if (this.gtProbs.length < this.nGenotypes) {
            int n = Math.max(this.nGenotypes, 3 * this.gtProbs.length / 2 + 1);
            this.gtProbs = new float[n];
        } else {
            Arrays.fill(this.gtProbs, 0, this.nGenotypes, 0.0f);
        }
    }

    private void setStates(SingleNodes singleNodes) {
        int n;
        float f = 0.0f;
        int n2 = singleNodes.size();
        for (n = 0; n < n2; ++n) {
            int n3 = singleNodes.enumNode1(n);
            int n4 = singleNodes.enumNode2(n);
            int n5 = this.dag.nOutEdges(this.marker, n3);
            for (int i = 0; i < n5; ++i) {
                int n6 = this.dag.outEdge(this.marker, n3, i);
                int n7 = this.dag.symbol(this.marker, n6);
                int n8 = this.dag.nOutEdges(this.marker, n4);
                for (int j = 0; j < n8; ++j) {
                    int n9 = this.dag.outEdge(this.marker, n4, j);
                    int n10 = this.dag.symbol(this.marker, n9);
                    float f2 = this.gl.gl(this.marker, this.sample, n7, n10);
                    if (!((double)f2 > 0.0)) continue;
                    if (this.size == this.capacity) {
                        this.ensureCapacity(this.size + 1);
                    }
                    this.edges1[this.size] = n6;
                    this.edges2[this.size] = n9;
                    float f3 = this.dag.condEdgeProb(this.marker, n6);
                    float f4 = this.dag.condEdgeProb(this.marker, n9);
                    float f5 = f2 * singleNodes.enumValue(n) * (f3 * f4);
                    if (f5 < 1.4E-43f && (double)singleNodes.enumValue(n) > 0.0) {
                        f5 = 1.4E-43f;
                    }
                    this.fwdValues[this.size++] = f5;
                    f += f5;
                }
            }
        }
        assert ((double)f > 0.0 ^ this.size == 0);
        n = 0;
        while (n < this.size) {
            int n11 = n++;
            this.fwdValues[n11] = this.fwdValues[n11] / f;
        }
        this.fwdValueSum = f;
    }

    public void setChildNodes(SingleNodes singleNodes) {
        singleNodes.clear();
        for (int i = 0; i < this.size; ++i) {
            int n = this.dag.childNode(this.marker, this.edges1[i]);
            int n2 = this.dag.childNode(this.marker, this.edges2[i]);
            singleNodes.sumUpdate(n, n2, this.fwdValues[i]);
        }
    }

    public void setBackwardValues(SingleNodes singleNodes) {
        int n;
        int n2;
        for (int i = 0; i < this.size; ++i) {
            float f;
            n2 = this.dag.childNode(this.marker, this.edges1[i]);
            n = this.dag.childNode(this.marker, this.edges2[i]);
            this.bwdValues[i] = f = singleNodes.value(n2, n);
            this.bwdValueSum += f;
        }
        singleNodes.clear();
        float f = 0.0f;
        for (n2 = 0; n2 < this.size; ++n2) {
            int n3;
            int n4 = n2;
            this.bwdValues[n4] = this.bwdValues[n4] / this.bwdValueSum;
            n = this.edges1[n2];
            int n5 = this.edges2[n2];
            int n6 = this.symbol1(n2);
            int n7 = this.symbol2(n2);
            float f2 = this.dag.condEdgeProb(this.marker, n);
            float f3 = this.dag.condEdgeProb(this.marker, n5);
            float f4 = this.fwdValues[n2] * this.bwdValues[n2];
            int n8 = n3 = BasicGL.genotype(n6, n7);
            this.gtProbs[n8] = this.gtProbs[n8] + f4;
            f += f4;
            float f5 = this.gl.gl(this.marker, this.sample, n6, n7);
            float f6 = this.bwdValues[n2] * (f2 * f3) * f5;
            if (f6 < 1.4E-43f && (double)this.bwdValues[n2] > 0.0) {
                f6 = 1.4E-43f;
            }
            if (!(f6 > 0.0f)) continue;
            int n9 = this.dag.parentNode(this.marker, n);
            int n10 = this.dag.parentNode(this.marker, n5);
            singleNodes.sumUpdate(n9, n10, f6);
        }
        n2 = 0;
        while (n2 < this.nGenotypes) {
            int n11 = n2++;
            this.gtProbs[n11] = this.gtProbs[n11] / f;
        }
    }

    public Dag dag() {
        return this.dag;
    }

    public GL gl() {
        return this.gl;
    }

    public int marker() {
        return this.marker;
    }

    public int nGenotypes() {
        return this.nGenotypes;
    }

    public float gtProbs(int n) {
        if (n >= this.nGenotypes) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
        return this.gtProbs[n];
    }

    public int size() {
        return this.size;
    }

    private void checkIndex(int n) {
        if (n >= this.size) {
            throw new IndexOutOfBoundsException(String.valueOf(this.size));
        }
    }

    public int edge1(int n) {
        this.checkIndex(n);
        return this.edges1[n];
    }

    public int edge2(int n) {
        this.checkIndex(n);
        return this.edges2[n];
    }

    public int parentNode1(int n) {
        this.checkIndex(n);
        return this.dag.parentNode(this.marker, this.edges1[n]);
    }

    public int parentNode2(int n) {
        this.checkIndex(n);
        return this.dag.parentNode(this.marker, this.edges2[n]);
    }

    public int childNode1(int n) {
        this.checkIndex(n);
        return this.dag.childNode(this.marker, this.edges1[n]);
    }

    public int childNode2(int n) {
        this.checkIndex(n);
        return this.dag.childNode(this.marker, this.edges2[n]);
    }

    public int symbol1(int n) {
        return this.dag.symbol(this.marker, this.edge1(n));
    }

    public int symbol2(int n) {
        return this.dag.symbol(this.marker, this.edge2(n));
    }

    public float forwardValue(int n) {
        this.checkIndex(n);
        return this.fwdValues[n];
    }

    public float backwardValue(int n) {
        this.checkIndex(n);
        return this.bwdValues[n];
    }

    public float forwardValuesSum() {
        return this.fwdValueSum;
    }

    public float backwardValuesSum() {
        return this.bwdValueSum;
    }

    public String toString() {
        String string = " ";
        String string2 = " | ";
        StringBuilder stringBuilder = new StringBuilder(100);
        stringBuilder.append("level=");
        stringBuilder.append(this.marker);
        stringBuilder.append(" size=");
        stringBuilder.append(this.size);
        stringBuilder.append(" forwardValuesSum=");
        stringBuilder.append(this.fwdValueSum);
        stringBuilder.append(" backwardSum=");
        stringBuilder.append(this.bwdValueSum);
        for (int i = 0; i < this.size; ++i) {
            stringBuilder.append(string2);
            stringBuilder.append("j=");
            stringBuilder.append(i);
            stringBuilder.append(": ");
            stringBuilder.append(this.edge1(i));
            stringBuilder.append(string);
            stringBuilder.append(this.edge2(i));
            stringBuilder.append(string);
            stringBuilder.append(this.forwardValue(i));
            stringBuilder.append(string);
            stringBuilder.append(this.backwardValue(i));
        }
        stringBuilder.append(string2);
        return stringBuilder.toString();
    }

    private void ensureCapacity(int n) {
        if (n > this.capacity) {
            this.capacity = this.capacity * 3 / 2 + 1;
            if (this.capacity < n) {
                this.capacity = n;
            }
            this.edges1 = Arrays.copyOf(this.edges1, this.capacity);
            this.edges2 = Arrays.copyOf(this.edges2, this.capacity);
            this.fwdValues = Arrays.copyOf(this.fwdValues, this.capacity);
            this.bwdValues = Arrays.copyOf(this.bwdValues, this.capacity);
        }
    }
}

