## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----built--------------------------------------------------------------------
message(paste0('Datetime: ',Sys.Date(),':',Sys.time()))

## ----setup, message=FALSE-----------------------------------------------------
library(repfun)
library(dplyr)

## ----build--------------------------------------------------------------------
  iris1 <- iris %>% dplyr::mutate(ID=dplyr::row_number())
  iris2 <- iris %>% dplyr::mutate(ID=dplyr::row_number()) %>% 
    dplyr::mutate(Petal.Length=Petal.Length+1)

## ----compare------------------------------------------------------------------
irisdiffs <- repfun::ru_datacompare(iris1, iris2, idvars=c('Species','ID'), maxprint=10)

## ----results------------------------------------------------------------------
irisdiffs

