/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.timeseries.calendars;

import java.time.LocalDate;
import java.util.Iterator;
import jdplus.toolkit.base.api.timeseries.ValidityPeriod;
import jdplus.toolkit.base.api.timeseries.calendars.FixedDay;
import jdplus.toolkit.base.core.timeseries.calendars.HolidayInfo;
import lombok.Generated;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

final class FixedDayInfo
implements HolidayInfo {
    private final int year;
    private final FixedDay fday;

    FixedDayInfo(int year, FixedDay fday) {
        this.fday = fday;
        this.year = year;
    }

    @Override
    public LocalDate getDay() {
        return LocalDate.of(this.year, this.fday.getMonth(), this.fday.getDay());
    }

    @Generated
    public int getYear() {
        return this.year;
    }

    @Generated
    public FixedDay getFday() {
        return this.fday;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FixedDayInfo)) {
            return false;
        }
        FixedDayInfo other = (FixedDayInfo)o;
        if (this.getYear() != other.getYear()) {
            return false;
        }
        FixedDay this$fday = this.getFday();
        FixedDay other$fday = other.getFday();
        return !(this$fday == null ? other$fday != null : !this$fday.equals(other$fday));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getYear();
        FixedDay $fday = this.getFday();
        result = result * 59 + ($fday == null ? 43 : $fday.hashCode());
        return result;
    }

    @Generated
    public @NonNull String toString() {
        return "FixedDayInfo(year=" + this.getYear() + ", fday=" + String.valueOf(this.getFday()) + ")";
    }

    static class FixedDayIterable
    implements Iterable<HolidayInfo> {
        private final FixedDay fday;
        private final int year;
        private final int n;

        FixedDayIterable(FixedDay fday, LocalDate fstart, LocalDate fend) {
            this.fday = fday;
            ValidityPeriod vp = fday.getValidityPeriod();
            if (vp.getStart().isAfter(fstart)) {
                fstart = vp.getStart();
            }
            if (vp.getEnd().isBefore(fend)) {
                fend = vp.getEnd();
            }
            int ystart = fstart.getYear();
            int yend = fend.getYear();
            LocalDate xday = LocalDate.of(ystart, fday.getMonth(), fday.getDay());
            LocalDate yday = LocalDate.of(yend, fday.getMonth(), fday.getDay());
            if (xday.isBefore(fstart)) {
                ++ystart;
            }
            if (!yday.isBefore(fend)) {
                --yend;
            }
            this.year = ystart;
            this.n = yend - ystart + 1;
        }

        @Override
        public Iterator<HolidayInfo> iterator() {
            return new Iterator<HolidayInfo>(){
                int cur = 0;

                @Override
                public boolean hasNext() {
                    return this.cur < n;
                }

                @Override
                public HolidayInfo next() {
                    return new FixedDayInfo(year + this.cur++, fday);
                }
            };
        }
    }
}

