/*
 * Decompiled with CFR 0.152.
 */
package jdplus.tramoseats.base.core.tramoseats;

import jdplus.sa.base.api.ComponentType;
import jdplus.sa.base.api.SaVariable;
import jdplus.sa.base.api.SeriesDecomposition;
import jdplus.sa.base.api.benchmarking.SaBenchmarkingSpec;
import jdplus.sa.base.core.CholetteProcessor;
import jdplus.sa.base.core.PreliminaryChecks;
import jdplus.sa.base.core.SaBenchmarkingResults;
import jdplus.sa.base.core.modelling.TwoStepsDecomposition;
import jdplus.toolkit.base.api.arima.SarimaSpec;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.data.Parameter;
import jdplus.toolkit.base.api.data.ParameterType;
import jdplus.toolkit.base.api.information.Explorable;
import jdplus.toolkit.base.api.modelling.ComponentInformation;
import jdplus.toolkit.base.api.processing.ProcessingLog;
import jdplus.toolkit.base.api.timeseries.TsData;
import jdplus.toolkit.base.api.timeseries.regression.ModellingContext;
import jdplus.toolkit.base.api.timeseries.regression.Variable;
import jdplus.toolkit.base.core.modelling.GeneralLinearModel;
import jdplus.toolkit.base.core.regsarima.regular.RegSarimaModel;
import jdplus.toolkit.base.core.sarima.SarimaModel;
import jdplus.toolkit.base.core.stats.likelihood.LikelihoodStatistics;
import jdplus.tramoseats.base.api.seats.SeatsModelSpec;
import jdplus.tramoseats.base.api.tramo.TransformSpec;
import jdplus.tramoseats.base.api.tramoseats.TramoSeatsSpec;
import jdplus.tramoseats.base.core.seats.SeatsKernel;
import jdplus.tramoseats.base.core.seats.SeatsResults;
import jdplus.tramoseats.base.core.seats.SeatsToolkit;
import jdplus.tramoseats.base.core.tramo.TramoKernel;
import jdplus.tramoseats.base.core.tramoseats.TramoSeatsDiagnostics;
import jdplus.tramoseats.base.core.tramoseats.TramoSeatsResults;
import lombok.Generated;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class TramoSeatsKernel {
    private final PreliminaryChecks.Tool preliminary;
    private final TramoKernel tramo;
    private final SeatsKernel seats;
    private final CholetteProcessor cholette;

    private static PreliminaryChecks.Tool of(TramoSeatsSpec spec) {
        TransformSpec transform = spec.getTramo().getTransform();
        return (s, logs) -> {
            TsData sc = s.select(transform.getSpan());
            if (transform.isPreliminaryCheck() && !PreliminaryChecks.testSeries((TsData)sc, (ProcessingLog)logs)) {
                return null;
            }
            return sc;
        };
    }

    public static TramoSeatsKernel of(TramoSeatsSpec spec, ModellingContext context) {
        PreliminaryChecks.Tool check = TramoSeatsKernel.of(spec);
        TramoKernel tramo = TramoKernel.of(spec.getTramo(), context);
        SeatsKernel seats = new SeatsKernel(SeatsToolkit.of(spec.getSeats()));
        return new TramoSeatsKernel(check, tramo, seats, CholetteProcessor.of((SaBenchmarkingSpec)spec.getBenchmarking()));
    }

    public TramoSeatsResults process(TsData s, ProcessingLog log) {
        if (log == null) {
            log = ProcessingLog.dummy();
        }
        try {
            TsData sc = this.preliminary.check(s, log);
            if (sc == null) {
                return TramoSeatsResults.builder().log(log).build();
            }
            RegSarimaModel preprocessing = this.tramo.process(s, log);
            SeatsModelSpec smodel = TramoSeatsKernel.of(preprocessing);
            SeatsResults srslts = this.seats.process(smodel, log);
            SeriesDecomposition finals = TwoStepsDecomposition.merge((GeneralLinearModel)preprocessing, (SeriesDecomposition)srslts.getFinalComponents());
            SaBenchmarkingResults bench = null;
            if (this.cholette != null) {
                bench = this.cholette.process(s, TsData.concatenate((TsData[])new TsData[]{finals.getSeries(ComponentType.SeasonallyAdjusted, ComponentInformation.Value), finals.getSeries(ComponentType.SeasonallyAdjusted, ComponentInformation.Forecast)}), (Explorable)preprocessing);
            }
            TramoSeatsDiagnostics diagnostics = TramoSeatsDiagnostics.of(preprocessing, srslts, finals);
            return TramoSeatsResults.builder().preprocessing(preprocessing).decomposition(srslts).finals(finals).benchmarking(bench).diagnostics(diagnostics).log(log).build();
        }
        catch (Exception err) {
            log.error(err);
            return TramoSeatsResults.builder().log(log).build();
        }
    }

    private static SeatsModelSpec of(RegSarimaModel model) {
        TsData series = model.interpolatedSeries(false);
        TsData det = model.deterministicEffect(null, v -> !SaVariable.isRegressionEffect((Variable)v, (ComponentType)ComponentType.Undefined));
        det = model.backTransform(det, true);
        series = model.getDescription().isLogTransformation() ? TsData.divide((TsData)series, (TsData)det) : TsData.subtract((TsData)series, (TsData)det);
        SarimaModel arima = model.arima();
        SarimaSpec sarima = (SarimaSpec)SarimaSpec.builder().d(arima.getD()).bd(arima.getBd()).phi(Parameter.of((DoubleSeq)arima.getPhi(), (ParameterType)ParameterType.Fixed)).theta(Parameter.of((DoubleSeq)arima.getTheta(), (ParameterType)ParameterType.Fixed)).bphi(Parameter.of((DoubleSeq)arima.getBphi(), (ParameterType)ParameterType.Fixed)).btheta(Parameter.of((DoubleSeq)arima.getBtheta(), (ParameterType)ParameterType.Fixed)).build();
        LikelihoodStatistics ll = model.getEstimation().getStatistics();
        return (SeatsModelSpec)SeatsModelSpec.builder().series(series).log(model.getDescription().isLogTransformation()).meanCorrection(model.isMeanCorrection()).sarimaSpec(sarima).innovationVariance(ll.getSsqErr() / (double)(ll.getEffectiveObservationsCount() - ll.getEstimatedParametersCount())).build();
    }

    @Generated
    public TramoSeatsKernel(PreliminaryChecks.Tool preliminary, TramoKernel tramo, SeatsKernel seats, CholetteProcessor cholette) {
        this.preliminary = preliminary;
        this.tramo = tramo;
        this.seats = seats;
        this.cholette = cholette;
    }

    @Generated
    public PreliminaryChecks.Tool getPreliminary() {
        return this.preliminary;
    }

    @Generated
    public TramoKernel getTramo() {
        return this.tramo;
    }

    @Generated
    public SeatsKernel getSeats() {
        return this.seats;
    }

    @Generated
    public CholetteProcessor getCholette() {
        return this.cholette;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TramoSeatsKernel)) {
            return false;
        }
        TramoSeatsKernel other = (TramoSeatsKernel)o;
        PreliminaryChecks.Tool this$preliminary = this.getPreliminary();
        PreliminaryChecks.Tool other$preliminary = other.getPreliminary();
        if (this$preliminary == null ? other$preliminary != null : !this$preliminary.equals(other$preliminary)) {
            return false;
        }
        TramoKernel this$tramo = this.getTramo();
        TramoKernel other$tramo = other.getTramo();
        if (this$tramo == null ? other$tramo != null : !this$tramo.equals(other$tramo)) {
            return false;
        }
        SeatsKernel this$seats = this.getSeats();
        SeatsKernel other$seats = other.getSeats();
        if (this$seats == null ? other$seats != null : !this$seats.equals(other$seats)) {
            return false;
        }
        CholetteProcessor this$cholette = this.getCholette();
        CholetteProcessor other$cholette = other.getCholette();
        return !(this$cholette == null ? other$cholette != null : !this$cholette.equals(other$cholette));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PreliminaryChecks.Tool $preliminary = this.getPreliminary();
        result = result * 59 + ($preliminary == null ? 43 : $preliminary.hashCode());
        TramoKernel $tramo = this.getTramo();
        result = result * 59 + ($tramo == null ? 43 : $tramo.hashCode());
        SeatsKernel $seats = this.getSeats();
        result = result * 59 + ($seats == null ? 43 : $seats.hashCode());
        CholetteProcessor $cholette = this.getCholette();
        result = result * 59 + ($cholette == null ? 43 : $cholette.hashCode());
        return result;
    }

    @Generated
    public @NonNull String toString() {
        return "TramoSeatsKernel(preliminary=" + String.valueOf(this.getPreliminary()) + ", tramo=" + String.valueOf(this.getTramo()) + ", seats=" + String.valueOf(this.getSeats()) + ", cholette=" + String.valueOf(this.getCholette()) + ")";
    }
}

