/*
 * Decompiled with CFR 0.152.
 */
package jdplus.x13.base.core.x13.regarima;

import java.util.ArrayList;
import java.util.List;
import jdplus.toolkit.base.api.timeseries.regression.ITsVariable;
import jdplus.toolkit.base.api.timeseries.regression.Variable;
import jdplus.toolkit.base.core.regarima.AICcComparator;
import jdplus.toolkit.base.core.regarima.IRegArimaComputer;
import jdplus.toolkit.base.core.regarima.RegArimaEstimation;
import jdplus.toolkit.base.core.regarima.RegArimaUtility;
import jdplus.toolkit.base.core.regsarima.regular.IModelComparator;
import jdplus.toolkit.base.core.regsarima.regular.IRegressionModule;
import jdplus.toolkit.base.core.regsarima.regular.ModelDescription;
import jdplus.toolkit.base.core.regsarima.regular.ProcessingResult;
import jdplus.toolkit.base.core.regsarima.regular.RegSarimaModelling;

public class UserVariablesDetectionModule
implements IRegressionModule {
    private final ITsVariable[] users;
    private IModelComparator comparator = new AICcComparator(0.0);
    private final double eps;

    public static Builder builder() {
        return new Builder();
    }

    private UserVariablesDetectionModule(Builder builder) {
        this.comparator = builder.comparator;
        this.eps = builder.eps;
        this.users = builder.users.toArray(new ITsVariable[builder.users.size()]);
    }

    public ProcessingResult test(RegSarimaModelling context) {
        ModelDescription description = context.getDescription();
        RegArimaEstimation est = context.getEstimation();
        IRegArimaComputer processor = RegArimaUtility.processor((boolean)true, (double)this.eps);
        for (int i = 0; i < this.users.length; ++i) {
            ModelDescription nudesc = ModelDescription.copyOf((ModelDescription)description);
            ITsVariable cur = this.users[i];
            boolean removed = nudesc.removeVariable(var -> var.getCore().equals((Object)cur));
            ModelDescription udesc = ModelDescription.copyOf((ModelDescription)nudesc);
            nudesc.addVariable(Variable.variable((String)("user-" + (i + 1)), (ITsVariable)this.users[i]));
            RegArimaEstimation nuest = removed || est == null ? nudesc.estimate(processor) : est;
            RegArimaEstimation uest = !removed || est == null ? udesc.estimate(processor) : est;
            if (this.comparator.compare(nuest, uest) == 0) {
                description = udesc;
                est = uest;
                continue;
            }
            description = nudesc;
            est = nuest;
        }
        boolean changed = false;
        return changed ? ProcessingResult.Changed : ProcessingResult.Unchanged;
    }

    public static class Builder {
        private final List<ITsVariable> users = new ArrayList<ITsVariable>();
        private IModelComparator comparator = new AICcComparator(0.0);
        private double eps = 1.0E-5;

        public Builder add(ITsVariable ... vars) {
            for (int i = 0; i < vars.length; ++i) {
                this.users.add(vars[i]);
            }
            return this;
        }

        public Builder estimationPrecision(double eps) {
            this.eps = eps;
            return this;
        }

        public Builder modelComparator(IModelComparator comparator) {
            this.comparator = comparator;
            return this;
        }

        public UserVariablesDetectionModule build() {
            return new UserVariablesDetectionModule(this);
        }
    }
}

