/*
 * Decompiled with CFR 0.152.
 */
package org.ohdsi.metaAnalysis;

import dr.inference.distribution.EmpiricalDistributionData;
import dr.inference.distribution.EmpiricalDistributionLikelihood;
import dr.math.distributions.NormalDistribution;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Scanner;
import org.ohdsi.metaAnalysis.DataModel;

public class SkewNormalDataModel
extends DataModel.Base
implements DataModel {
    public SkewNormalDataModel(String fileName) {
        this();
        File file = new File(fileName);
        ArrayList<List<String>> lines = new ArrayList<List<String>>();
        try {
            Scanner inputStream = new Scanner(file);
            while (inputStream.hasNext()) {
                String line = inputStream.next();
                line = line.replaceAll("\"", "");
                String[] values = line.split(",");
                lines.add(Arrays.asList(values));
            }
            inputStream.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        int muIdx = ((List)lines.get(0)).indexOf("mu");
        int sigmaIdx = ((List)lines.get(0)).indexOf("sigma");
        int gammaIdx = ((List)lines.get(0)).indexOf("gamma");
        int i = 1;
        while (i < lines.size()) {
            double[] parameters = new double[]{Double.parseDouble((String)((List)lines.get(i)).get(muIdx)), Double.parseDouble((String)((List)lines.get(i)).get(sigmaIdx)), Double.parseDouble((String)((List)lines.get(i)).get(gammaIdx))};
            this.addLikelihoodParameters(parameters, null);
            ++i;
        }
        this.finish();
    }

    public SkewNormalDataModel() {
    }

    @Override
    EmpiricalDistributionLikelihood makeFunctionalForm(List<EmpiricalDistributionData> dataList) {
        return new EmpiricalDistributionLikelihood(dataList, false){
            private static final long serialVersionUID = 6515855145410583409L;

            private final double skewNormal(double x, double mean, double stdDev, double skew) {
                return Math.log(2.0) + NormalDistribution.logPdf((double)x, (double)mean, (double)stdDev) + NormalDistribution.cdf((double)(skew * (x - mean)), (double)0.0, (double)stdDev, (boolean)true);
            }

            protected double logPDF(double x, EmpiricalDistributionData data) {
                double mean = data.values[0];
                double stdDev = data.values[1];
                double skew = data.values[2];
                return this.skewNormal(x, mean, stdDev, skew);
            }

            protected double gradientLogPdf(double x, EmpiricalDistributionData data) {
                double mean = data.values[0];
                double stdDev = data.values[1];
                double skew = data.values[2];
                double y = skew * (x - mean);
                return NormalDistribution.gradLogPdf((double)x, (double)mean, (double)stdDev) + skew * NormalDistribution.pdf((double)y, (double)0.0, (double)stdDev) / NormalDistribution.cdf((double)y, (double)0.0, (double)stdDev, (boolean)false);
            }
        };
    }
}

