/*
 * Decompiled with CFR 0.152.
 */
package CustomLogging;

import CustomLogging.LoggingOutputStream;
import CustomLogging.StdOutErrLevel;
import CustomLogging.SuperSimpleFormatter;
import java.io.IOException;
import java.io.PrintStream;
import java.util.logging.FileHandler;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.logging.StreamHandler;

public class FileLoggedClass {
    public static void writeStdOutToLogFile() {
        try {
            Logger.getLogger("").addHandler(new StreamHandler());
            FileLoggedClass.suppressOrWriteToDebugLog();
        }
        catch (Error error) {
            System.out.println("Logger and or suppressOrWriteToDebugLog FAILING\n");
        }
    }

    public static void suppressOrWriteToDebugLog() {
        LogManager logManager = LogManager.getLogManager();
        logManager.reset();
        FileHandler fileHandler = null;
        try {
            fileHandler = new FileHandler("java_log.log", Integer.MAX_VALUE, 1, false);
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        fileHandler.setFormatter(new SuperSimpleFormatter());
        Logger.getLogger("").addHandler(fileHandler);
        Logger logger = Logger.getLogger("stdout");
        LoggingOutputStream loggingOutputStream = new LoggingOutputStream(logger, StdOutErrLevel.STDOUT);
        System.setOut(new PrintStream(loggingOutputStream, true));
        logger = Logger.getLogger("stderr");
        loggingOutputStream = new LoggingOutputStream(logger, StdOutErrLevel.STDERR);
        System.setErr(new PrintStream(loggingOutputStream, true));
    }
}

