/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jclec.exprtree.mut;

import net.sourceforge.jclec.exprtree.ExprTree;
import net.sourceforge.jclec.exprtree.ExprTreeSchema;
import net.sourceforge.jclec.exprtree.IMutateExprTree;
import net.sourceforge.jclec.exprtree.IPrimitive;
import net.sourceforge.jclec.util.random.IRandGen;

public class PromoteMutator
implements IMutateExprTree {
    private static final long serialVersionUID = 5710123544215454850L;

    public boolean equals(Object other) {
        return other instanceof PromoteMutator;
    }

    @Override
    public ExprTree mutateExprTree(ExprTree ptree, ExprTreeSchema schema, IRandGen randgen) {
        ExprTree stree = new ExprTree();
        int size = ptree.size();
        int maxSize = schema.getMaxTreeSize() - size;
        int maxArity = maxSize - 1;
        if (maxSize >= 1) {
            int i;
            int startIndex = randgen.choose(1, size);
            int endIndex = ptree.subTree(startIndex);
            int i2 = 0;
            while (i2 < startIndex) {
                stree.addBlock(ptree.getBlock(i2).copy());
                ++i2;
            }
            Class<?> rtype = ptree.getBlock(startIndex).returnType();
            IPrimitive result = this.functionBlockSuitable(maxArity, rtype, schema, randgen);
            if (result != null) {
                stree.addBlock(result);
                i = startIndex;
                while (i < ptree.subTree(startIndex)) {
                    stree.addBlock(ptree.getBlock(i));
                    ++i;
                }
                i = 1;
                while (i < result.argumentTypes().length) {
                    stree.addBlock(schema.getTerminalBlock(rtype, randgen));
                    ++i;
                }
            } else {
                i = startIndex;
                while (i < endIndex) {
                    stree.addBlock(ptree.getBlock(i).copy());
                    ++i;
                }
            }
            i = endIndex;
            while (i < size) {
                stree.addBlock(ptree.getBlock(i).copy());
                ++i;
            }
        } else {
            stree = ptree.copy();
        }
        return stree;
    }

    protected IPrimitive functionBlockSuitable(int maxArity, Class<?> rtype, ExprTreeSchema schema, IRandGen randgen) {
        IPrimitive result = null;
        int maxAttempt = schema.getNumFunctionBlocks(rtype);
        int attempt = 0;
        boolean noValid = true;
        do {
            if ((result = schema.getFunctionBlockBetweenMinMaxArity(rtype, randgen, 1, maxArity)) == null) {
                attempt = maxAttempt;
                continue;
            }
            Class<?>[] sonstype = result.argumentTypes();
            int i = 0;
            while (i < sonstype.length && noValid) {
                if (sonstype[i].equals(rtype)) {
                    noValid = false;
                }
                ++i;
            }
        } while (noValid && ++attempt < maxAttempt);
        return result.instance();
    }
}

