/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Instance_Generation.MCA;

import java.util.ArrayList;
import java.util.HashMap;
import keel.Algorithms.Instance_Generation.Basic.Prototype;
import keel.Algorithms.Instance_Generation.Basic.PrototypeSet;
import keel.Algorithms.Instance_Generation.MCA.PairOfPrototypes;
import keel.Algorithms.Instance_Generation.MCA.SymmetricDistanceMatrix;
import keel.Algorithms.Instance_Generation.utilities.Pair;

public class DistanceMatrixByClass {
    HashMap<Double, SymmetricDistanceMatrix> matrix = new HashMap();

    public DistanceMatrixByClass(PrototypeSet V) {
        ArrayList<Double> labels = Prototype.possibleValuesOfOutput();
        for (double label : labels) {
            PrototypeSet pLabelSet = V.getFromClass(label);
            if (pLabelSet.isEmpty()) continue;
            this.matrix.put(label, new SymmetricDistanceMatrix(pLabelSet));
        }
    }

    boolean containsLabel(double label) {
        return this.matrix.containsKey(label);
    }

    public ArrayList<Double> labels() {
        ArrayList<Double> presLabels = new ArrayList<Double>();
        ArrayList<Double> labels = new ArrayList<Double>(this.matrix.keySet());
        for (double label : labels) {
            if (!this.containsLabel(label)) continue;
            presLabels.add(label);
        }
        return presLabels;
    }

    private ArrayList<PairOfPrototypes> sortByNearness(double label) {
        SymmetricDistanceMatrix pSet = this.matrix.get(label);
        ArrayList<PairOfPrototypes> sorted = pSet.sortByNearness();
        return sorted;
    }

    public HashMap<Double, ArrayList<Pair<Prototype, Prototype>>> nearnestPrototypesForEachClass() {
        ArrayList<Double> labels = this.labels();
        HashMap<Double, ArrayList<Pair<Prototype, Prototype>>> n = new HashMap<Double, ArrayList<Pair<Prototype, Prototype>>>();
        for (double label : labels) {
            ArrayList<PairOfPrototypes> pLabel = this.sortByNearness(label);
            ArrayList<Pair<Prototype, Prototype>> goodPLabel = new ArrayList<Pair<Prototype, Prototype>>(pLabel.size());
            n.put(label, goodPLabel);
            for (PairOfPrototypes p : pLabel) {
                goodPLabel.add(p.getPair());
            }
        }
        return n;
    }

    public boolean remove(Prototype p, boolean makeUpdate) {
        double pLabel = p.label();
        SymmetricDistanceMatrix m = this.matrix.get(pLabel);
        return m.remove(p, makeUpdate);
    }

    public boolean remove(Prototype p) {
        double pLabel = p.label();
        SymmetricDistanceMatrix m = this.matrix.get(pLabel);
        return m.remove(p);
    }
}

