/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jclec.algorithm.niching;

import java.util.List;
import net.sf.jclec.IIndividual;
import net.sf.jclec.algorithm.niching.NichingAlgorithm;
import net.sf.jclec.fitness.IValueFitness;
import net.sf.jclec.fitness.SimpleValueFitness;
import org.apache.commons.configuration.Configuration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Sharing<I extends IIndividual>
extends NichingAlgorithm<I> {
    private static final long serialVersionUID = -3565568784140690740L;
    protected double alpha;
    protected boolean minimize = false;
    protected double[] shDistances;

    public final double getAlpha() {
        return this.alpha;
    }

    public final void setAlpha(double alpha) {
        this.alpha = alpha;
    }

    public final boolean isMinimize() {
        return this.minimize;
    }

    public final void setMinimize(boolean minimize) {
        this.minimize = minimize;
    }

    @Override
    public void configure(Configuration configuration) {
        super.configure(configuration);
        double alpha = configuration.getDouble("alpha");
        this.setAlpha(alpha);
        boolean minimize = configuration.getBoolean("minimize", false);
        this.setMinimize(minimize);
    }

    @Override
    protected void createNiches() {
        double radiusOfNiche = this.calculateRadiusNiche(this.bset);
        this.shDistances = this.calculateFitnessSharing(this.bset, radiusOfNiche);
        for (IIndividual ind : this.bset) {
            IIndividual individual = ind.copy();
            individual.setFitness(ind.getFitness().copy());
            this.nset.add(individual);
        }
        int i = 0;
        for (IIndividual ind : this.nset) {
            if (this.shDistances[i] != 0.0) {
                double valor;
                if (this.minimize) {
                    valor = ((IValueFitness)ind.getFitness()).getValue() * this.shDistances[i];
                    ((SimpleValueFitness)ind.getFitness()).setValue(valor);
                } else {
                    valor = ((IValueFitness)ind.getFitness()).getValue() / this.shDistances[i];
                    ((SimpleValueFitness)ind.getFitness()).setValue(valor);
                }
            }
            ++i;
        }
    }

    protected double[] calculateFitnessSharing(List<I> actpop, double radiusOfNiche) {
        double[] shDistance = new double[actpop.size()];
        double auxShDistance = 0.0;
        int i = 0;
        while (i < actpop.size()) {
            shDistance[i] = 0.0;
            int j = 0;
            while (j < actpop.size()) {
                double distance;
                auxShDistance = i != j ? ((distance = ((IIndividual)actpop.get(i)).distance((IIndividual)actpop.get(j))) < radiusOfNiche ? 1.0 - Math.pow(distance / radiusOfNiche, this.alpha) : 0.0) : 0.0;
                int n = i;
                shDistance[n] = shDistance[n] + auxShDistance;
                ++j;
            }
            ++i;
        }
        return shDistance;
    }

    public double calculateRadiusNiche(List<I> inds) {
        double maximumDistance = -1.0;
        int i = 0;
        while (i < inds.size()) {
            int j = i + 1;
            while (j < inds.size()) {
                if (maximumDistance < ((IIndividual)inds.get(i)).distance((IIndividual)inds.get(j))) {
                    maximumDistance = ((IIndividual)inds.get(i)).distance((IIndividual)inds.get(j));
                }
                ++j;
            }
            ++i;
        }
        return 0.2 * maximumDistance;
    }
}

