/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.layout;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.vecmath.Point2d;
import javax.vecmath.Tuple2d;
import javax.vecmath.Vector2d;
import org.openscience.cdk.geometry.GeometryUtil;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IRing;
import org.openscience.cdk.interfaces.IRingSet;
import org.openscience.cdk.layout.AtomPlacer;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

public class RingPlacer {
    static final String SNAP_HINT = "sdg.snap.bridged";
    public static final double RAD_30 = Math.toRadians(-30.0);
    static final boolean debug = false;
    private static final ILoggingTool logger = LoggingToolFactory.createLoggingTool(RingPlacer.class);
    private IAtomContainer molecule;
    private AtomPlacer atomPlacer = new AtomPlacer();
    static final int FUSED = 0;
    static final int BRIDGED = 1;
    static final int SPIRO = 2;
    public static final Map<Integer, Double> defaultAngles = new HashMap<Integer, Double>();
    public static final Map<Integer, Double> jcpAngles;
    static final Comparator<IRingSet> RING_COMPARATOR;
    private static final String NUM_HETERO_RINGS = "sdg:numHeteroRings";
    private static final String NUM_HETERO_ATOMS = "sdg:numHeteroAtoms";

    public void placeRing(IRing ring, IAtomContainer sharedAtoms, Point2d sharedAtomsCenter, Vector2d ringCenterVector, double bondLength) {
        int numSharedAtoms = sharedAtoms.getAtomCount();
        int numSharedBonds = sharedAtoms.getBondCount();
        logger.debug((Object)("placeRing -> sharedAtomCount: " + numSharedAtoms));
        if (numSharedAtoms > 2 && numSharedBonds > 1) {
            this.placeBridgedRing(ring, sharedAtoms, sharedAtomsCenter, ringCenterVector, bondLength);
        } else if (numSharedAtoms == 2 && numSharedBonds == 1) {
            this.placeFusedRing(ring, sharedAtoms, ringCenterVector, bondLength);
        } else if (numSharedAtoms == 1 && numSharedBonds == 0) {
            this.placeSpiroRing(ring, sharedAtoms, sharedAtomsCenter, ringCenterVector, bondLength);
        }
    }

    public void placeRing(IRing ring, Point2d ringCenter, double bondLength) {
        this.placeRing(ring, ringCenter, bondLength, defaultAngles);
    }

    public void placeRing(IRing ring, Point2d ringCenter, double bondLength, Map<Integer, Double> startAngles) {
        double radius = this.getNativeRingRadius(ring, bondLength);
        double addAngle = Math.PI * 2 / (double)ring.getRingSize();
        IAtom startAtom = ring.getAtom(0);
        Point2d p = new Point2d(ringCenter.x + radius, ringCenter.y);
        startAtom.setPoint2d(p);
        double startAngle = 1.5707963267948966;
        int ringSize = ring.getRingSize();
        if (startAngles.get(ringSize) != null) {
            startAngle = startAngles.get(ringSize);
        }
        List bonds = ring.getConnectedBondsList(startAtom);
        Vector<IAtom> atomsToDraw = new Vector<IAtom>();
        IAtom currentAtom = startAtom;
        IBond currentBond = (IBond)bonds.get(0);
        for (int i = 0; i < ring.getBondCount(); ++i) {
            currentBond = ring.getNextBond(currentBond, currentAtom);
            currentAtom = currentBond.getOther(currentAtom);
            atomsToDraw.addElement(currentAtom);
        }
        this.atomPlacer.populatePolygonCorners(atomsToDraw, ringCenter, startAngle, addAngle, radius);
    }

    public IAtomContainer placeRingSubstituents(IRingSet rs, double bondLength) {
        logger.debug((Object)"RingPlacer.placeRingSubstituents() start");
        IAtomContainer unplacedPartners = (IAtomContainer)rs.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
        IAtomContainer sharedAtoms = (IAtomContainer)rs.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
        IAtomContainer primaryAtoms = (IAtomContainer)rs.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
        IAtomContainer treatedAtoms = (IAtomContainer)rs.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
        for (int j = 0; j < rs.getAtomContainerCount(); ++j) {
            IRing ring = (IRing)rs.getAtomContainer(j);
            for (int k = 0; k < ring.getAtomCount(); ++k) {
                unplacedPartners.removeAllElements();
                sharedAtoms.removeAllElements();
                primaryAtoms.removeAllElements();
                IAtom atom = ring.getAtom(k);
                IRingSet rings = rs.getRings(atom);
                Point2d centerOfRingGravity = GeometryUtil.get2DCenter((IRingSet)rings);
                this.atomPlacer.partitionPartners(atom, unplacedPartners, sharedAtoms);
                AtomPlacer.markNotPlaced(unplacedPartners);
                try {
                    for (int f = 0; f < unplacedPartners.getAtomCount(); ++f) {
                        logger.debug((Object)("placeRingSubstituents->unplacedPartners: " + (this.molecule.indexOf(unplacedPartners.getAtom(f)) + 1)));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                treatedAtoms.add(unplacedPartners);
                if (unplacedPartners.getAtomCount() <= 0) continue;
                this.atomPlacer.distributePartners(atom, sharedAtoms, centerOfRingGravity, unplacedPartners, bondLength);
            }
        }
        logger.debug((Object)"RingPlacer.placeRingSubstituents() end");
        return treatedAtoms;
    }

    private static double det(double xa, double ya, double xb, double yb, double xc, double yc) {
        return (xa - xc) * (yb - yc) - (ya - yc) * (xb - xc);
    }

    private static double det(Point2d a, Point2d b, Point2d c) {
        return RingPlacer.det(a.x, a.y, b.x, b.y, c.x, c.y);
    }

    static int winding(Point2d a, Point2d b, Point2d c) {
        return (int)Math.signum(RingPlacer.det(a, b, c));
    }

    static int winding(IAtom a, IAtom b, IAtom c) {
        return RingPlacer.winding(a.getPoint2d(), b.getPoint2d(), c.getPoint2d());
    }

    static Vector2d toVec2d(IAtom beg, IAtom end) {
        return RingPlacer.toVec2d(beg.getPoint2d(), end.getPoint2d());
    }

    static Vector2d toVec2d(Point2d beg, Point2d end) {
        return new Vector2d(end.x - beg.x, end.y - beg.y);
    }

    private boolean isConcaveRing(List<IAtom> atoms) {
        if (atoms.size() < 4 || atoms.size() > 6) {
            return false;
        }
        for (IAtom atom : atoms) {
            if (atom.getProperty((Object)"layout.macrocycle.atom.hint") != null) continue;
            return false;
        }
        int ref = RingPlacer.winding(atoms.get(0), atoms.get(1), atoms.get(2));
        for (int i = 3; i < atoms.size(); ++i) {
            if (ref == RingPlacer.winding(atoms.get(i - 2), atoms.get(i - 1), atoms.get(i))) continue;
            return true;
        }
        return false;
    }

    private int getPlacedCount(IAtomContainer ring, IAtom atom) {
        int count = 0;
        for (IAtom nbor : ring.getConnectedAtomsList(atom)) {
            if (!nbor.getFlag(1)) continue;
            ++count;
        }
        return count;
    }

    private List<IAtom> rotate(List<IAtom> atoms, int r) {
        ArrayList<IAtom> res = new ArrayList<IAtom>();
        for (int i = 0; i < atoms.size(); ++i) {
            res.add(atoms.get((i + r) % atoms.size()));
        }
        return res;
    }

    private void makeRingConvex(IRing ring, List<IAtom> unplaced, double bondLength) {
        unplaced.clear();
        for (IAtom atom : ring.atoms()) {
            unplaced.add(atom);
        }
        List<IAtom> attach = this.getRingAttach(ring);
        assert (attach.size() == 2);
        unplaced = this.rotate(unplaced, unplaced.indexOf(attach.get(0)));
        Point2d ringCenter = GeometryUtil.get2DCenter(attach);
        Vector2d vec = RingPlacer.toVec2d(ringCenter, attach.get(0).getPoint2d());
        double tStep = Math.PI * 2 / (double)unplaced.size();
        double startAngle = Math.atan2(vec.y, vec.x) - tStep;
        double radius = bondLength / (2.0 * Math.sin(Math.PI / (double)unplaced.size()));
        this.atomPlacer.populatePolygonCorners(unplaced, ringCenter, startAngle, tStep, radius);
    }

    private List<IAtom> getRingAttach(IRing ring) {
        ArrayList<IAtom> pivots = new ArrayList<IAtom>(2);
        for (IAtom atom : ring.atoms()) {
            int count;
            if (!atom.getFlag(1) || (count = this.getPlacedCount((IAtomContainer)ring, atom)) != 1) continue;
            pivots.add(atom);
        }
        return pivots;
    }

    private void placeBridgedRing(IRing ring, IAtomContainer sharedAtoms, Point2d sharedAtomsCenter, Vector2d ringCenterVector, double bondLength) {
        Point2d ringCenter;
        boolean swap;
        boolean snap;
        IAtom[] bridgeAtoms = this.getBridgeAtoms(sharedAtoms);
        IAtom bondAtom1 = bridgeAtoms[0];
        IAtom bondAtom2 = bridgeAtoms[1];
        ArrayList<IAtom> otherAtoms = new ArrayList<IAtom>();
        for (IAtom atom : sharedAtoms.atoms()) {
            if (atom.equals(bondAtom1) || atom.equals(bondAtom2)) continue;
            otherAtoms.add(atom);
        }
        boolean bl = snap = ring.getProperty((Object)SNAP_HINT) != null && (Boolean)ring.getProperty((Object)SNAP_HINT, Boolean.class) != false;
        boolean bl2 = snap ? RingPlacer.det(bondAtom1.getPoint2d(), GeometryUtil.get2DCenter(otherAtoms), bondAtom2.getPoint2d()) < 0.0 : (swap = RingPlacer.det(bondAtom1.getPoint2d(), GeometryUtil.get2DCenter(otherAtoms), bondAtom2.getPoint2d()) > 0.0);
        if (swap) {
            IAtom tmp = bondAtom1;
            bondAtom1 = bondAtom2;
            bondAtom2 = tmp;
        }
        Vector2d bondAtom1Vector = new Vector2d((Tuple2d)bondAtom1.getPoint2d());
        Vector2d bondAtom2Vector = new Vector2d((Tuple2d)bondAtom2.getPoint2d());
        Point2d midPoint = RingPlacer.getMidPoint((Tuple2d)bondAtom1Vector, (Tuple2d)bondAtom2Vector);
        double radius = this.getNativeRingRadius(ring, bondLength);
        double offset = 0.0;
        if (snap) {
            ringCenter = new Point2d(midPoint);
            ringCenterVector = RingPlacer.getPerpendicular((Tuple2d)bondAtom1Vector, (Tuple2d)bondAtom2Vector, new Vector2d(midPoint.x - sharedAtomsCenter.x, midPoint.y - sharedAtomsCenter.y));
            offset = 0.0;
            for (IAtom atom : otherAtoms) {
                double dist = atom.getPoint2d().distance(midPoint);
                if (!(dist > offset)) continue;
                offset = dist;
            }
        } else {
            ringCenter = new Point2d(sharedAtomsCenter);
        }
        ringCenterVector.normalize();
        ringCenterVector.scale(radius - offset);
        ringCenter.add((Tuple2d)ringCenterVector);
        bondAtom1Vector.sub((Tuple2d)ringCenter);
        bondAtom2Vector.sub((Tuple2d)ringCenter);
        int numUnplaced = ring.getRingSize() - sharedAtoms.getAtomCount();
        double dot = bondAtom2Vector.x * bondAtom1Vector.x + bondAtom2Vector.y * bondAtom1Vector.y;
        double det = bondAtom2Vector.x * bondAtom1Vector.y - bondAtom2Vector.y * bondAtom1Vector.x;
        double tRemain = Math.atan2(det, dot);
        if (tRemain < 0.0) {
            tRemain = Math.PI + (Math.PI + tRemain);
        }
        double tStep = tRemain / (double)(numUnplaced + 1);
        logger.debug((Object)("placeBridgedRing->tRemain: " + Math.toDegrees(tRemain)));
        logger.debug((Object)("placeBridgedRing->tStep: " + Math.toDegrees(tStep)));
        int direction = -1;
        double startAngle = GeometryUtil.getAngle((double)(bondAtom1.getPoint2d().x - ringCenter.x), (double)(bondAtom1.getPoint2d().y - ringCenter.y));
        IAtom currentAtom = bondAtom1;
        IBond currentBond = (IBond)sharedAtoms.getConnectedBondsList(currentAtom).get(0);
        ArrayList<IAtom> placed = new ArrayList<IAtom>();
        ArrayList<IAtom> unplaced = new ArrayList<IAtom>();
        for (int i = 0; i < ring.getBondCount(); ++i) {
            if (!sharedAtoms.contains(currentAtom = (currentBond = ring.getNextBond(currentBond, currentAtom)).getOther(currentAtom))) {
                unplaced.add(currentAtom);
                continue;
            }
            placed.add(currentAtom);
        }
        if (this.isConcaveRing(placed)) {
            this.makeRingConvex(ring, unplaced, bondLength);
        } else {
            logger.debug((Object)("placeBridgedRing->atomsToPlace: " + AtomPlacer.listNumbers(this.molecule, unplaced)));
            logger.debug((Object)("placeBridgedRing->startAngle: " + Math.toDegrees(startAngle)));
            logger.debug((Object)("placeBridgedRing->tStep: " + Math.toDegrees(tStep)));
            this.atomPlacer.populatePolygonCorners(unplaced, ringCenter, startAngle, -tStep, radius);
        }
    }

    public void placeSpiroRing(IRing ring, IAtomContainer sharedAtoms, Point2d sharedAtomsCenter, Vector2d ringCenterVector, double bondLength) {
        IAtom startAtom = sharedAtoms.getAtom(0);
        List mBonds = this.molecule.getConnectedBondsList(sharedAtoms.getAtom(0));
        int degree = mBonds.size();
        logger.debug((Object)"placeSpiroRing: D=", new Object[]{degree});
        if (degree != 4) {
            int numPlaced = 0;
            for (IBond bond : mBonds) {
                IAtom nbr = bond.getOther(sharedAtoms.getAtom(0));
                if (!nbr.getFlag(1)) continue;
                ++numPlaced;
            }
            if (numPlaced == 2) {
                startAtom.getPoint2d().add((Tuple2d)ringCenterVector);
                sharedAtomsCenter.add((Tuple2d)ringCenterVector);
            }
            double theta = Math.PI - Math.PI * 2 / ((double)degree / 2.0);
            this.rotate(ringCenterVector, theta);
        }
        double radius = this.getNativeRingRadius(ring, bondLength);
        Point2d ringCenter = new Point2d(sharedAtomsCenter);
        if (degree == 4) {
            ringCenterVector.normalize();
            ringCenterVector.scale(radius);
        } else {
            ringCenterVector.normalize();
            ringCenterVector.scale(2.0 * radius);
        }
        ringCenter.add((Tuple2d)ringCenterVector);
        double addAngle = Math.PI * 2 / (double)ring.getRingSize();
        IAtom currentAtom = startAtom;
        double startAngle = GeometryUtil.getAngle((double)(startAtom.getPoint2d().x - ringCenter.x), (double)(startAtom.getPoint2d().y - ringCenter.y));
        List rBonds = ring.getConnectedBondsList(startAtom);
        IBond currentBond = (IBond)rBonds.get(0);
        Vector<IAtom> atomsToDraw = new Vector<IAtom>();
        for (int i = 0; i < ring.getBondCount(); ++i) {
            if ((currentAtom = (currentBond = ring.getNextBond(currentBond, currentAtom)).getOther(currentAtom)).equals(startAtom)) continue;
            atomsToDraw.addElement(currentAtom);
        }
        logger.debug((Object)("currentAtom  " + currentAtom));
        logger.debug((Object)("startAtom  " + startAtom));
        this.atomPlacer.populatePolygonCorners(atomsToDraw, ringCenter, startAngle, addAngle, radius);
    }

    public void placeFusedRing(IRing ring, IAtomContainer sharedAtoms, Vector2d ringCenterVector, double bondLength) {
        int direction;
        IAtom startAtom;
        logger.debug((Object)"RingPlacer.placeFusedRing() start");
        IAtom beg = sharedAtoms.getAtom(0);
        IAtom end = sharedAtoms.getAtom(1);
        Vector2d pBeg = new Vector2d((Tuple2d)beg.getPoint2d());
        Vector2d pEnd = new Vector2d((Tuple2d)end.getPoint2d());
        ringCenterVector = RingPlacer.getPerpendicular((Tuple2d)pBeg, (Tuple2d)pEnd, ringCenterVector);
        double radius = this.getNativeRingRadius(ring, bondLength);
        double newRingPerpendicular = Math.sqrt(Math.pow(radius, 2.0) - Math.pow(bondLength / 2.0, 2.0));
        ringCenterVector.normalize();
        logger.debug((Object)("placeFusedRing->: ringCenterVector.length()" + ringCenterVector.length()));
        ringCenterVector.scale(newRingPerpendicular);
        Point2d ringCenter = RingPlacer.getMidPoint((Tuple2d)pBeg, (Tuple2d)pEnd);
        ringCenter.add((Tuple2d)ringCenterVector);
        Vector2d originRingCenterVector = new Vector2d((Tuple2d)ringCenter);
        pBeg.sub((Tuple2d)originRingCenterVector);
        pEnd.sub((Tuple2d)originRingCenterVector);
        double occupiedAngle = RingPlacer.angle(pBeg, pEnd);
        double remainingAngle = Math.PI * 2 - occupiedAngle;
        double addAngle = remainingAngle / (double)(ring.getRingSize() - 1);
        logger.debug((Object)("placeFusedRing->occupiedAngle: " + Math.toDegrees(occupiedAngle)));
        logger.debug((Object)("placeFusedRing->remainingAngle: " + Math.toDegrees(remainingAngle)));
        logger.debug((Object)("placeFusedRing->addAngle: " + Math.toDegrees(addAngle)));
        double centerX = ringCenter.x;
        double centerY = ringCenter.y;
        double xDiff = beg.getPoint2d().x - end.getPoint2d().x;
        double yDiff = beg.getPoint2d().y - end.getPoint2d().y;
        if (xDiff == 0.0) {
            logger.debug((Object)"placeFusedRing->Bond is vertical");
            startAtom = beg.getPoint2d().y > end.getPoint2d().y ? beg : end;
            direction = centerX < beg.getPoint2d().x ? 1 : -1;
        } else {
            startAtom = beg.getPoint2d().x > end.getPoint2d().x ? beg : end;
            direction = centerY - beg.getPoint2d().y > (centerX - beg.getPoint2d().x) * yDiff / xDiff ? 1 : -1;
        }
        double startAngle = GeometryUtil.getAngle((double)(startAtom.getPoint2d().x - ringCenter.x), (double)(startAtom.getPoint2d().y - ringCenter.y));
        IAtom currentAtom = startAtom;
        IBond currentBond = sharedAtoms.getBond(0);
        Vector<IAtom> atomsToDraw = new Vector<IAtom>();
        for (int i = 0; i < ring.getBondCount() - 2; ++i) {
            currentBond = ring.getNextBond(currentBond, currentAtom);
            currentAtom = currentBond.getOther(currentAtom);
            atomsToDraw.addElement(currentAtom);
        }
        logger.debug((Object)("placeFusedRing->startAngle: " + Math.toDegrees(startAngle)));
        logger.debug((Object)("placeFusedRing->addAngle: " + Math.toDegrees(addAngle *= (double)direction)));
        logger.debug((Object)("placeFusedRing->startAtom is: " + (this.molecule.indexOf(startAtom) + 1)));
        logger.debug((Object)("AtomsToDraw: " + AtomPlacer.listNumbers(this.molecule, atomsToDraw)));
        this.atomPlacer.populatePolygonCorners(atomsToDraw, ringCenter, startAngle, addAngle, radius);
    }

    boolean completePartiallyPlacedRing(IRingSet rset, IRing ring, double bondLength) {
        if (ring.getFlag(1)) {
            return true;
        }
        IRing partiallyPlacedRing = (IRing)this.molecule.getBuilder().newInstance(IRing.class, new Object[0]);
        for (IAtom atom : ring.atoms()) {
            if (atom.getPoint2d() == null) continue;
            atom.setFlag(1, true);
        }
        AtomPlacer.copyPlaced(partiallyPlacedRing, (IAtomContainer)ring);
        if (partiallyPlacedRing.getAtomCount() > 1 && partiallyPlacedRing.getAtomCount() < ring.getAtomCount()) {
            this.placeConnectedRings(rset, partiallyPlacedRing, 0, bondLength);
            this.placeConnectedRings(rset, partiallyPlacedRing, 1, bondLength);
            this.placeConnectedRings(rset, partiallyPlacedRing, 2, bondLength);
            ring.setFlag(1, true);
            return true;
        }
        return false;
    }

    private static Point2d getMidPoint(Tuple2d a, Tuple2d b) {
        return new Point2d((a.x + b.x) / 2.0, (a.y + b.y) / 2.0);
    }

    private static double angle(Vector2d pBeg, Vector2d pEnd) {
        return pBeg.angle(pEnd);
    }

    private static Vector2d getPerpendicular(Tuple2d a, Tuple2d b, Vector2d ref) {
        Vector2d pVec = new Vector2d(-(a.y - b.y), a.x - b.x);
        if (pVec.dot(ref) < 0.0) {
            pVec.negate();
        }
        return pVec;
    }

    public boolean allPlaced(IRingSet rs) {
        for (int i = 0; i < rs.getAtomContainerCount(); ++i) {
            if (rs.getAtomContainer(i).getFlag(1)) continue;
            return false;
        }
        return true;
    }

    public void checkAndMarkPlaced(IRingSet rs) {
        boolean ringsetPlaced = true;
        for (int i = 0; i < rs.getAtomContainerCount(); ++i) {
            IRing ring = (IRing)rs.getAtomContainer(i);
            boolean allPlaced = true;
            for (int j = 0; j < ring.getAtomCount(); ++j) {
                if (ring.getAtom(j).getFlag(1)) continue;
                allPlaced = false;
                ringsetPlaced = false;
                break;
            }
            ring.setFlag(1, allPlaced);
        }
        rs.setFlag(1, ringsetPlaced);
    }

    private IAtom[] getBridgeAtoms(IAtomContainer sharedAtoms) {
        IAtom[] bridgeAtoms = new IAtom[2];
        int counter = 0;
        for (int f = 0; f < sharedAtoms.getAtomCount(); ++f) {
            IAtom atom = sharedAtoms.getAtom(f);
            if (sharedAtoms.getConnectedAtomsList(atom).size() != 1) continue;
            bridgeAtoms[counter] = atom;
            ++counter;
        }
        return bridgeAtoms;
    }

    public void partitionNonRingPartners(IAtom atom, IRing ring, IAtomContainer ringAtoms, IAtomContainer nonRingAtoms) {
        List atoms = this.molecule.getConnectedAtomsList(atom);
        for (Object o : atoms) {
            IAtom curAtom = (IAtom)o;
            if (!ring.contains(curAtom)) {
                nonRingAtoms.addAtom(curAtom);
                continue;
            }
            ringAtoms.addAtom(curAtom);
        }
    }

    public double getNativeRingRadius(IRing ring, double bondLength) {
        int size = ring.getAtomCount();
        double radius = bondLength / (2.0 * Math.sin(Math.PI / (double)size));
        return radius;
    }

    Vector2d getRingCenterOfFirstRing(IRing ring, Vector2d bondVector, double bondLength) {
        int size = ring.getAtomCount();
        double radius = bondLength / (2.0 * Math.sin(Math.PI / (double)size));
        double newRingPerpendicular = Math.sqrt(Math.pow(radius, 2.0) - Math.pow(bondLength / 2.0, 2.0));
        double rotangle = GeometryUtil.getAngle((double)bondVector.x, (double)bondVector.y);
        return new Vector2d(Math.cos(rotangle += 1.5707963267948966) * newRingPerpendicular, Math.sin(rotangle) * newRingPerpendicular);
    }

    private void rotate(Vector2d vec, double rad) {
        double rx = vec.x * Math.cos(rad) - vec.y * Math.sin(rad);
        double ry = vec.x * Math.sin(rad) + vec.y * Math.cos(rad);
        vec.x = rx;
        vec.y = ry;
    }

    void placeConnectedRings(IRingSet rs, IRing ring, int handleType, double bondLength) {
        IRingSet connectedRings = rs.getConnectedRings(ring);
        for (IAtomContainer container : connectedRings.atomContainers()) {
            IRing connectedRing = (IRing)container;
            if (connectedRing.getFlag(1)) continue;
            IAtomContainer sharedAtoms = AtomContainerManipulator.getIntersection((IAtomContainer)ring, (IAtomContainer)connectedRing);
            int numSharedAtoms = sharedAtoms.getAtomCount();
            logger.debug((Object)("placeConnectedRings-> connectedRing: " + ring));
            if (!(numSharedAtoms == 2 && handleType == 0 || numSharedAtoms == 1 && handleType == 2) && (numSharedAtoms <= 2 || handleType != 1)) continue;
            Point2d sharedAtomsCenter = GeometryUtil.get2DCenter((IAtomContainer)sharedAtoms);
            Point2d oldRingCenter = GeometryUtil.get2DCenter((IAtomContainer)ring);
            Vector2d tempVector = new Vector2d((Tuple2d)sharedAtomsCenter);
            Vector2d newRingCenterVector = new Vector2d(tempVector);
            newRingCenterVector.sub((Tuple2d)new Vector2d((Tuple2d)oldRingCenter));
            if (Math.abs(newRingCenterVector.x) < 0.001 && Math.abs(newRingCenterVector.y) < 0.001) {
                IAtomContainer terminalOnly = (IAtomContainer)this.molecule.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
                for (IAtom atom : ring.atoms()) {
                    if (ring.getConnectedBondsCount(atom) != 1) continue;
                    terminalOnly.addAtom(atom);
                }
                if (terminalOnly.getAtomCount() == 2) {
                    newRingCenterVector.set((Tuple2d)GeometryUtil.get2DCenter((IAtomContainer)terminalOnly));
                    newRingCenterVector.sub((Tuple2d)oldRingCenter);
                    connectedRing.setProperty((Object)SNAP_HINT, (Object)true);
                } else {
                    Vector2d vec = new Vector2d(0.0, 1.0);
                    double bestLen = -1.7976931348623157E308;
                    for (int i = 0; i < 12; ++i) {
                        Vector2d orth = new Vector2d(-vec.y, vec.x);
                        orth.normalize();
                        double min = Double.MAX_VALUE;
                        double max = -1.7976931348623157E308;
                        for (IAtom atom : sharedAtoms.atoms()) {
                            double s = orth.dot(new Vector2d((Tuple2d)atom.getPoint2d()));
                            if (s < min) {
                                min = s;
                            }
                            if (!(s > max)) continue;
                            max = s;
                        }
                        double len = max - min;
                        if (len > bestLen) {
                            bestLen = len;
                            newRingCenterVector.set((Tuple2d)vec);
                        }
                        this.rotate(vec, RAD_30);
                    }
                }
            }
            Vector2d oldRingCenterVector = new Vector2d(newRingCenterVector);
            logger.debug((Object)("placeConnectedRing -> tempVector: " + tempVector + ", tempVector.length: " + tempVector.length()));
            logger.debug((Object)("placeConnectedRing -> bondCenter: " + sharedAtomsCenter));
            logger.debug((Object)("placeConnectedRing -> oldRingCenterVector.length(): " + oldRingCenterVector.length()));
            logger.debug((Object)("placeConnectedRing -> newRingCenterVector.length(): " + newRingCenterVector.length()));
            Point2d tempPoint = new Point2d(sharedAtomsCenter);
            tempPoint.add((Tuple2d)newRingCenterVector);
            this.placeRing(connectedRing, sharedAtoms, sharedAtomsCenter, newRingCenterVector, bondLength);
            connectedRing.setFlag(1, true);
            this.placeConnectedRings(rs, connectedRing, handleType, bondLength);
        }
    }

    public IAtomContainer getMolecule() {
        return this.molecule;
    }

    public void setMolecule(IAtomContainer molecule) {
        this.molecule = molecule;
    }

    public AtomPlacer getAtomPlacer() {
        return this.atomPlacer;
    }

    public void setAtomPlacer(AtomPlacer atomPlacer) {
        this.atomPlacer = atomPlacer;
    }

    static void countHetero(List<IRingSet> rsets) {
        for (IRingSet rset : rsets) {
            int numHeteroAtoms = 0;
            int numHeteroRings = 0;
            for (IAtomContainer ring : rset.atomContainers()) {
                int prevNumHeteroAtoms = numHeteroAtoms;
                for (IAtom atom : ring.atoms()) {
                    Integer elem = atom.getAtomicNumber();
                    if (elem == null || elem == 6 || elem == 1) continue;
                    ++numHeteroAtoms;
                }
                if (numHeteroAtoms <= prevNumHeteroAtoms) continue;
                ++numHeteroRings;
            }
            rset.setProperty((Object)NUM_HETERO_ATOMS, (Object)numHeteroAtoms);
            rset.setProperty((Object)NUM_HETERO_RINGS, (Object)numHeteroRings);
        }
    }

    static {
        defaultAngles.put(3, 0.523598880318054);
        defaultAngles.put(4, 0.7853981633974483);
        defaultAngles.put(5, 0.9424777960769379);
        defaultAngles.put(7, 0.21991148575128555);
        defaultAngles.put(8, 0.39269908169872414);
        jcpAngles = new HashMap<Integer, Double>();
        jcpAngles.put(3, 1.5707963267948966);
        jcpAngles.put(4, 0.7853981633974483);
        jcpAngles.put(5, 1.5707963267948966);
        jcpAngles.put(7, 0.21991148575128555);
        jcpAngles.put(8, 0.39269908169872414);
        RING_COMPARATOR = new Comparator<IRingSet>(){

            @Override
            public int compare(IRingSet a, IRingSet b) {
                int cmp = Boolean.compare(a.getAtomContainerCount() == 1, b.getAtomContainerCount() == 1);
                if (cmp != 0) {
                    return cmp;
                }
                Integer numHeteroRingA = (Integer)a.getProperty((Object)RingPlacer.NUM_HETERO_RINGS);
                Integer numHeteroRingB = (Integer)b.getProperty((Object)RingPlacer.NUM_HETERO_RINGS);
                if (numHeteroRingA == null) {
                    numHeteroRingA = 0;
                }
                if (numHeteroRingB == null) {
                    numHeteroRingB = 0;
                }
                if ((cmp = -Integer.compare(numHeteroRingA, numHeteroRingB)) != 0) {
                    return cmp;
                }
                Integer numHeteroAtomA = (Integer)a.getProperty((Object)RingPlacer.NUM_HETERO_ATOMS);
                Integer numHeteroAtomB = (Integer)b.getProperty((Object)RingPlacer.NUM_HETERO_ATOMS);
                if (numHeteroAtomA == null) {
                    numHeteroAtomA = 0;
                }
                if (numHeteroAtomB == null) {
                    numHeteroAtomB = 0;
                }
                if ((cmp = -Integer.compare(numHeteroAtomA, numHeteroAtomB)) != 0) {
                    return cmp;
                }
                return -Integer.compare(a.getAtomContainerCount(), b.getAtomContainerCount());
            }
        };
    }
}

