/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.math.matrices.decomposition;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.math.Constants;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.MatrixException;

public class Householder {
    private double[] qr;
    private double[] rdiag;
    private int n;
    private int m;

    public Householder(FastMatrix A) {
        this.init(A);
        this.householder(true, Constants.getEpsilon());
    }

    public Householder(FastMatrix A, boolean fast, double eps) {
        this.init(A);
        this.householder(fast, eps);
    }

    public DoubleSeq rDiagonal() {
        return DoubleSeq.of((double[])this.rdiag);
    }

    private void householder(boolean fast, double eps) {
        int len = this.qr.length;
        int k0 = 0;
        int k1 = this.m;
        for (int k = 0; k < this.n; ++k) {
            double nrm;
            DataBlock col = DataBlock.of(this.qr, k0, k1, 1);
            double d = nrm = fast ? col.fastNorm2() : col.norm2();
            if (nrm > eps) {
                if (this.qr[k0] < -eps) {
                    nrm = -nrm;
                }
                int i = k0;
                while (i < k1) {
                    int n = i++;
                    this.qr[n] = this.qr[n] / nrm;
                }
                int n = k0;
                this.qr[n] = this.qr[n] + 1.0;
                this.rdiag[k] = -nrm;
                for (int jm = k0 + this.m; jm < len; jm += this.m) {
                    double s = 0.0;
                    int ik = k0;
                    int ij = jm;
                    while (ik < k1) {
                        s += this.qr[ik] * this.qr[ij];
                        ++ik;
                        ++ij;
                    }
                    s /= -this.qr[k0];
                    ij = jm;
                    for (ik = k0; ik < k1; ++ik) {
                        int n2 = ij++;
                        this.qr[n2] = this.qr[n2] + s * this.qr[ik];
                    }
                }
                k0 += this.m + 1;
                k1 += this.m;
                continue;
            }
            throw new MatrixException("m_err_sing");
        }
    }

    private void init(FastMatrix M) {
        this.m = M.getRowsCount();
        this.n = M.getColumnsCount();
        this.qr = M.toArray();
        this.rdiag = new double[this.n];
    }
}

