/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.regarima.diagnostics;

import java.util.concurrent.atomic.AtomicReference;
import jdplus.toolkit.base.api.processing.DiagnosticsConfiguration;
import lombok.Generated;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class ResidualsDiagnosticsConfiguration
implements DiagnosticsConfiguration {
    private static final AtomicReference<ResidualsDiagnosticsConfiguration> DEFAULT = new AtomicReference<ResidualsDiagnosticsConfiguration>(ResidualsDiagnosticsConfiguration.builder().build());
    public static final boolean ACTIVE = true;
    private final boolean active;
    public static final double NBAD = 0.01;
    public static final double NUNC = 0.1;
    public static final double TDSEV = 0.001;
    public static final double TDBAD = 0.01;
    public static final double TDUNC = 0.1;
    public static final double SSEV = 0.001;
    public static final double SBAD = 0.01;
    public static final double SUNC = 0.1;
    private final double badThresholdForNormality;
    private final double uncertainThresholdForNormality;
    private final double severeThresholdForTradingDaysPeak;
    private final double badThresholdForTradingDaysPeak;
    private final double uncertainThresholdForTradingDaysPeak;
    private final double severeThresholdForSeasonalPeaks;
    private final double badThresholdForSeasonalPeaks;
    private final double uncertainThresholdForSeasonalPeaks;

    public static void setDefault(ResidualsDiagnosticsConfiguration config) {
        DEFAULT.set(config);
    }

    public static ResidualsDiagnosticsConfiguration getDefault() {
        return DEFAULT.get();
    }

    public static Builder builder() {
        return new Builder().active(true).badThresholdForNormality(0.01).uncertainThresholdForNormality(0.1).severeThresholdForTradingDaysPeak(0.001).badThresholdForTradingDaysPeak(0.01).uncertainThresholdForTradingDaysPeak(0.1).severeThresholdForSeasonalPeaks(0.001).badThresholdForSeasonalPeaks(0.01).uncertainThresholdForSeasonalPeaks(0.1);
    }

    public DiagnosticsConfiguration activate(boolean active) {
        if (this.active == active) {
            return this;
        }
        return this.toBuilder().active(active).build();
    }

    @Generated
    ResidualsDiagnosticsConfiguration(boolean active, double badThresholdForNormality, double uncertainThresholdForNormality, double severeThresholdForTradingDaysPeak, double badThresholdForTradingDaysPeak, double uncertainThresholdForTradingDaysPeak, double severeThresholdForSeasonalPeaks, double badThresholdForSeasonalPeaks, double uncertainThresholdForSeasonalPeaks) {
        this.active = active;
        this.badThresholdForNormality = badThresholdForNormality;
        this.uncertainThresholdForNormality = uncertainThresholdForNormality;
        this.severeThresholdForTradingDaysPeak = severeThresholdForTradingDaysPeak;
        this.badThresholdForTradingDaysPeak = badThresholdForTradingDaysPeak;
        this.uncertainThresholdForTradingDaysPeak = uncertainThresholdForTradingDaysPeak;
        this.severeThresholdForSeasonalPeaks = severeThresholdForSeasonalPeaks;
        this.badThresholdForSeasonalPeaks = badThresholdForSeasonalPeaks;
        this.uncertainThresholdForSeasonalPeaks = uncertainThresholdForSeasonalPeaks;
    }

    @Generated
    public @NonNull Builder toBuilder() {
        return new Builder().active(this.active).badThresholdForNormality(this.badThresholdForNormality).uncertainThresholdForNormality(this.uncertainThresholdForNormality).severeThresholdForTradingDaysPeak(this.severeThresholdForTradingDaysPeak).badThresholdForTradingDaysPeak(this.badThresholdForTradingDaysPeak).uncertainThresholdForTradingDaysPeak(this.uncertainThresholdForTradingDaysPeak).severeThresholdForSeasonalPeaks(this.severeThresholdForSeasonalPeaks).badThresholdForSeasonalPeaks(this.badThresholdForSeasonalPeaks).uncertainThresholdForSeasonalPeaks(this.uncertainThresholdForSeasonalPeaks);
    }

    @Generated
    public boolean isActive() {
        return this.active;
    }

    @Generated
    public double getBadThresholdForNormality() {
        return this.badThresholdForNormality;
    }

    @Generated
    public double getUncertainThresholdForNormality() {
        return this.uncertainThresholdForNormality;
    }

    @Generated
    public double getSevereThresholdForTradingDaysPeak() {
        return this.severeThresholdForTradingDaysPeak;
    }

    @Generated
    public double getBadThresholdForTradingDaysPeak() {
        return this.badThresholdForTradingDaysPeak;
    }

    @Generated
    public double getUncertainThresholdForTradingDaysPeak() {
        return this.uncertainThresholdForTradingDaysPeak;
    }

    @Generated
    public double getSevereThresholdForSeasonalPeaks() {
        return this.severeThresholdForSeasonalPeaks;
    }

    @Generated
    public double getBadThresholdForSeasonalPeaks() {
        return this.badThresholdForSeasonalPeaks;
    }

    @Generated
    public double getUncertainThresholdForSeasonalPeaks() {
        return this.uncertainThresholdForSeasonalPeaks;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResidualsDiagnosticsConfiguration)) {
            return false;
        }
        ResidualsDiagnosticsConfiguration other = (ResidualsDiagnosticsConfiguration)o;
        if (this.isActive() != other.isActive()) {
            return false;
        }
        if (Double.compare(this.getBadThresholdForNormality(), other.getBadThresholdForNormality()) != 0) {
            return false;
        }
        if (Double.compare(this.getUncertainThresholdForNormality(), other.getUncertainThresholdForNormality()) != 0) {
            return false;
        }
        if (Double.compare(this.getSevereThresholdForTradingDaysPeak(), other.getSevereThresholdForTradingDaysPeak()) != 0) {
            return false;
        }
        if (Double.compare(this.getBadThresholdForTradingDaysPeak(), other.getBadThresholdForTradingDaysPeak()) != 0) {
            return false;
        }
        if (Double.compare(this.getUncertainThresholdForTradingDaysPeak(), other.getUncertainThresholdForTradingDaysPeak()) != 0) {
            return false;
        }
        if (Double.compare(this.getSevereThresholdForSeasonalPeaks(), other.getSevereThresholdForSeasonalPeaks()) != 0) {
            return false;
        }
        if (Double.compare(this.getBadThresholdForSeasonalPeaks(), other.getBadThresholdForSeasonalPeaks()) != 0) {
            return false;
        }
        return Double.compare(this.getUncertainThresholdForSeasonalPeaks(), other.getUncertainThresholdForSeasonalPeaks()) == 0;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isActive() ? 79 : 97);
        long $badThresholdForNormality = Double.doubleToLongBits(this.getBadThresholdForNormality());
        result = result * 59 + (int)($badThresholdForNormality >>> 32 ^ $badThresholdForNormality);
        long $uncertainThresholdForNormality = Double.doubleToLongBits(this.getUncertainThresholdForNormality());
        result = result * 59 + (int)($uncertainThresholdForNormality >>> 32 ^ $uncertainThresholdForNormality);
        long $severeThresholdForTradingDaysPeak = Double.doubleToLongBits(this.getSevereThresholdForTradingDaysPeak());
        result = result * 59 + (int)($severeThresholdForTradingDaysPeak >>> 32 ^ $severeThresholdForTradingDaysPeak);
        long $badThresholdForTradingDaysPeak = Double.doubleToLongBits(this.getBadThresholdForTradingDaysPeak());
        result = result * 59 + (int)($badThresholdForTradingDaysPeak >>> 32 ^ $badThresholdForTradingDaysPeak);
        long $uncertainThresholdForTradingDaysPeak = Double.doubleToLongBits(this.getUncertainThresholdForTradingDaysPeak());
        result = result * 59 + (int)($uncertainThresholdForTradingDaysPeak >>> 32 ^ $uncertainThresholdForTradingDaysPeak);
        long $severeThresholdForSeasonalPeaks = Double.doubleToLongBits(this.getSevereThresholdForSeasonalPeaks());
        result = result * 59 + (int)($severeThresholdForSeasonalPeaks >>> 32 ^ $severeThresholdForSeasonalPeaks);
        long $badThresholdForSeasonalPeaks = Double.doubleToLongBits(this.getBadThresholdForSeasonalPeaks());
        result = result * 59 + (int)($badThresholdForSeasonalPeaks >>> 32 ^ $badThresholdForSeasonalPeaks);
        long $uncertainThresholdForSeasonalPeaks = Double.doubleToLongBits(this.getUncertainThresholdForSeasonalPeaks());
        result = result * 59 + (int)($uncertainThresholdForSeasonalPeaks >>> 32 ^ $uncertainThresholdForSeasonalPeaks);
        return result;
    }

    @Generated
    public @NonNull String toString() {
        return "ResidualsDiagnosticsConfiguration(active=" + this.isActive() + ", badThresholdForNormality=" + this.getBadThresholdForNormality() + ", uncertainThresholdForNormality=" + this.getUncertainThresholdForNormality() + ", severeThresholdForTradingDaysPeak=" + this.getSevereThresholdForTradingDaysPeak() + ", badThresholdForTradingDaysPeak=" + this.getBadThresholdForTradingDaysPeak() + ", uncertainThresholdForTradingDaysPeak=" + this.getUncertainThresholdForTradingDaysPeak() + ", severeThresholdForSeasonalPeaks=" + this.getSevereThresholdForSeasonalPeaks() + ", badThresholdForSeasonalPeaks=" + this.getBadThresholdForSeasonalPeaks() + ", uncertainThresholdForSeasonalPeaks=" + this.getUncertainThresholdForSeasonalPeaks() + ")";
    }

    @Generated
    public static class Builder {
        @Generated
        private boolean active;
        @Generated
        private double badThresholdForNormality;
        @Generated
        private double uncertainThresholdForNormality;
        @Generated
        private double severeThresholdForTradingDaysPeak;
        @Generated
        private double badThresholdForTradingDaysPeak;
        @Generated
        private double uncertainThresholdForTradingDaysPeak;
        @Generated
        private double severeThresholdForSeasonalPeaks;
        @Generated
        private double badThresholdForSeasonalPeaks;
        @Generated
        private double uncertainThresholdForSeasonalPeaks;

        @Generated
        Builder() {
        }

        @Generated
        public @NonNull Builder active(boolean active) {
            this.active = active;
            return this;
        }

        @Generated
        public @NonNull Builder badThresholdForNormality(double badThresholdForNormality) {
            this.badThresholdForNormality = badThresholdForNormality;
            return this;
        }

        @Generated
        public @NonNull Builder uncertainThresholdForNormality(double uncertainThresholdForNormality) {
            this.uncertainThresholdForNormality = uncertainThresholdForNormality;
            return this;
        }

        @Generated
        public @NonNull Builder severeThresholdForTradingDaysPeak(double severeThresholdForTradingDaysPeak) {
            this.severeThresholdForTradingDaysPeak = severeThresholdForTradingDaysPeak;
            return this;
        }

        @Generated
        public @NonNull Builder badThresholdForTradingDaysPeak(double badThresholdForTradingDaysPeak) {
            this.badThresholdForTradingDaysPeak = badThresholdForTradingDaysPeak;
            return this;
        }

        @Generated
        public @NonNull Builder uncertainThresholdForTradingDaysPeak(double uncertainThresholdForTradingDaysPeak) {
            this.uncertainThresholdForTradingDaysPeak = uncertainThresholdForTradingDaysPeak;
            return this;
        }

        @Generated
        public @NonNull Builder severeThresholdForSeasonalPeaks(double severeThresholdForSeasonalPeaks) {
            this.severeThresholdForSeasonalPeaks = severeThresholdForSeasonalPeaks;
            return this;
        }

        @Generated
        public @NonNull Builder badThresholdForSeasonalPeaks(double badThresholdForSeasonalPeaks) {
            this.badThresholdForSeasonalPeaks = badThresholdForSeasonalPeaks;
            return this;
        }

        @Generated
        public @NonNull Builder uncertainThresholdForSeasonalPeaks(double uncertainThresholdForSeasonalPeaks) {
            this.uncertainThresholdForSeasonalPeaks = uncertainThresholdForSeasonalPeaks;
            return this;
        }

        @Generated
        public @NonNull ResidualsDiagnosticsConfiguration build() {
            return new ResidualsDiagnosticsConfiguration(this.active, this.badThresholdForNormality, this.uncertainThresholdForNormality, this.severeThresholdForTradingDaysPeak, this.badThresholdForTradingDaysPeak, this.uncertainThresholdForTradingDaysPeak, this.severeThresholdForSeasonalPeaks, this.badThresholdForSeasonalPeaks, this.uncertainThresholdForSeasonalPeaks);
        }

        @Generated
        public @NonNull String toString() {
            return "ResidualsDiagnosticsConfiguration.Builder(active=" + this.active + ", badThresholdForNormality=" + this.badThresholdForNormality + ", uncertainThresholdForNormality=" + this.uncertainThresholdForNormality + ", severeThresholdForTradingDaysPeak=" + this.severeThresholdForTradingDaysPeak + ", badThresholdForTradingDaysPeak=" + this.badThresholdForTradingDaysPeak + ", uncertainThresholdForTradingDaysPeak=" + this.uncertainThresholdForTradingDaysPeak + ", severeThresholdForSeasonalPeaks=" + this.severeThresholdForSeasonalPeaks + ", badThresholdForSeasonalPeaks=" + this.badThresholdForSeasonalPeaks + ", uncertainThresholdForSeasonalPeaks=" + this.uncertainThresholdForSeasonalPeaks + ")";
        }
    }
}

