/*
 * Decompiled with CFR 0.152.
 */
package jdplus.x13.base.r;

import com.google.protobuf.InvalidProtocolBufferException;
import jdplus.sa.base.api.EstimationPolicyType;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.math.matrices.Matrix;
import jdplus.toolkit.base.api.timeseries.TsData;
import jdplus.toolkit.base.api.timeseries.TsDomain;
import jdplus.toolkit.base.api.timeseries.regression.ModellingContext;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.modelling.StationaryTransformation;
import jdplus.toolkit.base.core.regsarima.regular.Forecast;
import jdplus.toolkit.base.core.regsarima.regular.RegSarimaModel;
import jdplus.toolkit.base.core.regsarima.regular.RegSarimaProcessor;
import jdplus.toolkit.base.protobuf.regarima.RegArimaEstimationProto;
import jdplus.x13.base.api.regarima.RegArimaSpec;
import jdplus.x13.base.core.x13.regarima.DifferencingModule;
import jdplus.x13.base.core.x13.regarima.RegArimaFactory;
import jdplus.x13.base.core.x13.regarima.RegArimaKernel;
import jdplus.x13.base.core.x13.regarima.RegArimaOutput;
import jdplus.x13.base.protobuf.RegArimaProto;
import lombok.Generated;

public final class RegArima {
    public static byte[] toBuffer(RegSarimaModel core) {
        return RegArimaEstimationProto.convert((RegSarimaModel)core).toByteArray();
    }

    public static RegSarimaModel process(TsData series, String defSpec) {
        RegArimaSpec spec = RegArimaSpec.fromString((String)defSpec);
        RegArimaKernel regarima = RegArimaKernel.of((RegArimaSpec)spec, null);
        return regarima.process(series.cleanExtremities(), null);
    }

    public static RegSarimaModel process(TsData series, RegArimaSpec spec, ModellingContext context) {
        RegArimaKernel regarima = RegArimaKernel.of((RegArimaSpec)spec, (ModellingContext)context);
        return regarima.process(series.cleanExtremities(), null);
    }

    public static RegArimaSpec refreshSpec(RegArimaSpec currentSpec, RegArimaSpec domainSpec, TsDomain domain, String policy) {
        return RegArimaFactory.getInstance().refreshSpec(currentSpec, domainSpec, EstimationPolicyType.valueOf((String)policy), domain);
    }

    public static Matrix forecast(TsData series, String defSpec, int nf) {
        RegArimaSpec spec = RegArimaSpec.fromString((String)defSpec);
        return RegArima.forecast(series, spec, null, nf);
    }

    public static Matrix forecast(TsData series, RegArimaSpec spec, ModellingContext context, int nf) {
        RegArimaKernel kernel = RegArimaKernel.of((RegArimaSpec)spec, (ModellingContext)context);
        Forecast f = new Forecast((RegSarimaProcessor)kernel, nf);
        if (!f.process(series.cleanExtremities())) {
            return null;
        }
        FastMatrix R = FastMatrix.make((int)nf, (int)4);
        R.column(0).copy(f.getForecasts());
        R.column(1).copy(f.getForecastsStdev());
        R.column(2).copy(f.getRawForecasts());
        R.column(3).copy(f.getRawForecastsStdev());
        return R;
    }

    public static byte[] toBuffer(RegArimaSpec spec) {
        return RegArimaProto.convert((RegArimaSpec)spec).toByteArray();
    }

    public static RegArimaSpec specOf(byte[] buffer) {
        try {
            jdplus.x13.base.protobuf.RegArimaSpec spec = jdplus.x13.base.protobuf.RegArimaSpec.parseFrom((byte[])buffer);
            return RegArimaProto.convert((jdplus.x13.base.protobuf.RegArimaSpec)spec);
        }
        catch (InvalidProtocolBufferException ex) {
            return null;
        }
    }

    public static RegArimaOutput fullProcess(TsData series, RegArimaSpec spec, ModellingContext context) {
        RegArimaKernel tramo = RegArimaKernel.of((RegArimaSpec)spec, (ModellingContext)context);
        RegSarimaModel estimation = tramo.process(series.cleanExtremities(), null);
        return RegArimaOutput.builder().estimationSpec(spec).result(estimation).resultSpec(estimation == null ? null : RegArimaFactory.getInstance().generateSpec(spec, estimation.getDescription())).build();
    }

    public static RegArimaOutput fullProcess(TsData series, String defSpec) {
        RegArimaSpec spec = RegArimaSpec.fromString((String)defSpec);
        return RegArima.fullProcess(series, spec, null);
    }

    public static byte[] toBuffer(RegArimaOutput output) {
        return RegArimaProto.convert((RegArimaOutput)output).toByteArray();
    }

    public static StationaryTransformation doStationary(double[] data, int period) {
        DifferencingModule diff = DifferencingModule.builder().build();
        DoubleSeq s = DoubleSeq.of((double[])data);
        diff.process(s, period);
        return StationaryTransformation.builder().meanCorrection(diff.isMeanCorrection()).difference(new StationaryTransformation.Differencing(1, diff.getD())).difference(new StationaryTransformation.Differencing(period, diff.getBd())).build();
    }

    @Generated
    private RegArima() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

