/*
 * Decompiled with CFR 0.152.
 */
package jdplus.sa.base.core.diagnostics;

import jdplus.sa.base.core.tests.CombinedSeasonality;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.timeseries.TsData;
import jdplus.toolkit.base.core.stats.DescriptiveStatistics;
import lombok.Generated;

public final class SaDiagnosticsUtility {
    private static final double E_LIMIT = 0.005;

    public static boolean isSignificant(DoubleSeq s, DoubleSeq ref, double limit) {
        if (s.isEmpty()) {
            return false;
        }
        DescriptiveStatistics sdesc = DescriptiveStatistics.of((DoubleSeq)s);
        DescriptiveStatistics refdesc = DescriptiveStatistics.of((DoubleSeq)ref);
        double se = sdesc.getStdev();
        double refe = refdesc.getRmse();
        return refe == 0.0 || se / refe > limit;
    }

    public static boolean isSignificant(DoubleSeq s, DoubleSeq ref) {
        return SaDiagnosticsUtility.isSignificant(s, ref, 0.005);
    }

    public static boolean isSignificant(DoubleSeq s, double limit) {
        if (s == null) {
            return false;
        }
        DescriptiveStatistics sdesc = DescriptiveStatistics.of((DoubleSeq)s);
        double se = sdesc.getStdev();
        return se > limit;
    }

    public static boolean isSignificant(DoubleSeq s) {
        return SaDiagnosticsUtility.isSignificant(s, 0.005);
    }

    public static CombinedSeasonality combinedSeasonalityTest(TsData s, int nyears, double xbar, boolean detrend) {
        int len;
        int freq = s.getAnnualFrequency();
        if (detrend) {
            s = s.delta(Math.max(1, freq / 4));
        }
        if ((len = s.length()) < 3 * freq) {
            return null;
        }
        if (nyears > 0 && len > nyears * freq) {
            s = s.drop(len - nyears * freq, 0);
        }
        return CombinedSeasonality.of(s, xbar);
    }

    @Generated
    private SaDiagnosticsUtility() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

