/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.r.arima.extensions;

import java.util.function.DoubleUnaryOperator;
import jdplus.toolkit.base.api.information.InformationMapping;
import jdplus.toolkit.base.core.arima.AutoCovarianceFunction;
import jdplus.toolkit.base.core.sarima.SarimaModel;

public class SarimaExtension
extends InformationMapping<SarimaModel> {
    public SarimaExtension() {
        this.set("spectrum", double[].class, m -> {
            double[] s = new double[361];
            DoubleUnaryOperator fn = m.getSpectrum().asFunction();
            for (int i = 0; i < s.length; ++i) {
                s[i] = fn.applyAsDouble((double)i * Math.PI / 360.0);
            }
            return s;
        });
        this.set("ac", double[].class, m -> {
            double[] ac = new double[37];
            AutoCovarianceFunction acf = ((SarimaModel)m.stationaryTransformation().getStationaryModel()).getAutoCovarianceFunction();
            for (int i = 0; i < ac.length; ++i) {
                ac[i] = acf.get(i);
            }
            return ac;
        });
    }

    public Class<SarimaModel> getSourceClass() {
        return SarimaModel.class;
    }
}

