/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.math;

public class DoubleDouble
implements Comparable<DoubleDouble>,
Cloneable {
    private static final long serialVersionUID = 1L;
    public static final DoubleDouble PI = new DoubleDouble(Math.PI, 1.2246467991473532E-16);
    public static final DoubleDouble TWO_PI = new DoubleDouble(Math.PI * 2, 2.4492935982947064E-16);
    public static final DoubleDouble PI_2 = new DoubleDouble(1.5707963267948966, 6.123233995736766E-17);
    public static final DoubleDouble E = new DoubleDouble(Math.E, 1.4456468917292502E-16);
    public static final DoubleDouble NaN = new DoubleDouble(Double.NaN, Double.NaN);
    public static final double EPS = 1.23259516440783E-32;
    private static final double SPLIT = 1.34217729E8;
    private static final int MAX_PRINT_DIGITS = 32;
    private static final DoubleDouble TEN = new DoubleDouble(10.0);
    private static final DoubleDouble ONE = new DoubleDouble(1.0);
    private static final String SCI_NOT_EXPONENT_CHAR = "E";
    private static final String SCI_NOT_ZERO = "0.0E0";
    private double hi = 0.0;
    private double lo = 0.0;

    public static DoubleDouble parse(String str) throws NumberFormatException {
        char signCh;
        int i = 0;
        int strlen = str.length();
        while (Character.isWhitespace(str.charAt(i))) {
            ++i;
        }
        boolean isNegative = false;
        if (i < strlen && ((signCh = str.charAt(i)) == '-' || signCh == '+')) {
            ++i;
            if (signCh == '-') {
                isNegative = true;
            }
        }
        DoubleDouble val = new DoubleDouble();
        int numDigits = 0;
        int numBeforeDec = 0;
        int exp = 0;
        while (i < strlen) {
            char ch = str.charAt(i);
            ++i;
            if (Character.isDigit(ch)) {
                double d = ch - 48;
                val.selfMultiply(TEN);
                val.selfAdd(new DoubleDouble(d));
                ++numDigits;
                continue;
            }
            if (ch == '.') {
                numBeforeDec = numDigits;
                continue;
            }
            if (ch == 'e' || ch == 'E') {
                String expStr = str.substring(i);
                try {
                    exp = Integer.parseInt(expStr);
                    break;
                }
                catch (NumberFormatException ex) {
                    throw new NumberFormatException("Invalid exponent " + expStr + " in string " + str);
                }
            }
            throw new NumberFormatException("Unexpected character '" + ch + "' at position " + i + " in string " + str);
        }
        DoubleDouble val2 = val;
        int numDecPlaces = numDigits - numBeforeDec - exp;
        if (numDecPlaces == 0) {
            val2 = val;
        } else if (numDecPlaces > 0) {
            DoubleDouble scale = TEN.pow(numDecPlaces);
            val2 = val.divide(scale);
        } else if (numDecPlaces < 0) {
            DoubleDouble scale = TEN.pow(-numDecPlaces);
            val2 = val.multiply(scale);
        }
        if (isNegative) {
            return val2.negate();
        }
        return val2;
    }

    public static DoubleDouble valueOf(double x) {
        return new DoubleDouble(x);
    }

    public static DoubleDouble valueOf(String str) throws NumberFormatException {
        return DoubleDouble.parse(str);
    }

    private static int magnitude(double x) {
        double xAbs = Math.abs(x);
        double xLog10 = Math.log(xAbs) / Math.log(10.0);
        int xMag = (int)Math.floor(xLog10);
        double xApprox = Math.pow(10.0, xMag);
        if (xApprox * 10.0 <= xAbs) {
            ++xMag;
        }
        return xMag;
    }

    private static String stringOfChar(char ch, int len) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            buf.append(ch);
        }
        return buf.toString();
    }

    public DoubleDouble() {
        this.init(0.0);
    }

    public DoubleDouble(double x) {
        this.init(x);
    }

    public DoubleDouble(double hi, double lo) {
        this.init(hi, lo);
    }

    public DoubleDouble(DoubleDouble dd) {
        this.init(dd);
    }

    public DoubleDouble(String str) throws NumberFormatException {
        this(DoubleDouble.parse(str));
    }

    public DoubleDouble abs() {
        if (this.isNaN()) {
            return NaN;
        }
        if (this.isNegative()) {
            return this.negate();
        }
        return new DoubleDouble(this);
    }

    public DoubleDouble add(DoubleDouble y) {
        if (this.isNaN()) {
            return this;
        }
        return new DoubleDouble(this).selfAdd(y);
    }

    public DoubleDouble ceil() {
        if (this.isNaN()) {
            return NaN;
        }
        double fhi = Math.ceil(this.hi);
        double flo = 0.0;
        if (fhi == this.hi) {
            flo = Math.ceil(this.lo);
        }
        return new DoubleDouble(fhi, flo);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException ex) {
            return null;
        }
    }

    @Override
    public int compareTo(DoubleDouble other) {
        if (this.hi < other.hi) {
            return -1;
        }
        if (this.hi > other.hi) {
            return 1;
        }
        if (this.lo < other.lo) {
            return -1;
        }
        if (this.lo > other.lo) {
            return 1;
        }
        return 0;
    }

    public DoubleDouble divide(DoubleDouble y) {
        double C = this.hi / y.hi;
        double c = 1.34217729E8 * C;
        double hc = c - C;
        double u = 1.34217729E8 * y.hi;
        hc = c - hc;
        double tc = C - hc;
        double hy = u - y.hi;
        double U = C * y.hi;
        hy = u - hy;
        double ty = y.hi - hy;
        u = hc * hy - U + hc * ty + tc * hy + tc * ty;
        c = (this.hi - U - u + this.lo - C * y.lo) / y.hi;
        double zhi = u = C + c;
        double zlo = C - u + c;
        return new DoubleDouble(zhi, zlo);
    }

    public double doubleValue() {
        return this.hi + this.lo;
    }

    public String dump() {
        return "DD<" + this.hi + ", " + this.lo + ">";
    }

    public boolean equals(DoubleDouble y) {
        return this.hi == y.hi && this.lo == y.lo;
    }

    public DoubleDouble floor() {
        if (this.isNaN()) {
            return NaN;
        }
        double fhi = Math.floor(this.hi);
        double flo = 0.0;
        if (fhi == this.hi) {
            flo = Math.floor(this.lo);
        }
        return new DoubleDouble(fhi, flo);
    }

    public boolean ge(DoubleDouble y) {
        return this.hi > y.hi || this.hi == y.hi && this.lo >= y.lo;
    }

    public boolean gt(DoubleDouble y) {
        return this.hi > y.hi || this.hi == y.hi && this.lo > y.lo;
    }

    public int intValue() {
        return (int)this.hi;
    }

    public boolean isNaN() {
        return Double.isNaN(this.hi);
    }

    public boolean isNegative() {
        return this.hi < 0.0 || this.hi == 0.0 && this.lo < 0.0;
    }

    public boolean isPositive() {
        return this.hi > 0.0 || this.hi == 0.0 && this.lo > 0.0;
    }

    public boolean isZero() {
        return this.hi == 0.0 && this.lo == 0.0;
    }

    public boolean le(DoubleDouble y) {
        return this.hi < y.hi || this.hi == y.hi && this.lo <= y.lo;
    }

    public boolean lt(DoubleDouble y) {
        return this.hi < y.hi || this.hi == y.hi && this.lo < y.lo;
    }

    public DoubleDouble multiply(DoubleDouble y) {
        if (this.isNaN()) {
            return this;
        }
        if (y.isNaN()) {
            return y;
        }
        return new DoubleDouble(this).selfMultiply(y);
    }

    public DoubleDouble negate() {
        if (this.isNaN()) {
            return this;
        }
        return new DoubleDouble(-this.hi, -this.lo);
    }

    public DoubleDouble pow(int exp) {
        if ((double)exp == 0.0) {
            return DoubleDouble.valueOf(1.0);
        }
        DoubleDouble r = new DoubleDouble(this);
        DoubleDouble s = DoubleDouble.valueOf(1.0);
        int n = Math.abs(exp);
        if (n > 1) {
            while (n > 0) {
                if (n % 2 == 1) {
                    s.selfMultiply(r);
                }
                if ((n /= 2) <= 0) continue;
                r = r.sqr();
            }
        } else {
            s = r;
        }
        if (exp < 0) {
            return s.reciprocal();
        }
        return s;
    }

    public DoubleDouble reciprocal() {
        double C = 1.0 / this.hi;
        double c = 1.34217729E8 * C;
        double hc = c - C;
        double u = 1.34217729E8 * this.hi;
        hc = c - hc;
        double tc = C - hc;
        double hy = u - this.hi;
        double U = C * this.hi;
        hy = u - hy;
        double ty = this.hi - hy;
        u = hc * hy - U + hc * ty + tc * hy + tc * ty;
        c = (1.0 - U - u - C * this.lo) / this.hi;
        double zhi = C + c;
        double zlo = C - zhi + c;
        return new DoubleDouble(zhi, zlo);
    }

    public DoubleDouble rint() {
        if (this.isNaN()) {
            return this;
        }
        DoubleDouble plus5 = this.add(new DoubleDouble(0.5));
        return plus5.floor();
    }

    public int signum() {
        if (this.isPositive()) {
            return 1;
        }
        if (this.isNegative()) {
            return -1;
        }
        return 0;
    }

    public DoubleDouble sqr() {
        return this.multiply(this);
    }

    public DoubleDouble sqrt() {
        if (this.isZero()) {
            return new DoubleDouble(0.0);
        }
        if (this.isNegative()) {
            return NaN;
        }
        double x = 1.0 / Math.sqrt(this.hi);
        double ax = this.hi * x;
        DoubleDouble axdd = new DoubleDouble(ax);
        DoubleDouble diffSq = this.subtract(axdd.sqr());
        double d2 = diffSq.hi * (x * 0.5);
        return axdd.add(new DoubleDouble(d2));
    }

    public DoubleDouble subtract(DoubleDouble y) {
        if (this.isNaN()) {
            return this;
        }
        return this.add(y.negate());
    }

    public String toSciNotation() {
        if (this.isZero()) {
            return SCI_NOT_ZERO;
        }
        String specialStr = this.getSpecialNumberString();
        if (specialStr != null) {
            return specialStr;
        }
        int[] magnitude = new int[1];
        String digits = this.extractSignificantDigits(false, magnitude);
        String expStr = SCI_NOT_EXPONENT_CHAR + magnitude[0];
        if (digits.charAt(0) == '0') {
            throw new IllegalStateException("Found leading zero: " + digits);
        }
        String trailingDigits = "";
        if (digits.length() > 1) {
            trailingDigits = digits.substring(1);
        }
        String digitsWithDecimal = digits.charAt(0) + "." + trailingDigits;
        if (this.isNegative()) {
            return "-" + digitsWithDecimal + expStr;
        }
        return digitsWithDecimal + expStr;
    }

    public String toStandardNotation() {
        String specialStr = this.getSpecialNumberString();
        if (specialStr != null) {
            return specialStr;
        }
        int[] magnitude = new int[1];
        String sigDigits = this.extractSignificantDigits(true, magnitude);
        int decimalPointPos = magnitude[0] + 1;
        Object num = sigDigits;
        if (sigDigits.charAt(0) == '.') {
            num = "0" + sigDigits;
        } else if (decimalPointPos < 0) {
            num = "0." + DoubleDouble.stringOfChar('0', -decimalPointPos) + sigDigits;
        } else if (sigDigits.indexOf(46) == -1) {
            int numZeroes = decimalPointPos - sigDigits.length();
            String zeroes = DoubleDouble.stringOfChar('0', numZeroes);
            num = sigDigits + zeroes + ".0";
        }
        if (this.isNegative()) {
            return "-" + (String)num;
        }
        return num;
    }

    public String toString() {
        int mag = DoubleDouble.magnitude(this.hi);
        if (mag >= -3 && mag <= 20) {
            return this.toStandardNotation();
        }
        return this.toSciNotation();
    }

    public DoubleDouble trunc() {
        if (this.isNaN()) {
            return NaN;
        }
        if (this.isPositive()) {
            return this.floor();
        }
        return this.ceil();
    }

    private String extractSignificantDigits(boolean insertDecimalPoint, int[] magnitude) {
        DoubleDouble y = this.abs();
        int mag = DoubleDouble.magnitude(y.hi);
        DoubleDouble scale = TEN.pow(mag);
        if ((y = y.divide(scale)).gt(TEN)) {
            y = y.divide(TEN);
            ++mag;
        } else if (y.lt(ONE)) {
            y = y.multiply(TEN);
            --mag;
        }
        int decimalPointPos = mag + 1;
        StringBuilder buf = new StringBuilder();
        int numDigits = 31;
        for (int i = 0; i <= numDigits; ++i) {
            int digit;
            if (insertDecimalPoint && i == decimalPointPos) {
                buf.append('.');
            }
            if ((digit = (int)y.hi) < 0 || digit > 9) {
                // empty if block
            }
            if (digit < 0) break;
            boolean rebiasBy10 = false;
            char digitChar = '\u0000';
            if (digit > 9) {
                rebiasBy10 = true;
                digitChar = '9';
            } else {
                digitChar = (char)(48 + digit);
            }
            buf.append(digitChar);
            y = y.subtract(DoubleDouble.valueOf(digit)).multiply(TEN);
            if (rebiasBy10) {
                y.selfAdd(TEN);
            }
            boolean continueExtractingDigits = true;
            int remMag = DoubleDouble.magnitude(y.hi);
            if (remMag < 0 && Math.abs(remMag) >= numDigits - i) {
                continueExtractingDigits = false;
            }
            if (!continueExtractingDigits) break;
        }
        magnitude[0] = mag;
        return buf.toString();
    }

    private String getSpecialNumberString() {
        if (this.isZero()) {
            return "0.0";
        }
        if (this.isNaN()) {
            return "NaN ";
        }
        return null;
    }

    private void init(double x) {
        this.init(x, 0.0);
    }

    private void init(double hi, double lo) {
        this.hi = hi;
        this.lo = lo;
    }

    private void init(DoubleDouble dd) {
        this.init(dd.hi, dd.lo);
    }

    private DoubleDouble selfAdd(DoubleDouble y) {
        double S = this.hi + y.hi;
        double T2 = this.lo + y.lo;
        double e = S - this.hi;
        double f = T2 - this.lo;
        double s = S - e;
        double t = T2 - f;
        s = y.hi - e + (this.hi - s);
        t = y.lo - f + (this.lo - t);
        e = s + T2;
        double H = S + e;
        double h = e + (S - H);
        e = t + h;
        double zhi = H + e;
        double zlo = e + (H - zhi);
        this.hi = zhi;
        this.lo = zlo;
        return this;
    }

    private DoubleDouble selfMultiply(DoubleDouble y) {
        double C = 1.34217729E8 * this.hi;
        double hx = C - this.hi;
        double c = 1.34217729E8 * y.hi;
        hx = C - hx;
        double tx = this.hi - hx;
        double hy = c - y.hi;
        C = this.hi * y.hi;
        hy = c - hy;
        double ty = y.hi - hy;
        c = hx * hy - C + hx * ty + tx * hy + tx * ty + (this.hi * y.lo + this.lo * y.hi);
        double zhi = C + c;
        hx = C - zhi;
        double zlo = c + hx;
        this.hi = zhi;
        this.lo = zlo;
        return this;
    }
}

