## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(distionary)

## -----------------------------------------------------------------------------
my_normal <- distribution(
  density = stats::dnorm,
  cdf = stats::pnorm,
  range = c(-Inf, Inf),
  g = 9.81,
  another_representation = function(x) x^2,
  .vtype = "continuous"
)
# Inspect
my_normal

## -----------------------------------------------------------------------------
eval_cdf(my_normal, at = c(0.2, 0.5, 0.7))

## -----------------------------------------------------------------------------
mean(my_normal)

## -----------------------------------------------------------------------------
eval_property(my_normal, "g")

## -----------------------------------------------------------------------------
eval_property(my_normal, "another_representation", 1:4)

## -----------------------------------------------------------------------------
properties <- c("mean", "variance")
lapply(properties, \(x) eval_property(my_normal, x))

## -----------------------------------------------------------------------------
my_distribution <- distribution(
  cdf = pnorm,
  density = dnorm,
  .vtype = "continuous",
  .name = "Special",
  .parameters = list(theta = 1.7, mat = diag(2), hello = "hi")
)
# Inspect
my_distribution

## -----------------------------------------------------------------------------
vtype(my_distribution)

## -----------------------------------------------------------------------------
parameters(my_distribution)

## -----------------------------------------------------------------------------
parameters(my_distribution)[["mat"]] <- 1
parameters(my_distribution)[["hello"]] <- NULL
# Inspect the distribution
my_distribution

## -----------------------------------------------------------------------------
pretty_name(my_distribution)

## -----------------------------------------------------------------------------
pretty_name(my_distribution, param_digits = 2)

## -----------------------------------------------------------------------------
dst_linear <- function(a) {
  # It helps to check that the parameter is valid.
  checkmate::assert_number(a, lower = 0)
  # We'll create some representations outside of the `distribution()`
  # call for separation of concerns. Note that care is taken to ensure
  # proper behaviour outside of the range of the distribution.
  density <- function(x) {
    d <- 2 / a^2 * (a - x)
    d[x < 0 | x > a] <- 0
    d
  }
  cdf <- function(x) {
    p <- x / a^2 * (2 * a - x)
    p[x < 0] <- 0
    p[x > a] <- 1
    p
  }
  # Create the distribution.
  distribution(
    density = density,
    cdf = cdf,
    range = c(0, a),
    .vtype = "continuous",
    .name = "Linear",
    .parameters = list(a = a)
  )
}

## -----------------------------------------------------------------------------
dst_linear(3)

## -----------------------------------------------------------------------------
plot(dst_linear(1), to = 4, col = "purple")
plot(dst_linear(2), add = TRUE, col = "red")
plot(dst_linear(4), add = TRUE, col = "blue")
legend(
  "topright",
  legend = c("a = 1", "a = 2", "a = 4"),
  col = c("purple", "red", "blue"),
  lty = 1
)

## -----------------------------------------------------------------------------
enframe_return(
  model1 = dst_linear(1),
  model2 = dst_linear(2),
  model3 = dst_linear(4),
  at = c(2, 5, 10, 20, 50, 100),
  arg_name = "return_period"
)

## ----echo=FALSE, out.width="100%", fig.align="center"-------------------------
knitr::include_graphics("network_diagram.png")

## -----------------------------------------------------------------------------
# Make a function that takes a distribution as input, and returns the
# interquartile range.
iqr <- function(distribution) {
  diff(eval_quantile(distribution, at = c(0.25, 0.75)))
}

## -----------------------------------------------------------------------------
iqr(dst_linear(2))

