/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.xgboost;

import com.devsmart.ubjson.GsonUtil;
import com.devsmart.ubjson.UBObject;
import com.devsmart.ubjson.UBValue;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import org.jpmml.xgboost.GBTree;
import org.jpmml.xgboost.UBJSONUtil;
import org.jpmml.xgboost.XGBoostDataInput;

public class Dart
extends GBTree {
    private float[] weight_drop;

    @Override
    public String getAlgorithmName() {
        return "DART";
    }

    @Override
    public void loadBinary(XGBoostDataInput input) throws IOException {
        super.loadBinary(input);
        int num_trees = this.num_trees();
        if (num_trees != 0) {
            this.weight_drop = input.readFloatVector();
        }
    }

    @Override
    public void loadJSON(JsonObject gradientBooster) {
        UBValue value = GsonUtil.toUBValue((JsonElement)gradientBooster);
        this.loadUBJSON(value.asObject());
    }

    @Override
    public void loadUBJSON(UBObject gradientBooster) {
        UBObject gbtree = gradientBooster.get((Object)"gbtree").asObject();
        super.loadUBJSON(gbtree);
        this.weight_drop = UBJSONUtil.toFloatArray(gradientBooster.get((Object)"weight_drop"));
    }

    @Override
    public float[] tree_weights() {
        return this.weight_drop;
    }
}

