{$N-,W-,V-,G+,X+}

Unit wbibslct;

Interface

Uses
  Wobjects, WinTypes, WinProcs, Windos, bibvars, wbibdisp, lfnunit, bibutil,
  strings, rc_id, rc_strng, bibstrg, bibfile, wbibgui, win31, commdlg, bibwild;

const
  DatabaseDesc='Database';
  PatternDesc ='Pattern';
  BstDesc     ='BibTeX style';
  AllDesc     ='All';
  PreambleDesc='Header';
  TeXAuxDesc  ='LaTeX .AUX';
  LaTeXDesc   ='LaTeX';
  {
  TibDesc     ='Tib';
  ReferDesc   ='Refer';
  CommaDesc   ='Comma delimited';
  }

type
  FileDescStr = string[32];
  FOpenHookProc = function (Wnd: HWnd; Msg, wParam: Word; lParam: Longint): Word;
  FCPrString = string[63];

var
  OrigFOpenRect: TRect;
  FOpenControls: PCollection;

function  FOpenDlgHook(Wnd: HWnd; Msg, wParam: Word;
                       lParam: Longint): word; export;
procedure FileChoose(Var fname: string; Exten: string; PathList: PathListPtr;
                     FileAttr: Word; GetNew,MustExist,Printers: boolean;
                     IsReadOnly: PBoolean;
                     Prompt: FCPrString; Desc: FileDescStr; var accept: boolean);


Implementation

Const
  Fill_ok     = 0;
  Fill_failed = 1;
  Fill_empty  = 2;

type
  PFindFileDlg = ^TFindFileDlg;
  TFindFileDlg = object(TResizableDialog)
    OutputBuffer,Title: PChar;
    FileName: array[0..255] of Char;
    fname,Exten: string;
    Ebox: PEditNoCr;
    Pathlist: PathListPtr;
    FileAttr: Word;
    Desc: FileDescStr;
    CloseCancel,MustExist: boolean;
    IsReadOnly: PBoolean;
    ListFont: HFont;
    LineHeight,Width: integer;
    constructor init(AParent: PWindowsObject; AName,ATitle,fn: PChar;
                     Dext: string; Plist: PathListPtr; Fattr: word;
                     ADesc: FileDescStr; AMustExist: boolean;
                     AIsReadOnly: PBoolean);
    procedure   FixControlPos; virtual;
    procedure   SetupWindow;   virtual;
    procedure   wmMeasureItem(var Msg: TMessage); virtual wm_first+wm_MeasureItem;
    procedure   wmDrawItem(var Msg: TMessage);    virtual wm_first+wm_DrawItem;
    procedure   wmSize(var Msg: TMessage);        virtual wm_first+wm_Size;
    procedure   wmDestroy(var Msg: TMessage);     virtual wm_first+wm_Destroy;
    procedure   UpdateList(fn,Ext: PString);
    procedure   UpdateGroup(name: string);
    procedure   TruncateItems;
    procedure   HandleListBox(var Msg: TMessage); virtual id_first+ff_ListBox;
    procedure   HandleGroups(var Msg: TMessage);  virtual id_first+ff_FileGroups;
    procedure   Browse(var Msg: TMessage);        virtual id_first+ff_Browse;
    procedure   ok(var Msg: TMessage);            virtual id_first+id_ok;
    destructor  done; virtual;
  end;

{$F+}
function FOpenDlgHook(Wnd: HWnd; Msg, wParam: Word; lParam: Longint): word;
var
  i: integer;
  SysMenu: HMenu;
  Rect: TRect;
  X,Y,H,W: integer;
  Placement: TWindowPlacement;

procedure NewControl(id,left,right,top,bottom: integer);
begin
  FOpenControls^.Insert(new(PControlPos,Init(Wnd,GetDlgItem(Wnd,id),
                    left,right,top,bottom)));
end;

procedure InitPos;
var
  Rect: TRect;
  Xset,Yset,Wset,Hset: integer;
  changed: boolean;
begin
  if BrowseFilesSize.H<>0 then
  with BrowseFilesSize do
  begin
    XSet:=X; Yset:=Y; Wset:=W; HSet:=H; changed:=true;
  end else
  begin
    GetWindowRect(Wnd,Rect);
    with Rect do
    begin
      XSet:=left; YSet:=top; WSet:=right-left; HSet:=bottom-top;
    end;
    Changed:=false;
  end;
  if Xset+Wset>ScreenRect.right then
  begin
    XSet:=ScreenRect.right-Wset; changed:=true;
  end;
  if Xset<0 then
  begin
    XSet:=0; changed:=true;
  end;
  if XSet+Wset>ScreenRect.right then
  begin
    WSet:=ScreenRect.right-Xset; changed:=true;
  end;
  if Yset+Hset>ScreenRect.bottom then
  begin
    YSet:=ScreenRect.bottom-Hset; changed:=true;
  end;
  if Yset<0 then
  begin
    YSet:=0; changed:=true;
  end;
  if Yset+Hset>ScreenRect.bottom then
  begin
    HSet:=ScreenRect.bottom-Yset; changed:=true;
  end; 
  if changed then MoveWindow(Wnd,Xset,Yset,Wset,Hset,false);
end;                              { InitPos }

begin
  FOpenDlgHook:=0;
  case Msg of
    wm_InitDialog:
      begin
        if UseCtl3d and Win95 and Win95_3d then
          SetWindowLong(Wnd,gwl_Style,
             GetWindowLong(Wnd,gwl_Style) or DS_3DLOOK or WS_THICKFRAME)
        else
          SetWindowLong(Wnd,gwl_Style,
             GetWindowLong(Wnd,gwl_Style) or WS_THICKFRAME);
        SysMenu:=GetSystemMenu(Wnd,false);
        RemoveMenu(SysMenu,sc_minimize,mf_ByCommand);
        RemoveMenu(SysMenu,sc_maximize,mf_ByCommand);
        RemoveMenu(SysMenu,sc_restore, mf_ByCommand);
        RemoveMenu(SysMenu,sc_size,    mf_ByCommand);
        InsertMenu(SysMenu,1,mf_ByPosition or mf_String,sc_size,MenuSizeString);
        InsertMenu(SysMenu,2,mf_ByPosition or mf_Separator,0,Nil);
        GetWindowRect(Wnd,OrigFOpenRect);
        New(FOpenControls,Init(6,10));
        NewControl(cdlg_FOpenFilesLBox,   RelTo_Left,RelTo_Size,RelTo_Top,RelTo_Bottom);
        NewControl(cdlg_FOpenDirsLBox,    RelTo_Left,RelTo_Size,RelTo_Top,RelTo_Bottom);
        NewControl(cdlg_FOpenTypesStatic, RelTo_Left,RelTo_Size,RelTo_Bottom,RelTo_Size);
        NewControl(cdlg_FOpenDrivesStatic,RelTo_Left,RelTo_Size,RelTo_Bottom,RelTo_Size);
        NewControl(cdlg_FOpenTypesLBox,   RelTo_Left,RelTo_Size,RelTo_Bottom,RelTo_Size);
        NewControl(cdlg_FOpenDrivesLBox,  RelTo_Left,RelTo_Size,RelTo_Bottom,RelTo_Size);
        InitPos;
      end;
    wm_GetMinMaxInfo:
      with PMinMaxInfo(lParam)^ do
      begin
        ptMinTrackSize.X:=OrigFOpenRect.right -OrigFOpenRect.left;
        ptMinTrackSize.Y:=OrigFOpenRect.bottom-OrigFOpenRect.top;
        ptMaxTrackSize.X:=ptMinTrackSize.X;
        FOpenDlgHook:=1;
      end;
    wm_Size:
      begin
        GetClientRect(Wnd,Rect);
        for i:=0 to FOpenControls^.Count-1 do
        with PControlPos(FOpenControls^.at(i))^ do
        begin
          if cleft=RelTo_Right then X:=Rect.right-Initial.left
          else X:=Initial.left;
          if ctop=RelTo_bottom then Y:=Rect.bottom-Initial.top
          else Y:=Initial.top;
          if cright=RelTo_Left then W:=Initial.right-X
          else if cright=RelTo_Size then W:=Initial.right
          else W:=Rect.right-Initial.Right-X;
          if cbottom=RelTo_top then H:=Initial.bottom-Y
          else if cbottom=RelTo_Size then H:=Initial.bottom
          else H:=Rect.bottom-Initial.bottom-Y;
          MoveWindow(Handle,X,Y,W,H,true);
        end;
        InvalidateRect(Wnd,nil,true);
      end;
    wm_Destroy:
      begin
        Dispose(FOpenControls,Done); FOpenControls:=Nil;
        FillChar(Placement,sizeof(TWindowPlacement),0);
        Placement.length:=sizeof(TWindowPlacement);
        if GetWindowPlacement(Wnd,@Placement)<>bool(0) then
        with BrowseFilesSize, Placement.rcNormalPosition do
          if (X<>left) or (Y<>top) or (W<>(right-left)) or (H<>(bottom-top)) then
          begin
            X:=left; Y:=top; W:=right-left; H:=bottom-top;
            OptionsModified.WindowsParams:=true;
          end;
      end;
  end;
end;                          { FOpenDlgHook }
{$F-}

function FillListBox(var fname: string; Exten: Pstring;
                      PathList: PathListPtr;
                      FileAttr: Word;
                      Lbox: HWnd;
                      JustOne: boolean): integer;
const
  Printers = false;
var
  fl,tmp,OrigName: Pstring;
  Spec: SpecArr;
  NFiles,i,n: longint;
  nspec,j: integer;
  IsPrinter,mshow: boolean;

function CheckFileName: boolean;
var
  icode: integer;
  Ext,Name,Dir: PString;
  Wildcard: boolean;
  aux: file;
  Attr: word;

procedure TidyUp;
begin
  AllocStrings(false,@Dir,@Name,@Ext,Nil);
  logsection('',false);
end;

begin
  logsection('CheckFileName "'+fname+'"',true);
  CheckFileName:=false; WildCard:=false; IsPrinter:=false;
  AllocStrings(true,@Dir,@Name,@Ext,Nil);
  LFNFsplit(fname,Dir,Name,Ext); CanonicalFname(fname);
  logstring('"'+fname+'"');
  logstring('"'+Dir^+'"'); LogString('"'+Name^+'"'); logstring('"'+Ext^+'"');
  {
  if (Dir^<>'') and not IsDirName(Dir^) then
  begin
    logstring('1');
    ErrorMessageRC(Str_IllegalPath,Dir^);
    TidyUp; Exit;
  end;
  }
  if Ext^='' then
  begin
    Ext^:=Exten^; if (Ext^<>'') and (Ext^[1]<>'.') then Ext^:='.'+Ext^;
  end;
  fl^:=Name^+Ext^;
  WildCard:=IsWildcard(fl^);
  if not WildCard then
  begin
    if (StrCmpI(fname,'lpt1:',1,1,255)=0) or
       (StrCmpI(fname,'lpt2:',1,1,255)=0) or
       (StrCmpI(fname,'lpt3:',1,1,255)=0) or
       (StrCmpI(fname,'prn:' ,1,1,255)=0) then Delete(tmp^,4,1);
    if (StrCmpI(fname,'lpt1',1,1,255)=0) or
       (StrCmpI(fname,'lpt2',1,1,255)=0) or
       (StrCmpI(fname,'lpt3',1,1,255)=0) or
       (StrCmpI(fname,'prn' ,1,1,255)=0) then IsPrinter:=true;
  end;
  if IsPrinter and (not Printers) then
  begin
    ErrorMessageRC(Str_ForbidPrinters,''); TidyUp; Exit;
  end;
  if not (wildcard or IsPrinter or IsFileName(fname)) then
  begin
    logstring('2');
    ErrorMessageRC(Str_IllegalFileName,fl^); TidyUp; Exit;
  end;
  if (Dir^<>'') and not IsWildcard(Dir^) and (Pos('\\',Dir^)<>1) then
  begin
    if Dir^[length(Dir^)]='\' then Delete(Dir^,length(Dir^),1);
    logstring('3 "'+Dir^+'"');
    icode:=0; Attr:=0;

    LFNNew(aux,false);
    LFNAssign(aux,Dir^);
    
    if (LFNGetFAttr(aux,Attr)<>0) then icode:=-1
    else if ((Attr and faDirectory)=0) then icode:=-2;

    if icode<0 then
    begin
      LFNAssign(aux,Dir^+'\.');
      if LFNGetFAttr(aux,Attr)=0 then
      begin
        icode:=16;
        if (Attr and faDirectory)<>0 then icode:=17;
      end;
    end;
    LFNDispose(aux);

    if (icode<0) and LFNFileExist(Dir^+'\.') then icode:=18;

    if (icode<0) and LFNFileExist(fname) then icode:=19;
    {$I-}
    {
    ChDir(LFNShortName(Dir^)); icode:=IoResult;
    logstring('4 "'+Dir^+'" = '+num2str(icode));
    ChDir(LFNShortName(tmp^)); if IoResult<>0 then;
    }
    {$I+}
    logstring('4 = '+num2str(icode));
    if icode<0 then
    begin
      ErrorMessageRC(Str_CantFindDir,Dir^); TidyUp; Exit;
    end;
  end;
  CheckFileName:=true;
  TidyUp;
end;                             { CheckFileName }

procedure GetMatchingFileList;
var
  F: Pchar;
  Root,Path: PathListPtr;
  HomePath,D,Dir,Nam,E,fll: Pstring;
  Srec: TLFNSearchRec;
  leave,finish,Wildcard: boolean;
  OldErrMode: Word;
  l,Ind: integer;
begin
  logsection('GetMatchFileList "'+fname+'"',true);
  GetMem(F,256);
  New(HomePath); New(D); New(Dir); New(Nam); New(E); New(fll);

  LFNFSplit(fname,Dir,Nam,E);
  logstring('1 - "'+Dir^+'","'+Nam^+'","'+E^+'"');
  if Dir^<>'' then CanonicalFname(Dir^);
  if E^='' then E^:=Exten^;
  logstring('2 - "'+Dir^+'"');
  fl^:=Nam^+E^;
  WildCard:=isWildcard(fl^);
  if Wildcard then
  begin
    LFNFsplit(fl^,D,Nam,E);
    logstring('Wild "'+fl^+'","'+D^+'","'+Nam^+'","'+E^+'"');
    if IsWildcard(Nam^) then fll^:='*'    else fll^:=Nam^;
    if IsWildCard(E^) then fll^:=fll^+'.*' else fll^:=fll^+E^;
  end else fll^:=fl^;
  logstring('3 - "'+fll^+'"');

  New(Root); Root^.Next:=Nil; Root^.back:=Nil; HomePath^:='';
  if Dir^='' then
  begin
    HomePath^:=LFNFexpand('');
    logstring('4 - "'+HomePath^+'"');
    CanonicalFname(HomePath^);
    logstring('5 - "'+HomePath^+'"');
    Root^.P:=NewStr(HomePath^);
    Root^.Next:=PathList;
    if PathList<>Nil then PathList^.Back:=Root;
  end else
  begin
    Root^.P:=NewStr(LFNfexpand(Dir^));
    logstring('6 - "'+Root^.P^+'"');
  end;
  Path:=Root;

  leave:=false; NFiles:=0;
  OldErrMode:=SetErrorMode(SEM_FailCriticalErrors or SEM_NoOpenFileErrorBox);
  repeat
    if (Path^.P^<>'') and (Path^.P^[length(Path^.P^)]<>'\') then
      StrPCopy(F,Path^.P^+'\'+fll^)
    else StrPCopy(F,Path^.P^+fll^);
    logstring('Look for "'+StrPas(F)+'"');
    LFNFindFirst(StrPas(F),FileAttr,Srec);
    while (not leave) and (DosError=0) do
    begin
      if Wildcard then logstring('7') else logstring('7a');
      if FilenameMatch(Srec.name,Nam^,E^) then
        logstring('8 - "'+StrPas(Srec.Name)+'","'+Nam^+'","'+E^+'"')
      else logstring('8a');
      if (not Wildcard) or FilenameMatch(Srec.name,Nam^,E^) then
      begin
        inc(NFiles);
        tmp^:=Path^.P^; if tmp^[length(tmp^)]<>'\' then tmp^:=tmp^+'\';
        tmp^:=tmp^+StrPas(SRec.name);
        CanonicalFName(tmp^);
        logstring('  Found "'+tmp^+'", #'+num2str(NFiles));
        if Lbox<>0 then
        begin
          logstring('Add');
          StrPCopy(F,tmp^); Ind:=SendMessage(LBox,lb_AddString,0,longint(F));
          SendMessage(LBox,lb_SetItemData,Ind,0);
        end else begin fname:=tmp^; logstring('Found!'); end;
      end;
      LFNFindNext(Srec);
    end;
    if not leave then
    repeat
      Path:=Path^.Next;
    until (Path=Nil) or (Path^.P^<>HomePath^);
    if Path=Nil then leave:=true;
    if JustOne and (Nfiles>0) then leave:=true;
  until leave;
  DisposeStr(Root^.P); Dispose(Root);
  LFNFindClose(SRec);
  if PathList<>Nil then PathList^.Back:=Nil;
  SetErrorMode(OldErrMode);
  FreeMem(F,256);
  Dispose(HomePath); Dispose(D); Dispose(Dir); Dispose(Nam);
  Dispose(E); Dispose(fll);
  logsection('',false);
end;                             { GetMatchingFileList }

begin                               { FillListBox }
  logsection('FillListBox',true);
  AllocStrings(true,@fl,@tmp,@OrigName,Nil);
  FillListBox:=fill_ok;
  NFiles:=0;
  mshow:=false; mshow:=(fname<>'') and (fname[1]='h');
  if not CheckFileName then
  begin
    logstring('Bad');
    ErrorMessageRC(Str_ErrorInFileName,''); FillListBox:=Fill_failed;
    AllocStrings(false,@fl,@tmp,@OrigName,Nil);
    Exit;
  end;
  logstring('Good');
  GetMatchingFileList;
  logstring('# = '+num2str(Nfiles));
  if Nfiles=0 then FillListBox:=Fill_empty;
  AllocStrings(false,@fl,@tmp,@OrigName,Nil);
  logsection('',false);
end;                               { FillListBox }

constructor TFindFileDlg.init(AParent: PWindowsObject; Aname,Atitle,fn: PChar;
                              DExt: string;
                              Plist: PathListPtr; Fattr: Word;
                              ADesc: FileDescStr; AMustExist: boolean;
                              AIsReadOnly: PBoolean);
var
  E: PString;
begin
  TResizableDialog.Init(AParent,AName,@FindFileSize);
  Title:=ATitle;
  Desc:=ADesc;
  IsReadOnly:=AIsReadOnly;
  MustExist:=AMustExist;
  fname:=StrPas(fn); 
  OutputBuffer:=fn;
  New(E);
  LFNFSplit(fname,Nil,Nil,E);
  if E^='' then StrPCopy(FileName,fname+DExt)
  else StrPCopy(FileName,fname);
  Dispose(E);
  Pathlist:=PList; Exten:=DExt; FileAttr:=Fattr;
  New(Ebox,InitResource(@Self,ff_EditBox,255,
         [#0..#255]-FileNameSet-RegexpChars));
  ListFont:=CreateHelvFont(true,@LineHeight); Width:=0;
end;                               { TFindFileDlg.init }

procedure TFindFileDlg.UpdateList(fn,Ext: PString);
var
  i: integer;
  D: String;
begin
  LFNFSplit(fn^,@D,Nil,Nil);
  if (D<>'') and not (IsDirName(D) and LFNFileExist(D+'.')) then Exit;
  SearchingMessage;
  SendDlgItemMsg(ff_ListBox,lb_ResetContent,0,0);
  FillListBox(fn^,Ext,PathList,FileAttr,GetItemHandle(ff_ListBox),false);
  TruncateItems;
  WaitingOff;
end;                            { TFindFileDlg.UpdateList }

procedure TFindFileDlg.wmMeasureItem(var Msg: TMessage);
begin
  with PMeasureItemStruct(Msg.lParam)^ do
  begin
    ItemWidth:=0; ItemHeight:=LineHeight;
  end;
end;                       { TFindFileDlg.wmMeasureItem }

procedure TFindFileDlg.wmDrawItem(var Msg: TMessage);
begin
  DrawTabbedLBoxItem(PDrawItemStruct(Msg.lParam),ListFont,false,Width,1,true);
end;

procedure TFindFileDlg.FixControlPos;
begin
  NewControl(ff_EditBox,RelTo_Left,RelTo_Right,RelTo_Top,RelTo_Size);
  NewControl(ff_ListBox,RelTo_Left,RelTo_Right,RelTo_Top,RelTo_Bottom);

  NewControl(ff_FileGroups,        RelTo_Left,RelTo_Size,RelTo_Bottom,RelTo_Size);
  if IsReadOnly<>Nil then
    NewControl(ff_ReadOnly,        RelTo_Left,RelTo_Size,RelTo_Bottom,RelTo_Size);
  NewControl(cdlg_FOpenTypesStatic,RelTo_Left,RelTo_Size,RelTo_Bottom,RelTo_Size);

  NewControl(ff_Browse,RelTo_Right,RelTo_Size,RelTo_Top,RelTo_Size);
  NewControl(id_Cancel,RelTo_Right,RelTo_Size,RelTo_Top,RelTo_Size);
  NewControl(id_OK,    RelTo_Right,RelTo_Size,RelTo_Top,RelTo_Size);
end;

procedure TFindFileDlg.SetupWindow;
const
  TabSep = 7;
var
  F: array[0..255] of char;
  TabStops,i: integer;
begin
  TResizableDialog.SetupWindow;
  DisableSysMinimize;
  InitPos;
  if StrLen(Title)>0 then SetWindowText(HWindow,Title);

  if (Desc<>'') and (Exten<>'') then
  begin
    StrPCopy(F,Desc+' files (*'+Exten+')');
    SendDlgItemMsg(ff_FileGroups,cb_AddString,0,Longint(@F));
  end;
  StrPCopy(F,AllDesc+' files (*.*)');
  SendDlgItemMsg(ff_FileGroups,cb_AddString,0,Longint(@F));
  UpdateGroup(StrPas(FileName));

  UpdateList(@fname,@Exten);
  Ebox^.SetText(FileName);
  if StrLen(Filename)>0 then EBox^.SetSelection(0,StrLen(Filename)-1);
  TabStops:=TabSep;
  SendDlgItemMsg(ff_ListBox,lb_SetTabStops,1,Longint(@TabStops));
  if IsReadOnly=Nil then
  begin
    EnableWindow(GetItemHandle(ff_ReadOnly),false);
    ShowWindow(GetItemHandle(ff_ReadOnly),sw_hide);
  end else
  begin
    if IsReadOnly^ then
      CheckDlgButton(HWindow,ff_ReadOnly,bf_checked);
    EnableWindow(GetItemHandle(ff_ReadOnly),ForbidEditing);
  end;
end;                              { TFindFileDlg.SetupWindow }

procedure TFindFileDlg.TruncateItems;
var
  R: TRect;
  DC: HDC;
  W,LW,Wdots: word;
  i,l: integer;
  F,F1: PChar;
  tmp: String;
  OldFont: HFont;
begin
  GetClientRect(GetItemHandle(ff_Listbox),R);
  W:=R.Right-R.Left-1*TabbedLBox_XShift;  { Allow some space on the right, too. }
  DC:=GetDC(GetItemHandle(ff_Listbox));
  OldFont:=SelectObject(DC,ListFont);
  GetMem(F,270);
  for i:=0 to SendDlgItemMsg(ff_ListBox,lb_GetCount,0,0)-1 do
  begin
    SendDlgItemMsg(ff_ListBox,lb_GetText,i,Longint(F));
    LW:=LoWord(GetTextExtent(DC,F,StrLen(F)));
    if LW>W then    { adjust }
    begin
      tmp:='..'; Wdots:=LoWord(GetTextExtent(DC,PChar(@tmp[1]),length(tmp)));
      F1:=F+1; l:=StrLen(F1); LW:=LoWord(GetTextExtent(DC,F1,l));
      while (F1^<>#0) and (LW>W-Wdots) do
      begin
        F1:=F1+1; dec(l);
        LW:=LoWord(GetTextExtent(DC,F1,l));
      end;
      tmp:=tmp+StrPas(F1);
    end else tmp:=StrPas(F);
    l:=ChrPosR(tmp,'\',1);
    StrPCopy(F,Copy(tmp,1,l)); StrCat(F,TabbedLBox_FilenameColor);
    StrPCopy(F+l+1,Copy(tmp,l+1,255));
    StrDispose(PChar(SendDlgItemMsg(ff_Listbox,lb_GetItemData,i,0)));
    SendDlgItemMsg(ff_ListBox,lb_SetItemData,i,longint(StrNew(F)));
  end;
  FreeMem(F,270);
  SelectObject(DC,OldFont);
  ReleaseDC(GetItemHandle(ff_ListBox),DC);
end;                   { TFindFileDlg.TruncateItems }

procedure TFindFileDlg.wmSize(var Msg: TMessage);
begin
  TResizableDialog.wmSize(Msg);
  TruncateItems;
end;

procedure TFindFileDlg.HandleListBox(var Msg: TMessage);
var
  CurInd: integer;
  SelStr: array[0..270] of char;
begin
  if Msg.lParamHi=lbn_SelChange then
  begin
    CurInd:=SendDlgItemMsg(ff_ListBox,lb_GetCurSel,0,0);
    if CurInd<>lb_Err then
    begin
      SendDlgItemMsg(ff_ListBox,lb_GetText,CurInd,Longint(@SelStr));
      SelStr[256]:=#0;   { Just in case... }
      Ebox^.SetText(SelStr);
      UpdateGroup(StrPas(SelStr));
    end;
  end else if Msg.lParamHi=lbn_DblClk then ok(Msg)
  else DefWndProc(Msg);
end;                   { TFindFileDlg.HandleListBox }

procedure TFindFileDlg.HandleGroups(var Msg: TMessage);
var
  i: integer;
  F: array[0..10] of char;
  Ext,name: Pstring;
begin
  case Msg.lParamHi of
    cbn_DropDown:     CloseCancel:=false;
    cbn_SelEndCancel: CloseCancel:=true;
    cbn_CloseUp:
      if not CloseCancel then
      begin
        i:=SendDlgItemMsg(ff_FileGroups,cb_GetCurSel,0,0);
        if i<>cb_Err then
        begin
          AllocStrings(true,@Ext,@name,Nil,Nil);
          Ext^:='.*'; if i=0 then Ext^:=Exten;
          StrPCopy(F,'*'+Ext^); EBox^.SetText(F);
          name^:='*';
          UpdateList(name,Ext);
          AllocStrings(false,@Ext,@name,Nil,Nil);
        end;
      end;
  end;
end;                           { TFindFileDlg.HandleGroups }

procedure TFindFileDlg.UpdateGroup(name: string);
var
  D,N,E: PString;
begin
  AllocStrings(true,@D,@N,@E,Nil);
  LFNFsplit(name,D,N,E); if N^='' then N^:='*'; if E^='' then E^:=Exten;
  if (D^='') and (N^='*') then
  begin
    if E^='.*' then
      SendDlgItemMsg(ff_FileGroups,cb_SetCurSel,1,0)
    else if StrCmpI(E^,Exten,1,1,255)=0 then
      SendDlgItemMsg(ff_FileGroups,cb_SetCurSel,0,0)
    else
      SendDlgItemMsg(ff_FileGroups,cb_SetCurSel,Word(-1),0);
  end else
    SendDlgItemMsg(ff_FileGroups,cb_SetCurSel,Word(-1),0);
  AllocStrings(false,@D,@N,@E,Nil);
end;                             { TFindFileDlg.UpdateGroup }

procedure TFindFileDlg.ok(var Msg: TMessage);
var
  D,N,E,P: PString;
  icode: integer;

procedure TidyUp;
begin
  AllocStrings(false,@P,@D,@N,@E);
end;

begin
  if not CanClose then Exit;
  AllocStrings(true,@P,@D,@N,@E);
  Ebox^.GetText(FileName,255);
  if (StrScan(FileName,'?')=Nil) and (StrScan(FileName,'*')=Nil)
     and (StrScan(FileName,'[')=Nil) then
  begin
    if StrLen(FileName)=0 then StrPCopy(OutputBuffer,'')
    else begin
      P^:=StrPas(FileName);
      LFNFsplit(P^,D,N,E);
      if D^='' then
      begin
        SearchingMessage;
        if FillListBox(P^,@Exten,PathList,FileAttr,0,true)=fill_ok then
          StrPCopy(OutputBuffer,P^)
        else StrPCopy(OutputBuffer,LFNFExpand(StrPas(FileName)));;
        WaitingOff;
      end else if not IsDirName(D^) then
      begin
        ErrorMessageRC(Str_IllegalPath,D^); TidyUp; Exit;
      end else if not LFNFileExist(D^+'.') then
      begin
        ErrorMessageRC(Str_CantFindDir,D^); TidyUp; Exit;
      end else if not IsFileName(P^) then
      begin
        ErrorMessageRC(Str_IllegalFileName,P^); TidyUp; Exit;
      end else StrCopy(OutputBuffer,FileName);
    end;
    if (IsReadOnly<>Nil) then
      IsReadOnly^:=ForbidEditing or
                   (IsDlgButtonChecked(HWindow,ff_readOnly)=bf_checked);
    EndDlg(id_ok); TidyUp; Exit;
  end else
  begin
    fname:=StrPas(FileName);
    LFNFsplit(fname,D,N,E);
    if (D^<>'') and not IsDirName(D^) then ErrorMessageRC(Str_IllegalPath,D^)
    else if ValidRegexp(fname,true) then
    begin
      UpdateGroup(fname);
      UpdateList(@fname,@Exten);
    end;
  end;
  TidyUp;
end;                             { TFindFileDlg.ok }

procedure TFindFileDlg.Browse(var Msg: TMessage);
var
  T: TOpenFileName;
  Filters,F: PChar;
  lFilter: integer;
  CustomFilter: array[0..40] of char;
  FileNameStr,DefExtStr: Pchar;
  FOpenHook: TFarProc;
begin
  FOpenHook:=MakeProcInstance(TFarProc(@FOpenDlgHook),HInstance);

  { Filters }
  lFilter:=length(AllDesc)+7+4;
  if Desc<>'' then lFilter:=lFilter+length(Desc)+7+length(Exten)+2;
  lFilter:=lFilter+10;
  GetMem(Filters,lFilter); GetMem(FileNameStr,270); GetMem(DefExtStr,270);
  F:=Filters; F[0]:=#0;
  if Desc<>'' then
  begin
    StrPCopy(F,Desc+' files');
    F:=F+StrLen(F)+1;
    StrPCopy(F,'*'+Exten);
    F:=F+StrLen(F)+1;
  end;
  StrPCopy(F,AllDesc+' files');
  F:=F+StrLen(F)+1;
  StrPCopy(F,'*.*');
  F:=F+StrLen(F)+1;
  F[0]:=#0; F[1]:=#0;

  FillChar(CustomFilter,sizeof(CustomFilter),0);
  Ebox^.GetText(FileNameStr,255);

  StrPCopy(DefExtStr,Copy(Exten,2,255));

  FillChar(T,SizeOf(T),0);
  with T do
  begin
    lStructSize:=SizeOf(T);
    hWndOwner:=HWindow;
    lpstrFilter:=Filters;
    lpstrCustomFilter:=@CustomFilter;
    nMaxCustFilter:=40;
    nFilterIndex:=1;
    lpstrFile:=FileNameStr;
    nMaxFile:=255;
    lpstrFileTitle:=Nil;
    nMaxFileTitle:=0;
    lpstrInitialDir:=Nil;
    lpstrTitle:=Title;
    flags:=Ofn_HideReadOnly or Ofn_PathMustExist or
           Ofn_EnableHook  { or Ofn_EnableTemplate};
    if LFNAble then flags:=flags or ofn_LongNames;
    if MustExist then flags:=flags or Ofn_FileMustExist;
    lpstrDefExt:=DefExtStr;
    lpTemplateName:=PChar(rc_FileOpenBrowse);
    lpfnHook:=FOpenHookProc(FOpenHook);
  end;
  T.hInstance:=HInstance;

  if GetOpenFileName(T) then
    Ebox^.SetText(CanonicalFilename(FileNameStr));

  FreeMem(DefExtStr,270); FreeMem(FileNameStr,270); FreeMem(Filters,lFilter);
  FreeProcInstance(FOpenHook);
end;                          { TFindFileDlg.Browse }

procedure TFindFileDlg.wmDestroy(var Msg: TMessage);
var
  i: integer;
begin
  for i:=0 to SendDlgItemMsg(ff_ListBox,lb_GetCount,0,0)-1 do
    StrDispose(PChar(SendDlgItemMsg(ff_ListBox,lb_GetItemData,i,0)));
  TResizableDialog.wmDestroy(Msg);
end;

destructor TFindFileDlg.Done;
begin
  if ListFont<>0 then DeleteObject(ListFont);
  TResizableDialog.Done;
end;

{=====================}

procedure FileChoose(Var fname: string; Exten: string; PathList: PathListPtr;
                     FileAttr: Word; GetNew,MustExist,Printers: boolean;
                     IsReadOnly: PBoolean;
                     Prompt: FCPrString; Desc: FileDescStr; var accept: boolean);
var
  F,T: PChar;
  Wild: boolean;
  ofile: PString;
  i: integer;

procedure TidyUp;
begin
  if OFile<>Nil then DisposeStr(OFile); FreeMem(F,256);
end;

begin
  logsection('FileChoose',true);
  GetMem(F,256); OFile:=Nil;
  if fname<>'' then Ofile:=NewStr(fname);
  accept:=false;
  StrPCopy(F,fname);
  if StrLen(F)=0 then StrPCopy(F,'*');
  Wild:=(StrScan(F,'?')<>Nil) or (StrScan(F,'*')<>Nil) or (StrScan(F,'[')<>Nil);
  if Wild and not ValidRegexp(fname,not MacroCommand) then
  begin
    TidyUp; Exit;
  end;
  if not (GetNew or Wild) then
  begin
    i:=FillListBox(fname,@Exten,PathList,FileAttr,0,true);
    ChrDel(fname,#9); ChrDel(fname,TabbedLBox_FilenameColor);
    if (i=fill_ok) or ((not MustExist) and (i=Fill_empty)) then
    begin
      accept:=true; TidyUp; Exit;
    end;
    if OFile=Nil then fname:='' else fname:=Ofile^;
  end;
  ChrDelL(Prompt,' '); ChrDelR(Prompt,' '); ChrDelR(Prompt,':');
  GetMem(T,length(Prompt)+2); StrPCopy(T,Prompt);
  if Application^.ExecDialog(New(PFindFileDlg, Init(
    CurrentWindow,Pchar(rc_FindFileDialog),T,F,Exten,PathList,FileAttr,Desc,
                        MustExist,IsReadOnly))) = id_ok then
  begin
    fname:=StrPas(F);
    ChrDel(fname,#9); ChrDel(fname,TabbedLBox_FilenameColor);
    accept:=true;
  end;
  FreeMem(T,length(Prompt)+2);
  TidyUp;
end;                      { FileChoose }


end.
