/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.dmg.pmml.Expression;
import org.dmg.pmml.Extension;
import org.dmg.pmml.Field;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.HasFieldReference;
import org.dmg.pmml.PMMLAttributes;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.StringValue;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.FieldNameAdapter;
import org.jpmml.model.MissingAttributeException;
import org.jpmml.model.annotations.AlternateValueConstructor;
import org.jpmml.model.annotations.CollectionElementType;
import org.jpmml.model.annotations.Property;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name="Aggregate", namespace="http://www.dmg.org/PMML-4_4")
@XmlType(name="", propOrder={"extensions"})
@JsonRootName(value="Aggregate")
@JsonPropertyOrder(value={"field", "function", "groupField", "sqlWhere", "extensions"})
public class Aggregate
extends Expression
implements HasExtensions<Aggregate>,
HasFieldReference<Aggregate> {
    @XmlAttribute(name="field", required=true)
    @XmlJavaTypeAdapter(value=FieldNameAdapter.class)
    @JsonProperty(value="field")
    private String field;
    @XmlAttribute(name="function", required=true)
    @JsonProperty(value="function")
    private Function function;
    @XmlAttribute(name="groupField")
    @XmlJavaTypeAdapter(value=FieldNameAdapter.class)
    @JsonProperty(value="groupField")
    private String groupField;
    @XmlAttribute(name="sqlWhere")
    @JsonProperty(value="sqlWhere")
    private String sqlWhere;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="Extension")
    @CollectionElementType(value=Extension.class)
    private List<Extension> extensions;
    private static final long serialVersionUID = 67371275L;

    public Aggregate() {
    }

    @ValueConstructor
    public Aggregate(@Property(value="field") String field, @Property(value="function") Function function) {
        this.field = field;
        this.function = function;
    }

    @AlternateValueConstructor
    public Aggregate(Field<?> field, Function function) {
        this(field != null ? field.requireName() : null, function);
    }

    @Override
    public String requireField() {
        if (this.field == null) {
            throw new MissingAttributeException(this, PMMLAttributes.AGGREGATE_FIELD);
        }
        return this.field;
    }

    @Override
    public String getField() {
        return this.field;
    }

    @Override
    public Aggregate setField(@Property(value="field") String field) {
        this.field = field;
        return this;
    }

    public Function requireFunction() {
        if (this.function == null) {
            throw new MissingAttributeException(this, PMMLAttributes.AGGREGATE_FUNCTION);
        }
        return this.function;
    }

    public Function getFunction() {
        return this.function;
    }

    public Aggregate setFunction(@Property(value="function") Function function) {
        this.function = function;
        return this;
    }

    public String getGroupField() {
        return this.groupField;
    }

    public Aggregate setGroupField(@Property(value="groupField") String groupField) {
        this.groupField = groupField;
        return this;
    }

    public String getSqlWhere() {
        return this.sqlWhere;
    }

    public Aggregate setSqlWhere(@Property(value="sqlWhere") String sqlWhere) {
        this.sqlWhere = sqlWhere;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && !this.extensions.isEmpty();
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public Aggregate addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
                status = PMMLObject.traverse(visitor, this.getExtensions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name="")
    @XmlEnum
    public static enum Function implements StringValue<Function>
    {
        COUNT("count"),
        SUM("sum"),
        AVERAGE("average"),
        MIN("min"),
        MAX("max"),
        MULTISET("multiset");

        private final String value;

        private Function(String v) {
            this.value = v;
        }

        @Override
        public String value() {
            return this.value;
        }

        public static Function fromValue(String v) {
            for (Function c : Function.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }

        public String toString() {
            return this.value();
        }
    }
}

