/*
 * Decompiled with CFR 0.152.
 */
package com.devsmart.ubjson;

import com.devsmart.ubjson.UBValue;

public class UBArray
extends UBValue {
    private static final long serialVersionUID = 5220038976009456175L;
    private UBValue[] mValue;

    UBArray() {
    }

    UBArray(UBValue[] value) {
        this.mValue = value;
    }

    @Override
    public UBValue.Type getType() {
        return UBValue.Type.Array;
    }

    public boolean isStronglyTyped() {
        return false;
    }

    public ArrayType getStrongType() {
        return ArrayType.Generic;
    }

    @Override
    public int size() {
        return this.mValue.length;
    }

    public UBValue get(int index) {
        return this.mValue[index];
    }

    @Override
    public int hashCode() {
        int retval = 0;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            retval ^= this.get(i).hashCode();
        }
        return retval;
    }

    @Override
    public int compareTo(UBValue o) {
        UBArray other = (UBArray)o;
        int thisSize = this.size();
        int otherSize = other.size();
        int minSize = Math.min(thisSize, otherSize);
        for (int i = 0; i < minSize; ++i) {
            int retval = UBValue.COMPARATOR.compare(this.get(i), other.get(i));
            if (retval == 0) continue;
            return retval;
        }
        if (thisSize == otherSize) {
            return 0;
        }
        if (thisSize < otherSize) {
            return -1;
        }
        return 1;
    }

    public static enum ArrayType {
        Generic,
        Int8,
        Int16,
        Int32,
        Int64,
        Float32,
        Float64,
        String;

    }
}

