/*
 * Decompiled with CFR 0.152.
 */
package jdplus.tramoseats.base.api.tramo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import jdplus.toolkit.base.api.timeseries.regression.IOutlier;
import jdplus.toolkit.base.api.timeseries.regression.InterventionVariable;
import jdplus.toolkit.base.api.timeseries.regression.Ramp;
import jdplus.toolkit.base.api.timeseries.regression.TsContextVariable;
import jdplus.toolkit.base.api.timeseries.regression.Variable;
import jdplus.toolkit.base.api.util.Validatable;
import jdplus.tramoseats.base.api.tramo.CalendarSpec;
import jdplus.tramoseats.base.api.tramo.MeanSpec;
import lombok.Generated;
import lombok.NonNull;
import org.jspecify.annotations.Nullable;

public final class RegressionSpec
implements Validatable<RegressionSpec> {
    @NonNull
    private final MeanSpec mean;
    @NonNull
    private final CalendarSpec calendar;
    private final List<Variable<IOutlier>> outliers;
    private final List<Variable<Ramp>> ramps;
    private final List<Variable<InterventionVariable>> interventionVariables;
    private final List<Variable<TsContextVariable>> userDefinedVariables;
    public static final RegressionSpec DEFAULT_UNUSED = (RegressionSpec)RegressionSpec.builder().build();
    public static final RegressionSpec DEFAULT_CONST = (RegressionSpec)new Builder().calendar(CalendarSpec.DEFAULT_UNUSED).mean(MeanSpec.DEFAULT_USED).build();

    public static Builder builder() {
        return new Builder().mean(MeanSpec.DEFAULT_UNUSED).calendar(CalendarSpec.DEFAULT_UNUSED);
    }

    public boolean isUsed() {
        return this.mean.isUsed() || this.calendar.isUsed() || !this.outliers.isEmpty() || !this.ramps.isEmpty() || !this.interventionVariables.isEmpty() || !this.userDefinedVariables.isEmpty();
    }

    public boolean isDefault() {
        return this.equals(DEFAULT_UNUSED);
    }

    public RegressionSpec validate() throws IllegalArgumentException {
        return this;
    }

    public boolean hasFixedCoefficients() {
        if (!this.isUsed()) {
            return false;
        }
        return this.mean.hasFixedCoefficient() || this.calendar.hasFixedCoefficients() || this.outliers.stream().anyMatch(var -> !var.isFree()) || this.ramps.stream().anyMatch(var -> !var.isFree()) || this.interventionVariables.stream().anyMatch(var -> !var.isFree()) || this.userDefinedVariables.stream().anyMatch(var -> !var.isFree());
    }

    @Generated
    RegressionSpec(@NonNull MeanSpec mean, @NonNull CalendarSpec calendar, List<Variable<IOutlier>> outliers, List<Variable<Ramp>> ramps, List<Variable<InterventionVariable>> interventionVariables, List<Variable<TsContextVariable>> userDefinedVariables) {
        if (mean == null) {
            throw new NullPointerException("mean is marked non-null but is null");
        }
        if (calendar == null) {
            throw new NullPointerException("calendar is marked non-null but is null");
        }
        this.mean = mean;
        this.calendar = calendar;
        this.outliers = outliers;
        this.ramps = ramps;
        this.interventionVariables = interventionVariables;
        this.userDefinedVariables = userDefinedVariables;
    }

    @Generated
    public @org.jspecify.annotations.NonNull Builder toBuilder() {
        Builder builder = new Builder().mean(this.mean).calendar(this.calendar);
        if (this.outliers != null) {
            builder.outliers(this.outliers);
        }
        if (this.ramps != null) {
            builder.ramps(this.ramps);
        }
        if (this.interventionVariables != null) {
            builder.interventionVariables(this.interventionVariables);
        }
        if (this.userDefinedVariables != null) {
            builder.userDefinedVariables(this.userDefinedVariables);
        }
        return builder;
    }

    @NonNull
    @Generated
    public MeanSpec getMean() {
        return this.mean;
    }

    @NonNull
    @Generated
    public CalendarSpec getCalendar() {
        return this.calendar;
    }

    @Generated
    public List<Variable<IOutlier>> getOutliers() {
        return this.outliers;
    }

    @Generated
    public List<Variable<Ramp>> getRamps() {
        return this.ramps;
    }

    @Generated
    public List<Variable<InterventionVariable>> getInterventionVariables() {
        return this.interventionVariables;
    }

    @Generated
    public List<Variable<TsContextVariable>> getUserDefinedVariables() {
        return this.userDefinedVariables;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RegressionSpec)) {
            return false;
        }
        RegressionSpec other = (RegressionSpec)o;
        MeanSpec this$mean = this.getMean();
        MeanSpec other$mean = other.getMean();
        if (this$mean == null ? other$mean != null : !((Object)this$mean).equals(other$mean)) {
            return false;
        }
        CalendarSpec this$calendar = this.getCalendar();
        CalendarSpec other$calendar = other.getCalendar();
        if (this$calendar == null ? other$calendar != null : !((Object)this$calendar).equals(other$calendar)) {
            return false;
        }
        List<Variable<IOutlier>> this$outliers = this.getOutliers();
        List<Variable<IOutlier>> other$outliers = other.getOutliers();
        if (this$outliers == null ? other$outliers != null : !((Object)this$outliers).equals(other$outliers)) {
            return false;
        }
        List<Variable<Ramp>> this$ramps = this.getRamps();
        List<Variable<Ramp>> other$ramps = other.getRamps();
        if (this$ramps == null ? other$ramps != null : !((Object)this$ramps).equals(other$ramps)) {
            return false;
        }
        List<Variable<InterventionVariable>> this$interventionVariables = this.getInterventionVariables();
        List<Variable<InterventionVariable>> other$interventionVariables = other.getInterventionVariables();
        if (this$interventionVariables == null ? other$interventionVariables != null : !((Object)this$interventionVariables).equals(other$interventionVariables)) {
            return false;
        }
        List<Variable<TsContextVariable>> this$userDefinedVariables = this.getUserDefinedVariables();
        List<Variable<TsContextVariable>> other$userDefinedVariables = other.getUserDefinedVariables();
        return !(this$userDefinedVariables == null ? other$userDefinedVariables != null : !((Object)this$userDefinedVariables).equals(other$userDefinedVariables));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MeanSpec $mean = this.getMean();
        result = result * 59 + ($mean == null ? 43 : ((Object)$mean).hashCode());
        CalendarSpec $calendar = this.getCalendar();
        result = result * 59 + ($calendar == null ? 43 : ((Object)$calendar).hashCode());
        List<Variable<IOutlier>> $outliers = this.getOutliers();
        result = result * 59 + ($outliers == null ? 43 : ((Object)$outliers).hashCode());
        List<Variable<Ramp>> $ramps = this.getRamps();
        result = result * 59 + ($ramps == null ? 43 : ((Object)$ramps).hashCode());
        List<Variable<InterventionVariable>> $interventionVariables = this.getInterventionVariables();
        result = result * 59 + ($interventionVariables == null ? 43 : ((Object)$interventionVariables).hashCode());
        List<Variable<TsContextVariable>> $userDefinedVariables = this.getUserDefinedVariables();
        result = result * 59 + ($userDefinedVariables == null ? 43 : ((Object)$userDefinedVariables).hashCode());
        return result;
    }

    @Generated
    public @org.jspecify.annotations.NonNull String toString() {
        return "RegressionSpec(mean=" + String.valueOf(this.getMean()) + ", calendar=" + String.valueOf(this.getCalendar()) + ", outliers=" + String.valueOf(this.getOutliers()) + ", ramps=" + String.valueOf(this.getRamps()) + ", interventionVariables=" + String.valueOf(this.getInterventionVariables()) + ", userDefinedVariables=" + String.valueOf(this.getUserDefinedVariables()) + ")";
    }

    public static class Builder
    implements Validatable.Builder<RegressionSpec> {
        @Generated
        private MeanSpec mean;
        @Generated
        private CalendarSpec calendar;
        @Generated
        private ArrayList<Variable<IOutlier>> outliers;
        @Generated
        private ArrayList<Variable<Ramp>> ramps;
        @Generated
        private ArrayList<Variable<InterventionVariable>> interventionVariables;
        @Generated
        private ArrayList<Variable<TsContextVariable>> userDefinedVariables;

        @Generated
        Builder() {
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder mean(@NonNull MeanSpec mean) {
            if (mean == null) {
                throw new NullPointerException("mean is marked non-null but is null");
            }
            this.mean = mean;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder calendar(@NonNull CalendarSpec calendar) {
            if (calendar == null) {
                throw new NullPointerException("calendar is marked non-null but is null");
            }
            this.calendar = calendar;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder outlier(Variable<IOutlier> outlier) {
            if (this.outliers == null) {
                this.outliers = new ArrayList();
            }
            this.outliers.add(outlier);
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder outliers(@org.jspecify.annotations.NonNull Collection<? extends Variable<IOutlier>> outliers) {
            if (outliers == null) {
                throw new NullPointerException("outliers cannot be null");
            }
            if (this.outliers == null) {
                this.outliers = new ArrayList();
            }
            this.outliers.addAll(outliers);
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder clearOutliers() {
            if (this.outliers != null) {
                this.outliers.clear();
            }
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder ramp(Variable<Ramp> ramp) {
            if (this.ramps == null) {
                this.ramps = new ArrayList();
            }
            this.ramps.add(ramp);
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder ramps(@org.jspecify.annotations.NonNull Collection<? extends Variable<Ramp>> ramps) {
            if (ramps == null) {
                throw new NullPointerException("ramps cannot be null");
            }
            if (this.ramps == null) {
                this.ramps = new ArrayList();
            }
            this.ramps.addAll(ramps);
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder clearRamps() {
            if (this.ramps != null) {
                this.ramps.clear();
            }
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder interventionVariable(Variable<InterventionVariable> interventionVariable) {
            if (this.interventionVariables == null) {
                this.interventionVariables = new ArrayList();
            }
            this.interventionVariables.add(interventionVariable);
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder interventionVariables(@org.jspecify.annotations.NonNull Collection<? extends Variable<InterventionVariable>> interventionVariables) {
            if (interventionVariables == null) {
                throw new NullPointerException("interventionVariables cannot be null");
            }
            if (this.interventionVariables == null) {
                this.interventionVariables = new ArrayList();
            }
            this.interventionVariables.addAll(interventionVariables);
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder clearInterventionVariables() {
            if (this.interventionVariables != null) {
                this.interventionVariables.clear();
            }
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder userDefinedVariable(Variable<TsContextVariable> userDefinedVariable) {
            if (this.userDefinedVariables == null) {
                this.userDefinedVariables = new ArrayList();
            }
            this.userDefinedVariables.add(userDefinedVariable);
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder userDefinedVariables(@org.jspecify.annotations.NonNull Collection<? extends Variable<TsContextVariable>> userDefinedVariables) {
            if (userDefinedVariables == null) {
                throw new NullPointerException("userDefinedVariables cannot be null");
            }
            if (this.userDefinedVariables == null) {
                this.userDefinedVariables = new ArrayList();
            }
            this.userDefinedVariables.addAll(userDefinedVariables);
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder clearUserDefinedVariables() {
            if (this.userDefinedVariables != null) {
                this.userDefinedVariables.clear();
            }
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull RegressionSpec buildWithoutValidation() {
            return new RegressionSpec(this.mean, this.calendar, switch (this.outliers == null ? 0 : this.outliers.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.outliers.get(0));
                default -> Collections.unmodifiableList(new ArrayList<Variable<IOutlier>>(this.outliers));
            }, switch (this.ramps == null ? 0 : this.ramps.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.ramps.get(0));
                default -> Collections.unmodifiableList(new ArrayList<Variable<Ramp>>(this.ramps));
            }, switch (this.interventionVariables == null ? 0 : this.interventionVariables.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.interventionVariables.get(0));
                default -> Collections.unmodifiableList(new ArrayList<Variable<InterventionVariable>>(this.interventionVariables));
            }, switch (this.userDefinedVariables == null ? 0 : this.userDefinedVariables.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.userDefinedVariables.get(0));
                default -> Collections.unmodifiableList(new ArrayList<Variable<TsContextVariable>>(this.userDefinedVariables));
            });
        }

        @Generated
        public @org.jspecify.annotations.NonNull String toString() {
            return "RegressionSpec.Builder(mean=" + String.valueOf(this.mean) + ", calendar=" + String.valueOf(this.calendar) + ", outliers=" + String.valueOf(this.outliers) + ", ramps=" + String.valueOf(this.ramps) + ", interventionVariables=" + String.valueOf(this.interventionVariables) + ", userDefinedVariables=" + String.valueOf(this.userDefinedVariables) + ")";
        }
    }
}

