## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----built--------------------------------------------------------------------
message(paste0('Datetime: ',Sys.Date(),':',Sys.time()))

## ----setup, message=FALSE-----------------------------------------------------
library(repfun)
library(dplyr)
library(DT)
library(kableExtra)

## ----envir--------------------------------------------------------------------
tmpdr <- tempdir()
datdir <- file.path(gsub("\\","/",tmpdr,fixed=TRUE),"datdir")
dir.create(datdir,showWarnings=FALSE)
repfun::copydata(datdir)
setup <- function(tlfid){
 repfun::rs_setup(
   D_DATADATE=Sys.Date(),
   D_DSPLYNUM=tlfid,
   D_FOOT1='1.) Only treatment emergent events related to lipids are displayed.',
   D_FOOT2='2.) Subjects are only counted once within each body system and preferred term.',
   D_KEEPPOPVARS=c('STUDYID','USUBJID','SAFFL'),
   D_OUTFILE=paste0(tmpdr,"/t_ru_list_",tlfid,".rtf"),
   D_PGMPTH="~/vignettes/AE-Tbls.Rmd",
   D_STUDYID='ABCXYZPDQ',
   D_POP="SAFFL",
   D_POPDATA=repfun::adsl %>% dplyr::filter(SAFFL =='Y') %>% 
             dplyr::mutate(TRT01AN=ifelse(TRT01A=='Placebo',1,ifelse(TRT01A=='Xanomeline Low Dose',2,3))) %>%
             repfun::ru_labels(varlabels=list('TRT01AN'='Actual Treatment for Period 01 (n)')),
   D_POPLBL="Safety",
   D_SUBJID=c("STUDYID","USUBJID"),
   D_TITLE1=paste0('Table ',tlfid,': Summary of Treatment Emergent Adverse Events'),
   R_DDDATA=paste0(tmpdr,'/t_ru_list_',tlfid,'.rds'),
   R_ADAMDATA=datdir)
}

## ----cntper-------------------------------------------------------------------
setup(1)
tbl1dd <- paste0(tmpdr,"/t_ru_list_1.rds")
aesum <- repfun::ru_freq(repfun:::rfenv$adamdata$adae.rda() %>% dplyr::select(-SAFFL) %>% 
                   repfun::ru_getdata(repfun:::rfenv$G_POPDATA, c("STUDYID", "USUBJID"), keeppopvars=c("TRT01AN", "TRT01A")),
                 dsetindenom=repfun:::rfenv$G_POPDATA,
                 countdistinctvars=c('STUDYID','USUBJID'),
                 groupbyvarsnumer=c('TRT01AN','TRT01A','AEBODSYS','AEDECOD'),
                 anyeventvars = c('AEBODSYS','AEDECOD'),
                 anyeventvalues = c('ANY EVENT','ANY EVENT'),
                 groupbyvarsdenom=c('TRT01AN'),
                 resultstyle="NUMERPCT",
                 totalforvar=c('TRT01AN'),
                 totalid=99,
                 totaldecode='Total',
                 codedecodevarpairs=c("TRT01AN", "TRT01A"),
                 resultpctdps=0) %>% 
  dplyr::arrange(TRT01AN,TRT01A,AEBODSYS,tt_summarylevel,AEDECOD,NUMERCNT,DENOMCNT) %>% 
  repfun::ru_align("tt_result")

## ----maket1-------------------------------------------------------------------
repfun::ru_list(aesum,
        columns=c('AEBODSYS','AEDECOD','tt_01','tt_02','tt_03','tt_99'),
        nowidowvar='AEBODSYS',
        widths=c(5.5,4.5,1.75,1.9,1.9,1.75),
        skipvars=c('AEBODSYS'),
        centrevars=c('tt_01','tt_02','tt_03','tt_99'),
        ordervars=c('AEBODSYS','tt_summarylevel','AEDECOD'),
        noprintvars=c('tt_summarylevel'),
        denormyn='Y',
        varsToDenorm=c('tt_result'),
        groupByVars=c('AEBODSYS','tt_summarylevel','AEDECOD'),
        acrossVar="TRT01AN",
        acrossVarLabel="TRT01A",
        acrossColVarPrefix='tt_',
        dddatasetlabel=paste0('DD Dataframe for AE Table ',repfun:::rfenv$G_DSPLYNUM),
        lpp=23)

## ----dddata1------------------------------------------------------------------
t1 <- readRDS(repfun:::rfenv$G_DDDATA) %>% dplyr::filter(AEDECOD != '') %>% dplyr::filter(row_number()<=10)
lbls <- sapply(t1,function(x){attr(x,"label")})
names(t1) <- paste(names(lbls),lbls,sep=": ")
DT::datatable(
  t1, extensions = 'FixedColumns',
  options = list(
  dom = 't',
  pageLength=1000,
  scrollY = 300,
  scrollX = TRUE,
  scrollCollapse = TRUE
))

## ----maket2-------------------------------------------------------------------
setup(2)
SOCterms <- aesum %>% distinct(AEBODSYS,AEDECOD)
SOCcnts <- table(SOCterms$AEBODSYS)
repfun::ru_list(aesum %>% dplyr::filter(!(AEBODSYS %in% names(SOCcnts[SOCcnts>=20]))),
        columns=c('AEBODSYS','AEDECOD','tt_01','tt_02','tt_03','tt_99'),
        nowidowvar='AEBODSYS',
        widths=c(5.5,4.5,1.75,1.9,1.9,1.75),
        skipvars=c('AEBODSYS'),
        centrevars=c('tt_01','tt_02','tt_03','tt_99'),
        ordervars=c('AEBODSYS','tt_summarylevel','AEDECOD'),
        noprintvars=c('tt_summarylevel'),
        denormyn='Y',
        varsToDenorm=c('tt_result'),
        groupByVars=c('AEBODSYS','tt_summarylevel','AEDECOD'),
        acrossVar="TRT01AN",
        acrossVarLabel="TRT01A",
        acrossColVarPrefix='tt_',
        dddatasetlabel=paste0('DD Dataframe for AE Table ',repfun:::rfenv$G_DSPLYNUM),
        lpp=24)

## ----dddata2------------------------------------------------------------------
t2 <- readRDS(repfun:::rfenv$G_DDDATA) %>% dplyr::filter(AEDECOD != '') %>% dplyr::filter(row_number()<=10)
lbls <- sapply(t2,function(x){attr(x,"label")})
names(t2) <- paste(names(lbls),lbls,sep=": ")
datatable(
  t2, extensions = 'FixedColumns',
  options = list(
  dom = 't',
  pageLength=1000,
  scrollY = 300,
  scrollX = TRUE,
  scrollCollapse = TRUE
))


## ----maket3-------------------------------------------------------------------
setup(3)
df <- readRDS(file=tbl1dd) %>% 
  dplyr::select(-PAGEVAR) %>% dplyr::filter(!(AEDECOD == '')) %>% 
  dplyr::filter(!(AEBODSYS %in% names(SOCcnts[SOCcnts>=15])))
dfpg <- rbind(df %>% dplyr::mutate(AESER='Yes'), df %>% dplyr::mutate(AESER='No')) 
attr(dfpg[['AESER']],'label') <- 'Serious AE (Y/N)'
mytbls <- list('Gender: Male'=dfpg[0,], 'Gender: Female'=dfpg)
repfun::ru_list(dsetin=mytbls,
        columns=c('AESER','AEBODSYS','AEDECOD','tt_01','tt_02','tt_03','tt_99'),
        nowidowvar='AEBODSYS',
        sharecolvars=c('AESER','AEBODSYS','AEDECOD'),
        widths=c(7,1.65,1.9,1.9,1.65),
        skipvars=c('AEBODSYS'),
        centrevars=c('tt_01','tt_02','tt_03','tt_99'),
        lpp = 30,
        dddatasetlabel=paste0('DD Dataframe for AE Table ',repfun:::rfenv$G_DSPLYNUM))

## ----dddata3------------------------------------------------------------------
t3 <- readRDS(repfun:::rfenv$G_DDDATA) %>% dplyr::filter(gsub("\\s+", "",STACKVAR) != '') %>% dplyr::filter(row_number()<=10)
lbls <- sapply(t3,function(x){attr(x,"label")})
names(t3) <- paste(names(lbls),lbls,sep=": ")
datatable(
  t3, extensions = 'FixedColumns',
  options = list(
  dom = 't',
  pageLength=1000,
  scrollY = 300,
  scrollX = TRUE,
  scrollCollapse = TRUE
))

## ----maket4-------------------------------------------------------------------
setup(4)
df <- readRDS(file=tbl1dd) %>% dplyr::select(-PAGEVAR) %>% dplyr::filter(!(AEDECOD == '')) 
repfun::ru_list(dsetin=df[0,], 
        columns=c('AEBODSYS','AEDECOD','tt_01','tt_02','tt_03','tt_99'), 
        ordervars=c('AEBODSYS','AEDECOD'), 
        orderdata=TRUE, 
        widths=c(7,5,2,2,2,2), 
        dddatasetlabel=paste0('DD Dataframe for AE Table ',repfun:::rfenv$G_DSPLYNUM)) 

## ----maket5-------------------------------------------------------------------
setup(5)

df <- readRDS(file=tbl1dd) %>% 
  dplyr::select(-PAGEVAR,-tt_99) %>% dplyr::filter(!(AEDECOD == '')) %>%
  dplyr::filter(!(AEBODSYS %in% names(SOCcnts[SOCcnts>=15]))) %>%
  dplyr::group_by(AEBODSYS) %>% 
  dplyr::mutate(AESOC=ifelse(row_number()==1,paste0(AEBODSYS,': '),gsub('.',' ',paste0(AEBODSYS,': ')))) %>%
  dplyr::mutate(AESOC=ifelse(nchar(AEBODSYS)>55,gsub('^[ ][ ]*','  ',AESOC),AESOC)) %>% 
  dplyr::select(AEBODSYS,AESOC,everything())
dfpg <- rbind(df %>% dplyr::mutate(MYPAGEVAR=1),
              df %>% dplyr::mutate(MYPAGEVAR=2)) %>% 
        repfun::ru_labels(varlabels=list('AESOC'='Body System: ','MYPAGEVAR'='My Page Variable'))

mytbls <- list('Gender: Male'=dfpg,
               'Gender: Female'=dfpg %>%
                                repfun::ru_labels(varlabels=lapply(sapply(dfpg,function(x){attr(x,"label")}),function(x) gsub('X','Y',x))))

repfun::ru_list(dsetin=mytbls,
               stackvar1=list(varsin=c('AESOC','AEDECOD'), varout='SYSPREF', sepc='', splitc=''),
               noprintvars=c('AEBODSYS'),
               columns=c('AEBODSYS','SYSPREF','tt_01','tt_02','tt_03'),
               nowidowvar='AEBODSYS',
               widths=c(13,2,2.3,2.3),
               skipvars=c('AEBODSYS'),
               centrevars=c('tt_01','tt_02','tt_03'),
               pagevars=c('MYPAGEVAR'),
               computebeforepagelines="paste0('This is page value: ',MYPAGEVAR)",
               lpp = 25,
               dddatasetlabel=paste0('DD Dataframe for AE Table ',repfun:::rfenv$G_DSPLYNUM))

## ----dddata5------------------------------------------------------------------
t5 <- readRDS(repfun:::rfenv$G_DDDATA) %>% dplyr::filter(SYSPREF != '') %>% dplyr::filter(row_number()<=10)
lbls <- sapply(t5,function(x){attr(x,"label")})
names(t5) <- paste(names(lbls),lbls,sep=": ")
datatable(
  t5, extensions = 'FixedColumns',
  options = list(
  dom = 't',
  pageLength=1000,
  scrollY = 300,
  scrollX = TRUE,
  scrollCollapse = TRUE
))

## ----maket6-------------------------------------------------------------------
setup(6)

df <- readRDS(file=tbl1dd) %>% dplyr::select(-PAGEVAR) %>% 
  dplyr::filter(!(AEDECOD == '') & !(AEBODSYS %in% names(SOCcnts[SOCcnts>=15]))) 
dfpg <- rbind(df %>% dplyr::mutate(MYPAGEVAR=1),df %>% dplyr::mutate(MYPAGEVAR=2)) %>% repfun::ru_labels(varlabels=list('MYPAGEVAR'='My Page Variable'))

repfun::ru_list(dsetin=dfpg,
        columns=c('AEBODSYS','AEDECOD','tt_01','tt_02','tt_03','tt_99'),
        widths=c(5.5,4.5,2,2,2,2),
        nowidowvar='AEBODSYS',
        skipvars=c('AEBODSYS'),
        centrevars=c('tt_01','tt_02','tt_03','tt_99'),
        pagevars=c('MYPAGEVAR'),
        computebeforepagelines="paste0('This is page value: ',MYPAGEVAR)",
        lpp=23,
        dddatasetlabel=paste0('DD Dataframe for AE Table ',repfun:::rfenv$G_DSPLYNUM))

## ----dddata6------------------------------------------------------------------
t6 <- readRDS(repfun:::rfenv$G_DDDATA) %>% dplyr::filter(AEDECOD != '') %>% dplyr::filter(row_number()<=10)
lbls <- sapply(t6,function(x){attr(x,"label")})
names(t6) <- paste(names(lbls),lbls,sep=": ")
datatable(
  t6, extensions = 'FixedColumns',
  options = list(
  dom = 't',
  pageLength=1000,
  scrollY = 300,
  scrollX = TRUE,
  scrollCollapse = TRUE
))

## ----maket7-------------------------------------------------------------------
setup(7)

df <- readRDS(file=tbl1dd) %>% dplyr::select(-PAGEVAR) %>%
  dplyr::filter(!(AEDECOD == '') & !(AEBODSYS %in% names(SOCcnts[SOCcnts>=15])))

dfpg <- rbind(df %>% dplyr::mutate(MYPAGEVAR1=1,MYPAGEVAR2=1),
              df %>% dplyr::mutate(MYPAGEVAR1=1,MYPAGEVAR2=2),
              df %>% dplyr::mutate(MYPAGEVAR1=2,MYPAGEVAR2=3),
              df %>% dplyr::mutate(MYPAGEVAR1=2,MYPAGEVAR2=4)) %>%
  repfun::ru_labels(varlabels=list('MYPAGEVAR'='My Page Variable'))

repfun::ru_list(dsetin=dfpg,
        columns=c('AEBODSYS','AEDECOD','tt_01','tt_02','tt_03','tt_99'),
        nowidowvar='AEBODSYS',
        widths=c(6,4,2,2,2,2),
        skipvars=c('AEBODSYS'),
        centrevars=c('tt_01','tt_02','tt_03','tt_99'),
        byvars=c('MYPAGEVAR2'),
        pagevars=c('MYPAGEVAR1'),
        computebeforepagelines="paste0('This is page value 1: ',MYPAGEVAR1,' and this is page value 2: ',MYPAGEVAR2)",
        lpp=23,
        dddatasetlabel=paste0('DD Dataframe for AE Table ',repfun:::rfenv$G_DSPLYNUM))

## ----dddata7------------------------------------------------------------------
t7 <- readRDS(repfun:::rfenv$G_DDDATA) %>% dplyr::filter(AEDECOD != '') %>% dplyr::filter(row_number()<=10)
lbls <- sapply(t7,function(x){attr(x,"label")})
names(t7) <- paste(names(lbls),lbls,sep=": ")
datatable(
  t7, extensions = 'FixedColumns',
  options = list(
  dom = 't',
  pageLength=1000,
  scrollY = 300,
  scrollX = TRUE,
  scrollCollapse = TRUE
))

## ----maket8-------------------------------------------------------------------
setup(8)
df <- readRDS(file=tbl1dd) %>%
  dplyr::select(-PAGEVAR) %>%
  dplyr::filter(!(AEDECOD == '') & !(AEBODSYS %in% names(SOCcnts[SOCcnts>=15])))

mytbls <- list('Gender: Male'=df,
               'Gender: Female'=df %>% 
                 repfun::ru_labels(varlabels=lapply(sapply(df,function(x){attr(x,"label")}),function(x) gsub('X','Y',x))))

repfun::ru_list(dsetin=mytbls,
        columns=c('AEBODSYS','AEDECOD','tt_01','tt_02','tt_03','tt_99'),
        nowidowvar='AEBODSYS',
        sharecolvars=c('AEBODSYS','AEDECOD'),
        widths=c(8.0,2,2,2,2),
        skipvars=c('AEBODSYS'),
        centrevars=c('tt_01','tt_02','tt_03','tt_99'),
        lpp=28,
        dddatasetlabel=paste0('DD Dataframe for AE Table ',repfun:::rfenv$G_DSPLYNUM))

## ----dddata8------------------------------------------------------------------
t8 <- readRDS(repfun:::rfenv$G_DDDATA) %>% dplyr::filter(gsub("\\s+", "", STACKVAR) != '') %>% dplyr::filter(row_number()<=10)
lbls <- sapply(t8,function(x){attr(x,"label")})
names(t8) <- paste(names(lbls),lbls,sep=": ")
datatable(
  t8, extensions = 'FixedColumns',
  options = list(
  dom = 't',
  pageLength=1000,
  scrollY = 300,
  scrollX = TRUE,
  scrollCollapse = TRUE
))

## ----maket9-------------------------------------------------------------------
setup(9)

df <- readRDS(file=tbl1dd) %>%
  dplyr::select(-PAGEVAR) %>%
  dplyr::filter(!(AEDECOD == '') & !(AEBODSYS %in% names(SOCcnts[SOCcnts>=15])))

repfun::ru_list(dsetin=df,
        columns=c('AEBODSYS','AEDECOD','tt_01','tt_02','tt_03','tt_99'),
        nowidowvar='AEBODSYS',
        widths=c(8.0,2,2,2,2),
        skipvars=c('AEBODSYS'),
        sharecolvars=c('AEBODSYS','AEDECOD'),
        centrevars=c('tt_01','tt_02','tt_03','tt_99'),
        labels=list('AEDECOD'='New AEDECOD Label', 'AEBODSYS'='New AEBODSYS Label'),
        lpp=28,
        dddatasetlabel=paste0('DD Dataframe for AE Table ',repfun:::rfenv$G_DSPLYNUM))

## ----dddata9------------------------------------------------------------------
t9 <- readRDS(repfun:::rfenv$G_DDDATA) %>% dplyr::filter(gsub("\\s+", "", STACKVAR) != '') %>% dplyr::filter(row_number()<=10)
lbls <- sapply(t9,function(x){attr(x,"label")})
names(t9) <- paste(names(lbls),lbls,sep=": ")
datatable(
  t9, extensions = 'FixedColumns',
  options = list(
  dom = 't',
  pageLength=1000,
  scrollY = 300,
  scrollX = TRUE,
  scrollCollapse = TRUE
))

## ----maket10------------------------------------------------------------------
setup(10)

df <- readRDS(file=tbl1dd) %>%
  dplyr::select(-PAGEVAR) %>%
  dplyr::filter(!(AEDECOD == '') & !(AEBODSYS %in% names(SOCcnts[SOCcnts>=15])))

dfpg <- rbind(df %>% dplyr::mutate(MYPAGEVAR1='1:XYZ',MYPAGEVAR2='1:JKL'),
              df %>% dplyr::mutate(MYPAGEVAR1='1:XYZ',MYPAGEVAR2='2:GHI'),
              df %>% dplyr::mutate(MYPAGEVAR1='2:UVW',MYPAGEVAR2='3:DEF'),
              df %>% dplyr::mutate(MYPAGEVAR1='2:UVW',MYPAGEVAR2='4:ABC')) %>%
  repfun::ru_labels(varlabels=list('MYPAGEVAR1'='My Page Variable 1',
                           'MYPAGEVAR2'='My Page Variable 2'))

repfun::ru_list(dsetin=dfpg,
        columns=c('AEBODSYS','AEDECOD','tt_01','tt_02','tt_03','tt_99'),
        nowidowvar='AEBODSYS',
        sharecolvars=c('AEBODSYS','AEDECOD'),
        widths=c(8,2,2,2,2),
        skipvars=c('AEBODSYS'),
        centrevars=c('tt_01','tt_02','tt_03','tt_99'),
        pagevars=c('MYPAGEVAR1','MYPAGEVAR2'),
        lpp=27,
        computebeforepagelines="paste0('This is page value 1: ',
                                sub('[0-9]:','',MYPAGEVAR1),
                                ' and this is page value 2: ',
                                sub('[0-9]:','',MYPAGEVAR2))",
        dddatasetlabel=paste0('DD Dataframe for AE Table ',repfun:::rfenv$G_DSPLYNUM))

## ----dddata10-----------------------------------------------------------------
t10 <- readRDS(repfun:::rfenv$G_DDDATA) %>% dplyr::filter(gsub("\\s+", "", STACKVAR) != '') %>% dplyr::filter(row_number()<=10)
lbls <- sapply(t10,function(x){attr(x,"label")})
names(t10) <- paste(names(lbls),lbls,sep=": ")
datatable(
  t10, extensions = 'FixedColumns',
  options = list(
  dom = 't',
  pageLength=1000,
  scrollY = 300,
  scrollX = TRUE,
  scrollCollapse = TRUE
))

## ----maket11------------------------------------------------------------------
setup(11)

df <- readRDS(file=tbl1dd) %>%
  dplyr::select(-PAGEVAR) %>% dplyr::filter(!(AEDECOD == '')) 
repfun::ru_list(dsetin=df,
        columns=c('AEBODSYS','AEDECOD','tt_01','tt_02','tt_03','tt_99'),
        sharecolvars=c('AEBODSYS','AEDECOD'),
        skipvars=c('AEBODSYS'),
        widths=c(8.0,2,2,2,2),
        centrevars=c('tt_01','tt_02','tt_03','tt_99'),
        dddatasetlabel=paste0('DD Dataframe for AE Table ',repfun:::rfenv$G_DSPLYNUM))

## ----dddata11-----------------------------------------------------------------
t11 <- readRDS(repfun:::rfenv$G_DDDATA) %>% dplyr::filter(gsub("\\s+", "", STACKVAR) != '') %>% dplyr::filter(row_number()<=10)
lbls <- sapply(t11,function(x){attr(x,"label")})
names(t11) <- paste(names(lbls),lbls,sep=": ")
datatable(
  t11, extensions = 'FixedColumns',
  options = list(
  dom = 't',
  pageLength=1000,
  scrollY = 300,
  scrollX = TRUE,
  scrollCollapse = TRUE
))

## ----maket12------------------------------------------------------------------
setup(12)

df <- readRDS(file=tbl1dd) %>%
  dplyr::select(-PAGEVAR) %>% dplyr::filter(!(AEDECOD == '')) 
repfun::ru_list(dsetin=df,
        columns=c('AEBODSYS','AEDECOD','tt_01','tt_02','tt_03','tt_99'),
        skipvars=c('AEBODSYS'),
        ordervars=c('AEBODSYS','AEDECOD'),
        orderdata=TRUE,
        widths=c(6,4,2,2,2,2),
        centrevars=c('tt_01','tt_02','tt_03','tt_99'),
        dddatasetlabel=paste0('DD Dataframe for AE Table ',repfun:::rfenv$G_DSPLYNUM))

## ----dddata12-----------------------------------------------------------------
t12 <- readRDS(repfun:::rfenv$G_DDDATA) %>% dplyr::filter(AEDECOD != '') %>% dplyr::filter(row_number()<=10)
lbls <- sapply(t12,function(x){attr(x,"label")})
names(t12) <- paste(names(lbls),lbls,sep=": ")
datatable(
  t12, extensions = 'FixedColumns',
  options = list(
  dom = 't',
  pageLength=1000,
  scrollY = 300,
  scrollX = TRUE,
  scrollCollapse = TRUE
))

## ----maket13------------------------------------------------------------------
setup(13)

df <- readRDS(file=tbl1dd) %>%
  dplyr::select(-PAGEVAR) %>%
  dplyr::filter(!(AEDECOD == '') & !(AEBODSYS %in% names(SOCcnts[SOCcnts>=15])))

dfpg <- rbind(df %>% dplyr::mutate(MYPAGEVAR1=1,MYPAGEVAR2=1),
              df %>% dplyr::mutate(MYPAGEVAR1=1,MYPAGEVAR2=2),
              df %>% dplyr::mutate(MYPAGEVAR1=2,MYPAGEVAR2=3),
              df %>% dplyr::mutate(MYPAGEVAR1=2,MYPAGEVAR2=4))

repfun::ru_list(dsetin=dfpg,
        columns=c('AEBODSYS','AEDECOD','tt_01','tt_02','tt_03','tt_99'),
        nowidowvar='AEBODSYS',
        skipvars='AEBODSYS',
        centrevars=c('tt_01','tt_02','tt_03','tt_99'),
        byvars=c('MYPAGEVAR2'),
        pagevars=c('MYPAGEVAR1'),
        widths=c(6,4,2,2,2,2),
        lpp=23,
        computebeforepagelines="paste0('This is page value 1: ',MYPAGEVAR1,' and this is page value 2: ',MYPAGEVAR2)",
        dddatasetlabel=paste0('DD Dataframe for AE Table ',repfun:::rfenv$G_DSPLYNUM))

## ----dddata13-----------------------------------------------------------------
t13 <- readRDS(repfun:::rfenv$G_DDDATA) %>% dplyr::filter(AEDECOD != '') %>% dplyr::filter(row_number()<=10)
lbls <- sapply(t13,function(x){attr(x,"label")})
names(t13) <- paste(names(lbls),lbls,sep=": ")
datatable(
  t13, extensions = 'FixedColumns',
  options = list(
  dom = 't',
  pageLength=1000,
  scrollY = 300,
  scrollX = TRUE,
  scrollCollapse = TRUE
))

## ----maket14------------------------------------------------------------------
setup(14)

df <- readRDS(file=tbl1dd) %>%
  dplyr::select(-PAGEVAR) %>%
  dplyr::filter(!(AEDECOD == ''))

dfpg <- rbind(df %>% dplyr::mutate(MYPAGEVAR1=1,MYPAGEVAR2=1),
              df %>% dplyr::mutate(MYPAGEVAR1=1,MYPAGEVAR2=2),
              df %>% dplyr::mutate(MYPAGEVAR1=2,MYPAGEVAR2=3),
              df %>% dplyr::mutate(MYPAGEVAR1=2,MYPAGEVAR2=4))

repfun::ru_list(dsetin=dfpg,
        columns=c('AEBODSYS','AEDECOD','tt_01','tt_02','tt_03','tt_99'),
        skipvars='AEBODSYS',
        ordervars=c('AEBODSYS','AEDECOD'),
        orderdata=TRUE,
        centrevars=c('tt_01','tt_02','tt_03','tt_99'),
        widths=c(6,4,2,2,2,2),
        byvars=c('MYPAGEVAR2'),
        pagevars=c('MYPAGEVAR1'),
        computebeforepagelines="paste0('This is page value 1: ',MYPAGEVAR1,' and this is page value 2: ',MYPAGEVAR2)",
        dddatasetlabel=paste0('DD Dataframe for AE Table ',repfun:::rfenv$G_DSPLYNUM))

## ----dddata14-----------------------------------------------------------------
t14 <- readRDS(repfun:::rfenv$G_DDDATA) %>% dplyr::filter(AEDECOD != '') %>% dplyr::filter(row_number()<=10)
lbls <- sapply(t14,function(x){attr(x,"label")})
names(t14) <- paste(names(lbls),lbls,sep=": ")
datatable(
  t14, extensions = 'FixedColumns',
  options = list(
  dom = 't',
  pageLength=1000,
  scrollY = 300,
  scrollX = TRUE,
  scrollCollapse = TRUE
))

## ----cleanup------------------------------------------------------------------
unlink(tmpdr, recursive = TRUE)

