/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.modelling.regression;

import jdplus.toolkit.base.api.processing.ProcessingLog;
import jdplus.toolkit.base.api.timeseries.TimeSeriesDomain;
import jdplus.toolkit.base.api.timeseries.TimeSeriesInterval;
import jdplus.toolkit.base.api.timeseries.TsPeriod;
import jdplus.toolkit.base.api.timeseries.regression.PeriodicDummies;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.modelling.regression.RegressionVariableFactory;

public class PeriodicDummiesFactory
implements RegressionVariableFactory<PeriodicDummies> {
    static PeriodicDummiesFactory FACTORY = new PeriodicDummiesFactory();

    public static FastMatrix matrix(PeriodicDummies var, int length, int start) {
        int period = var.getPeriod();
        FastMatrix m = FastMatrix.make(length, period);
        int pstart = start % period;
        for (int i = 0; i < period; ++i) {
            DataBlock x = m.column(i);
            int jstart = i - pstart;
            if (jstart < 0) {
                jstart += period;
            }
            x.extract(jstart, -1, period).set(1.0);
        }
        return m;
    }

    private PeriodicDummiesFactory() {
    }

    @Override
    public boolean fill(PeriodicDummies var, TsPeriod start, FastMatrix buffer, ProcessingLog log) {
        int period = var.getPeriod();
        TsPeriod refPeriod = start.withDate(var.getReference());
        long del = start.getId() - refPeriod.getId();
        int pstart = (int)del % period;
        for (int i = 0; i < period; ++i) {
            DataBlock x = buffer.column(i);
            int jstart = i - pstart;
            if (jstart < 0) {
                jstart += period;
            }
            DataBlock m = x.extract(jstart, -1, period);
            m.set(1.0);
        }
        return true;
    }

    @Override
    public <P extends TimeSeriesInterval<?>, D extends TimeSeriesDomain<P>> boolean fill(PeriodicDummies var, D domain, FastMatrix buffer, ProcessingLog log) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

