/*
 * Decompiled with CFR 0.152.
 */
package jdplus.sa.base.core.tests;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.dstats.ContinuousDistribution;
import jdplus.toolkit.base.api.stats.StatisticalTest;
import jdplus.toolkit.base.api.stats.TestType;
import jdplus.toolkit.base.core.data.analysis.Periodogram;
import jdplus.toolkit.base.core.dstats.Chi2;
import jdplus.toolkit.base.core.dstats.F;
import jdplus.toolkit.base.core.stats.tests.TestsUtility;

public class PeriodogramTest {
    private static final double D = 0.01;
    private final DoubleSeq sample;
    private final int period;

    public PeriodogramTest(DoubleSeq sample, int period) {
        this.sample = sample;
        this.period = period;
    }

    public StatisticalTest buildChi2() {
        double[] seasfreqs = new double[(this.period - 1) / 2];
        for (int i = 0; i < seasfreqs.length; ++i) {
            seasfreqs[i] = (double)((i + 1) * 2) * Math.PI / (double)this.period;
        }
        Periodogram periodogram = Periodogram.of((DoubleSeq)this.sample);
        double[] p = periodogram.getP();
        double xsum = 0.0;
        double dstep = periodogram.getIntervalInRadians();
        double estep = dstep * 0.01;
        int nf = 0;
        for (int i = 0; i < seasfreqs.length; ++i) {
            double f = seasfreqs[i];
            int j = (int)(seasfreqs[i] / dstep);
            if (f - (double)(j - 1) * dstep < estep) {
                nf += 2;
                xsum += p[j - 1];
            }
            if (f - (double)j * dstep < estep) {
                nf += 2;
                xsum += p[j];
            }
            if (!((double)(j + 1) * dstep - f < estep)) continue;
            nf += 2;
            xsum += p[j + 1];
        }
        if (this.period % 2 == 0) {
            ++nf;
            xsum += p[p.length - 1];
        }
        Chi2 chi2 = new Chi2((double)nf);
        return TestsUtility.testOf((double)xsum, (ContinuousDistribution)chi2, (TestType)TestType.Upper);
    }

    private DoubleSeq expand(DoubleSeq data) {
        int n = data.length();
        if (n % this.period == 0) {
            return data;
        }
        double[] nd = new double[(1 + n / this.period) * this.period];
        data.copyTo(nd, 0);
        return DoubleSeq.of((double[])nd);
    }

    private DoubleSeq shrink(DoubleSeq data) {
        int n = data.length();
        if (n % this.period == 0) {
            return data;
        }
        int nc = n - n % this.period;
        double[] nd = new double[nc];
        data.extract(n - nc, nc).copyTo(nd, 0);
        return DoubleSeq.of((double[])nd);
    }

    public StatisticalTest buildF() {
        DoubleSeq data = this.shrink(this.sample);
        Periodogram periodogram = Periodogram.of((DoubleSeq)data);
        double[] p = periodogram.getP();
        double xsum = 0.0;
        int f2 = (this.period - 1) / 2;
        int nf = 2 * f2;
        int m = data.length() / this.period;
        for (int i = 1; i <= f2; ++i) {
            xsum += p[i * m];
        }
        if (this.period % 2 == 0) {
            ++nf;
            xsum += p[p.length - 1];
        }
        int n = data.length();
        F f = new F((double)nf, (double)(n - nf - 1));
        double val = (double)(n - nf - 1) * xsum / ((double)n - xsum - p[0]) / (double)nf;
        return TestsUtility.testOf((double)val, (ContinuousDistribution)f, (TestType)TestType.Upper);
    }

    public double computeMax() {
        double[] seasfreqs = new double[(this.period - 1) / 2];
        for (int i = 0; i < seasfreqs.length; ++i) {
            seasfreqs[i] = (double)((i + 1) * 2) * Math.PI / (double)this.period;
        }
        Periodogram periodogram = Periodogram.of((DoubleSeq)this.sample);
        double[] p = periodogram.getP();
        double xmax = 0.0;
        double dstep = periodogram.getIntervalInRadians();
        double estep = dstep * 0.01;
        int nf = 0;
        for (int i = 0; i < seasfreqs.length; ++i) {
            double f = seasfreqs[i];
            int j = (int)(seasfreqs[i] / dstep);
            if (f - (double)(j - 1) * dstep < estep) {
                ++nf;
                xmax = Math.max(xmax, p[j - 1]);
            }
            if (f - (double)j * dstep < estep) {
                ++nf;
                xmax = Math.max(xmax, p[j]);
            }
            if (!((double)(j + 1) * dstep - f < estep)) continue;
            ++nf;
            xmax = Math.max(xmax, p[j + 1]);
        }
        return 1.0 - Math.pow(1.0 - Math.exp(-xmax * 0.5), nf);
    }
}

