/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.formula;

import java.text.ParseException;
import java.util.List;
import org.vikamine.kernel.formula.ASTBuilder;
import org.vikamine.kernel.formula.DefaultASTBuilder;
import org.vikamine.kernel.formula.DefaultScanner;
import org.vikamine.kernel.formula.DefaultValidator;
import org.vikamine.kernel.formula.ParserElement;
import org.vikamine.kernel.formula.Scanner;
import org.vikamine.kernel.formula.Validator;
import org.vikamine.kernel.formula.exception.ASTBuildingException;
import org.vikamine.kernel.formula.exception.ValidateException;

public class Parser {
    protected Scanner scanner;
    protected ASTBuilder astBuilder;
    protected Validator validator;

    public ParserElement parse(String text, Class expectedType) throws ParseException, ASTBuildingException, ValidateException {
        List parserElements = this.getScanner().scan(text);
        if (parserElements.isEmpty()) {
            return null;
        }
        ParserElement ast = this.getASTBuilder().buildAST(parserElements);
        try {
            this.getValidator().validate(ast, expectedType);
        }
        catch (ValidateException e) {
            e.setAST(ast);
            throw e;
        }
        return ast;
    }

    public ASTBuilder getASTBuilder() {
        if (this.astBuilder == null) {
            this.astBuilder = new DefaultASTBuilder();
        }
        return this.astBuilder;
    }

    public void setASTBuilder(ASTBuilder astBuilder) {
        this.astBuilder = astBuilder;
    }

    public Scanner getScanner() {
        if (this.scanner == null) {
            this.scanner = new DefaultScanner();
        }
        return this.scanner;
    }

    public void setScanner(Scanner scanner) {
        this.scanner = scanner;
    }

    public Validator getValidator() {
        if (this.validator == null) {
            this.validator = new DefaultValidator();
        }
        return this.validator;
    }

    public void setValidator(Validator validator) {
        this.validator = validator;
    }
}

