/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.subgroup.search;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.vikamine.kernel.data.Attribute;
import org.vikamine.kernel.data.DataRecord;
import org.vikamine.kernel.data.NominalAttribute;
import org.vikamine.kernel.data.Value;
import org.vikamine.kernel.subgroup.SG;
import org.vikamine.kernel.subgroup.SGDescription;
import org.vikamine.kernel.subgroup.SGSet;
import org.vikamine.kernel.subgroup.search.SDMap;
import org.vikamine.kernel.subgroup.selectors.DefaultSGSelector;
import org.vikamine.kernel.subgroup.selectors.FastSelector;
import org.vikamine.kernel.subgroup.selectors.NegatedSGSelector;
import org.vikamine.kernel.subgroup.selectors.SGNominalSelector;
import org.vikamine.kernel.subgroup.selectors.SGSelector;
import org.vikamine.kernel.subgroup.target.SGTarget;

public class SDMapDisjunctive
extends SDMap {
    private boolean excludeUnknown = true;
    private static final String NAME = "SDMapDisjunctive";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    protected List<SGSelector> getSelectorSet(SG initialSubgroup, SGTarget target) {
        ArrayList<SGSelector> selectors = new ArrayList<SGSelector>();
        for (SGSelector selSource : this.selectorsCache) {
            if (!(selSource instanceof SGNominalSelector)) {
                throw new IllegalArgumentException("SDMap disjunctive only be used with nominal selectors!");
            }
            SGNominalSelector sel = (SGNominalSelector)selSource;
            selectors.add(new NegatedDefinedSGSelector(new FastSelector(sel.getAttribute(), (Set)sel.getValues())));
        }
        return selectors;
    }

    private void convertToSGDescriptionWithoutNegation(SG sg) {
        SGDescription sgd = sg.getSGDescription();
        ArrayList<DefaultSGSelector> selectors = new ArrayList<DefaultSGSelector>();
        HashMap<Attribute, ArrayList<SGNominalSelector>> attributesToSelectors = new HashMap<Attribute, ArrayList<SGNominalSelector>>();
        for (SGNominalSelector sGNominalSelector : sgd) {
            if (!(sGNominalSelector instanceof NegatedSGSelector)) {
                selectors.add(new DefaultSGSelector((DefaultSGSelector)sGNominalSelector));
                continue;
            }
            ArrayList<SGNominalSelector> selectorsForAttribute = (ArrayList<SGNominalSelector>)attributesToSelectors.get(sGNominalSelector.getAttribute());
            if (selectorsForAttribute == null) {
                selectorsForAttribute = new ArrayList<SGNominalSelector>();
                attributesToSelectors.put(sGNominalSelector.getAttribute(), selectorsForAttribute);
            }
            selectorsForAttribute.add(sGNominalSelector);
        }
        for (Map.Entry entry : attributesToSelectors.entrySet()) {
            NominalAttribute a = (NominalAttribute)entry.getKey();
            List negatedSelectorsForAttribute = (List)entry.getValue();
            HashSet<Value> realSelectorValues = new HashSet<Value>();
            Iterator<Value> iterator = a.allValuesIterator();
            while (iterator.hasNext()) {
                Value val = iterator.next();
                if (this.isExcludeUnknown() && val.getId().equals("MaU")) continue;
                boolean contained = false;
                for (NegatedSGSelector sel : negatedSelectorsForAttribute) {
                    if (!sel.getValues().contains(val)) continue;
                    contained = true;
                    break;
                }
                if (contained) continue;
                realSelectorValues.add(val);
            }
            if (!realSelectorValues.isEmpty()) {
                selectors.add(new DefaultSGSelector((Attribute)a, realSelectorValues));
                continue;
            }
            throw new IllegalStateException("Converted value is missing!");
        }
        SGDescription converted = new SGDescription();
        converted.addAll(selectors);
        sg.setSGDescription(converted);
    }

    @Override
    protected void convertSGDescription(SG sg) {
        this.convertToSGDescriptionWithoutNegation(sg);
    }

    @Override
    protected SGSet search(SG initialSubgroup) {
        return super.search(initialSubgroup);
    }

    public boolean isExcludeUnknown() {
        return this.excludeUnknown;
    }

    public void setExcludeUnknown(boolean isExcludeUnknown) {
        this.excludeUnknown = isExcludeUnknown;
    }

    private static class NegatedDefinedSGSelector
    extends NegatedSGSelector {
        public NegatedDefinedSGSelector(SGNominalSelector positive) {
            super(positive);
        }

        @Override
        public boolean isContainedInInstance(DataRecord instance) {
            if (instance.isMissing(this.getPositiveSelector().getAttribute())) {
                return false;
            }
            return super.isContainedInInstance(instance);
        }
    }
}

