/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.subgroup.selectors;

import java.text.DecimalFormat;
import org.vikamine.kernel.Describer;
import org.vikamine.kernel.data.Attribute;
import org.vikamine.kernel.data.DataRecord;
import org.vikamine.kernel.data.NumericAttribute;
import org.vikamine.kernel.subgroup.selectors.SGSelector;

public class NumericSelector
implements SGSelector {
    private static final DecimalFormat format = new DecimalFormat("#.###");
    final NumericAttribute att;
    final boolean includeLowerBound;
    final boolean includeUpperBound;
    final double lowerBound;
    final double upperBound;

    public boolean isIncludeLowerBound() {
        return this.includeLowerBound;
    }

    public boolean isIncludeUpperBound() {
        return this.includeUpperBound;
    }

    public NumericSelector(NumericAttribute att, double lowerBound, double upperBound) {
        this.att = att;
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
        this.includeLowerBound = false;
        this.includeUpperBound = false;
    }

    public NumericSelector(NumericAttribute att, double lowerBound, double upperBound, boolean includeLowerBound, boolean includeUpperBound) {
        this.att = att;
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
        this.includeLowerBound = includeLowerBound;
        this.includeUpperBound = includeUpperBound;
    }

    @Override
    public Object clone() {
        return new NumericSelector(this.att, this.lowerBound, this.upperBound, this.includeLowerBound, this.includeUpperBound);
    }

    @Override
    public Attribute getAttribute() {
        return this.att;
    }

    @Override
    public String getDescription() {
        return this.getId();
    }

    @Override
    public String getDescription(Describer dEr) {
        return this.getDescription();
    }

    @Override
    public String getId() {
        String result = this.att.getDescription();
        result = String.valueOf(result) + this.getValueId();
        return result;
    }

    public String getValueId() {
        String result = "";
        result = this.includeLowerBound && this.lowerBound != Double.NEGATIVE_INFINITY ? String.valueOf(result) + "[" : String.valueOf(result) + "]";
        result = String.valueOf(result) + format.format(this.lowerBound) + ";" + format.format(this.upperBound);
        result = this.includeUpperBound && this.upperBound != Double.POSITIVE_INFINITY ? String.valueOf(result) + "]" : String.valueOf(result) + "[";
        return result;
    }

    public double getLowerBound() {
        return this.lowerBound;
    }

    public double getUpperBound() {
        return this.upperBound;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.att == null ? 0 : this.att.hashCode());
        result = 31 * result + (this.includeLowerBound ? 1231 : 1237);
        result = 31 * result + (this.includeUpperBound ? 1231 : 1237);
        long temp = Double.doubleToLongBits(this.lowerBound);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.upperBound);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NumericSelector other = (NumericSelector)obj;
        if (this.att == null ? other.att != null : !this.att.equals(other.att)) {
            return false;
        }
        if (this.includeLowerBound != other.includeLowerBound) {
            return false;
        }
        if (this.includeUpperBound != other.includeUpperBound) {
            return false;
        }
        if (Double.doubleToLongBits(this.lowerBound) != Double.doubleToLongBits(other.lowerBound)) {
            return false;
        }
        return Double.doubleToLongBits(this.upperBound) == Double.doubleToLongBits(other.upperBound);
    }

    @Override
    public boolean isContainedInInstance(DataRecord instance) {
        double val = instance.getValue(this.att);
        if (Double.isNaN(val)) {
            return false;
        }
        if (val < this.lowerBound || !this.includeLowerBound && val == this.lowerBound) {
            return false;
        }
        return !(val > this.upperBound) && (this.includeUpperBound || val != this.upperBound);
    }

    public String toString() {
        return this.getDescription();
    }

    @Override
    public boolean includes(SGSelector otherSel) {
        if (!(otherSel instanceof NumericSelector)) {
            return false;
        }
        if (this.getAttribute() != otherSel.getAttribute()) {
            return false;
        }
        NumericSelector otherNumSel = (NumericSelector)otherSel;
        if (otherNumSel.lowerBound < this.lowerBound) {
            return false;
        }
        if (otherNumSel.lowerBound == this.lowerBound && otherNumSel.includeLowerBound && !this.includeLowerBound) {
            return false;
        }
        if (otherNumSel.upperBound > this.upperBound) {
            return false;
        }
        return otherNumSel.upperBound != this.upperBound || !otherNumSel.includeUpperBound || this.includeUpperBound;
    }

    public NumericSelector join(NumericSelector sel) {
        boolean newIncludeupperBound;
        double newupperBound;
        boolean newIncludeLowerBound;
        double newLowerBound;
        if (this.lowerBound < sel.lowerBound) {
            newLowerBound = sel.lowerBound;
            newIncludeLowerBound = sel.includeLowerBound;
        } else if (this.lowerBound == sel.lowerBound) {
            newLowerBound = sel.lowerBound;
            newIncludeLowerBound = sel.includeLowerBound && this.includeLowerBound;
        } else {
            newLowerBound = this.lowerBound;
            newIncludeLowerBound = this.includeLowerBound;
        }
        if (this.upperBound > sel.upperBound) {
            newupperBound = sel.upperBound;
            newIncludeupperBound = sel.includeUpperBound;
        } else if (this.upperBound == sel.upperBound) {
            newupperBound = sel.upperBound;
            newIncludeupperBound = sel.includeUpperBound && this.includeUpperBound;
        } else {
            newupperBound = this.upperBound;
            newIncludeupperBound = this.includeUpperBound;
        }
        return new NumericSelector(this.att, newLowerBound, newupperBound, newIncludeLowerBound, newIncludeupperBound);
    }
}

