/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.rexp.evaluator;

import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.jpmml.evaluator.Function;
import org.jpmml.evaluator.FunctionRegistry;
import org.jpmml.rexp.evaluator.functions.PPois;

public class RExpFunctionRegistry {
    private static final Map<String, Function> functions;
    private static final Map<String, Class<? extends Function>> functionClazzes;

    private RExpFunctionRegistry() {
    }

    public static void publish(String name) {
        RExpFunctionRegistry.publish((String key) -> Objects.equals(name, key));
    }

    public static void publishAll() {
        RExpFunctionRegistry.publish((String key) -> true);
    }

    private static void publish(Predicate<String> predicate) {
        functions.entrySet().stream().filter(entry -> predicate.test((String)entry.getKey())).forEach(entry -> FunctionRegistry.putFunction((String)((String)entry.getKey()), (Function)((Function)entry.getValue())));
        functionClazzes.entrySet().stream().filter(entry -> predicate.test((String)entry.getKey())).forEach(entry -> FunctionRegistry.putFunction((String)((String)entry.getKey()), (Class)((Class)entry.getValue())));
    }

    static {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        builder.put((Object)"stats::ppois", (Object)new PPois());
        functions = builder.build();
        functionClazzes = Collections.emptyMap();
    }
}

