/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.math.matrices;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.data.DoubleSeqCursor;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.data.DataBlockIterator;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;

public class QuadraticForm {
    private final FastMatrix S;

    private QuadraticForm(FastMatrix s) {
        this.S = s;
    }

    public static QuadraticForm of(FastMatrix s) {
        if (!s.isSymmetric(0.0)) {
            return null;
        }
        return new QuadraticForm(s);
    }

    public static QuadraticForm ofSymmetric(FastMatrix s) {
        return new QuadraticForm(s);
    }

    public double apply(DoubleSeq x) {
        DataBlockIterator columns = this.S.columnsIterator();
        DoubleSeqCursor cell = x.cursor();
        double s = 0.0;
        while (columns.hasNext()) {
            s += cell.getAndNext() * columns.next().dot(x);
        }
        return s;
    }

    public static double apply(FastMatrix M, DataBlock x) {
        double[] pm = M.getStorage();
        double[] px = x.getStorage();
        int x0 = x.getStartPosition();
        int x1 = x.getEndPosition();
        int xinc = x.getIncrement();
        int m0 = M.getStartPosition();
        int cinc = M.getColumnIncrement();
        double s = 0.0;
        int ic = m0;
        int id = m0;
        int ix = x0;
        while (ix != x1) {
            double xi = px[ix];
            double z = pm[id] * xi;
            int ir = ic;
            for (int jx = x0; jx < ix; jx += xinc) {
                z += 2.0 * pm[ir] * px[jx];
                ++ir;
            }
            s += z * xi;
            ix += xinc;
            id += 1 + cinc;
            ic += cinc;
        }
        return s;
    }
}

