/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.util;

public class WildCards {
    private final String w;
    private final char[] wa;
    private int[] na;
    private int la;
    private int lw;
    private String c;
    private int lmin;
    private int lc;

    public WildCards(String wc) {
        this.w = wc;
        this.lw = wc.length();
        this.wa = this.w.toCharArray();
        this.prepare();
    }

    public String toString() {
        return this.w;
    }

    public boolean match(String str) {
        this.c = str;
        this.lc = str.length();
        if (this.lc < this.lmin) {
            return false;
        }
        if (this.na == null && this.lc != this.lw) {
            return false;
        }
        this.initTest();
        do {
            if (!this.test()) continue;
            return true;
        } while (this.nextTest());
        return false;
    }

    private void prepare() {
        this.sort();
        this.simplify();
    }

    private void sort() {
        boolean changed;
        do {
            changed = false;
            for (int i = 1; i < this.lw; ++i) {
                if (this.wa[i] != '?' || this.wa[i - 1] != '*') continue;
                this.wa[i] = 42;
                this.wa[i - 1] = 63;
                changed = true;
            }
        } while (changed);
    }

    private void simplify() {
        int ns = 0;
        for (int i = 0; i < this.lw; ++i) {
            int j;
            if (this.wa[i] != '*') continue;
            ++ns;
            for (j = i + 1; j < this.lw && this.wa[j] == '*'; ++j) {
            }
            if (j - i <= 1) continue;
            int k = j;
            int l = i + 1;
            while (k < this.lw) {
                this.wa[l] = this.wa[k];
                ++k;
                ++l;
            }
            this.lw -= j - i - 1;
        }
        if (ns > 0) {
            this.lmin = this.lw - ns;
            this.na = new int[ns];
        } else {
            this.lmin = this.lw;
        }
    }

    private boolean test() {
        int j = 0;
        int k = 0;
        for (int i = 0; i < this.lw; ++i) {
            if (this.wa[i] == '*') {
                k += this.na[j++];
                continue;
            }
            if (this.wa[i] != '?' && this.wa[i] != this.c.charAt(k)) {
                return false;
            }
            ++k;
        }
        return true;
    }

    private void initTest() {
        this.la = this.lc - this.lmin;
        if (this.na != null) {
            int ia = this.na.length - 1;
            for (int i = 0; i < ia; ++i) {
                this.na[i] = 0;
            }
            this.na[ia] = this.la;
        }
    }

    private boolean nextTest() {
        int ir;
        if (this.na == null || this.na.length == 1) {
            return false;
        }
        int ia = 0;
        int il = this.na.length - 1;
        for (ir = this.la; ia < il && ir != this.na[ia]; ir -= this.na[ia], ++ia) {
        }
        if (ia == 0) {
            return false;
        }
        int n = ia - 1;
        this.na[n] = this.na[n] + 1;
        --ir;
        for (int i = ia; i < il; ++i) {
            this.na[i] = 0;
        }
        this.na[il] = ir;
        return true;
    }

    public static boolean hasWildCards(String str) {
        return str.indexOf(42) >= 0 || str.indexOf(63) >= 0;
    }
}

