## ----setup, include = FALSE---------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----readindata, message = FALSE----------------------------------------------
library(mars)

becker09 <- na.omit(becker09) # ommiting studies with NA

## ----convert_data-------------------------------------------------------------
becker09_list <- df_to_corr(becker09, 
                            variables = c('Cognitive_Performance',
                                          'Somatic_Performance',
                                          'Selfconfidence_Performance', 
                                          'Somatic_Cognitive',
                                          'Selfconfidence_Cognitive',
                                          'Selfconfidence_Somatic'),
                            ID = 'ID')

## ----os-----------------------------------------------------------------------
#olkin_siotani(becker09_list, becker09$N, type = 'simple')
#olkin_siotani(becker09_list, becker09$N, type = 'average')
olkin_siotani(becker09_list, becker09$N, type = 'weighted')

## ----prep_data, eval = FALSE--------------------------------------------------
# mars(data = becker09, studyID = 'ID',
#      effectID = 'numID', sample_size = 'N',
#      effectsize_type = 'cor',
#      estimation_method = 'FE',
#      varcov_type = 'weighted',
#      variable_names = c('Cognitive_Performance', 'Somatic_Performance',
#                         'Selfconfidence_Performance',
#                         'Somatic_Cognitive',
#                         'Selfconfidence_Cognitive',
#                         'Selfconfidence_Somatic')) |>
#   summary()

## ----random-effect------------------------------------------------------------
model_out_random <- mars(data = becker09, studyID = 'ID',
     effectID = 'numID', sample_size = 'N',
     effectsize_type = 'cor',
     varcov_type = 'weighted',
     variable_names = c('Cognitive_Performance', 'Somatic_Performance',
                        'Selfconfidence_Performance',
                        'Somatic_Cognitive',
                        'Selfconfidence_Cognitive',
                        'Selfconfidence_Somatic'))
summary(model_out_random)

## ----model_path---------------------------------------------------------------
model <- "## Regression paths
Performance ~ Cognitive + Somatic + Selfconfidence
Selfconfidence ~ Cognitive + Somatic
"


mars(data = becker09, studyID = 'ID',
     effectID = 'numID', sample_size = 'N',
     effectsize_type = 'cor',
     varcov_type = 'weighted',
     variable_names = c('Cognitive_Performance', 'Somatic_Performance',
                        'Selfconfidence_Performance',
                        'Somatic_Cognitive',
                        'Selfconfidence_Cognitive',
                        'Selfconfidence_Somatic')) |>
  path_model(model = model) |>
  summary()

## ----team---------------------------------------------------------------------
becker09_T <- subset(becker09, becker09$Team == "T")


## ----prep_data2---------------------------------------------------------------
mars(data = becker09_T, studyID = 'ID',
     effectID = 'numID', sample_size = 'N',
     effectsize_type = 'cor',
     varcov_type = 'weighted',
     variable_names = c('Cognitive_Performance', 'Somatic_Performance',
                        'Selfconfidence_Performance',
                        'Somatic_Cognitive',
                        'Selfconfidence_Cognitive',
                        'Selfconfidence_Somatic')) |>
  summary()
# random_model2 <- fit_model(data = input_metafor2, effect_size = 'yi', 
#                            var_cor = 'V', moderators = ~ -1 + factor(outcome), 
#                            random_params = ~ factor(outcome) | factor(study))


## ----model_path2--------------------------------------------------------------
model <- "## Regression paths
Performance ~ Cognitive + Somatic + Selfconfidence
Selfconfidence ~ Cognitive + Somatic
"


mars(data = becker09_T, studyID = 'ID',
     effectID = 'numID', sample_size = 'N',
     effectsize_type = 'cor',
     varcov_type = 'weighted',
     variable_names = c('Cognitive_Performance', 'Somatic_Performance',
                        'Selfconfidence_Performance',
                        'Somatic_Cognitive',
                        'Selfconfidence_Cognitive',
                        'Selfconfidence_Somatic')) |>
  path_model(model = model) |>
  summary()

## ----Indiv--------------------------------------------------------------------
becker09_I <- subset(becker09, becker09$Team == "I")


## ----prep_data3---------------------------------------------------------------
mars(data = becker09_I, studyID = 'ID',
     effectID = 'numID', sample_size = 'N',
     effectsize_type = 'cor',
     varcov_type = 'weighted',
     variable_names = c('Cognitive_Performance', 'Somatic_Performance',
                        'Selfconfidence_Performance',
                        'Somatic_Cognitive',
                        'Selfconfidence_Cognitive',
                        'Selfconfidence_Somatic')) |>
  summary()

# random_model3 <- fit_model(data = input_metafor3, effect_size = 'yi', 
#                            var_cor = 'V', moderators = ~ -1 + factor(outcome), 
#                            random_params = ~ factor(outcome) | factor(study))


## ----model_path3--------------------------------------------------------------
model <- "## Regression paths
Performance ~ Cognitive + Somatic + Selfconfidence
Selfconfidence ~ Cognitive + Somatic
"


mars(data = becker09_I, studyID = 'ID',
     effectID = 'numID', sample_size = 'N',
     effectsize_type = 'cor',
     varcov_type = 'weighted',
     variable_names = c('Cognitive_Performance', 'Somatic_Performance',
                        'Selfconfidence_Performance',
                        'Somatic_Cognitive',
                        'Selfconfidence_Cognitive',
                        'Selfconfidence_Somatic')) |>
  path_model(model = model) |>
  summary()

## ----pipe, eval = FALSE-------------------------------------------------------
# # partial corr matrix
# part_cor <- round(corpcor::vec2sm(model_out_random$beta_r),3)
# diag(part_cor) <- 1
# part_cor
# 
# # var-cov matrix of partials
# Psy <- model_out_random$varcov_beta
# round(var_path(model_out_random$beta_r, Psy, type = 'pcor'), 4)

## ----partial, eval = FALSE----------------------------------------------------
# #---------------------------------------------------------------------
# # Create a data set with 8 complete studies
# #---------------------------------------------------------------------
# R <-  becker09_list
# R$"6" <- NULL
# R$"17" <- NULL
# n <- becker09$N[c(-3, -5)]
# #------------------------------------------------------------------
# # first replace NA by zeros
# RR <- R                           # redifine list
# 
# PR <- lapply(RR, cor2pcor)
# pr <- unlist(lapply(PR, '[[', 4))
# var_pr <- (1-pr^2)^2 / (n - 3 -1)
# 
# rma.uni(pr, var_pr)

