/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.integer.extension;

import choco.cp.solver.variables.integer.AbstractIntDomain;
import choco.kernel.common.util.iterators.DisposableIntIterator;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.Solver;
import choco.kernel.solver.constraints.AbstractSConstraint;
import choco.kernel.solver.constraints.integer.extension.BinRelation;
import choco.kernel.solver.constraints.integer.extension.ConsistencyRelation;
import choco.kernel.solver.constraints.integer.extension.CspBinSConstraint;
import choco.kernel.solver.variables.integer.IntDomainVar;
import java.util.Arrays;

public final class AC3rmBinSConstraint
extends CspBinSConstraint {
    protected int[] currentSupport0;
    protected int[] currentSupport1;
    protected int offset0;
    protected int offset1;
    protected int[] initS0;
    protected int[] initS1;
    protected int minS0;
    protected int minS1;
    protected int initDomSize0;
    protected int initDomSize1;
    protected AbstractIntDomain v0Domain;
    protected AbstractIntDomain v1Domain;

    public AC3rmBinSConstraint(IntDomainVar x0, IntDomainVar x1, BinRelation relation) {
        super(x0, x1, relation);
        this.v0Domain = (AbstractIntDomain)this.v0.getDomain();
        this.v1Domain = (AbstractIntDomain)this.v1.getDomain();
    }

    @Override
    public int getFilteredEventMask(int idx) {
        return 12;
    }

    public void fastInitNbSupports(int a, int b) {
        int i;
        DisposableIntIterator itv0 = this.v0.getDomain().getIterator();
        int cpt1 = 0;
        while (itv0.hasNext()) {
            int val0 = itv0.next();
            ++cpt1;
            DisposableIntIterator itv1 = this.v1.getDomain().getIterator();
            int cpt2 = 0;
            while (itv1.hasNext()) {
                ++cpt2;
                int val1 = itv1.next();
                if (this.relation.isConsistent(val0, val1)) {
                    int n = val0 - this.offset0;
                    this.initS0[n] = this.initS0[n] + 1;
                    int n2 = val1 - this.offset1;
                    this.initS1[n2] = this.initS1[n2] + 1;
                }
                if (cpt2 < a) continue;
                break;
            }
            itv1.dispose();
            if (cpt1 < b) continue;
            break;
        }
        itv0.dispose();
        this.minS0 = Integer.MAX_VALUE;
        this.minS1 = Integer.MAX_VALUE;
        for (i = 0; i < this.initS0.length; ++i) {
            if (this.initS0[i] >= this.minS0) continue;
            this.minS0 = this.initS0[i];
        }
        for (i = 0; i < this.initS1.length; ++i) {
            if (this.initS1[i] >= this.minS1) continue;
            this.minS1 = this.initS1[i];
        }
    }

    @Override
    public Object clone() {
        return new AC3rmBinSConstraint(this.v0, this.v1, this.relation);
    }

    @Override
    public AbstractSConstraint<IntDomainVar> opposite(Solver solver) {
        return new AC3rmBinSConstraint(this.v0, this.v1, (BinRelation)((Object)((ConsistencyRelation)((Object)this.relation)).getOpposite()));
    }

    public boolean testDeepakConditionV1(int y, int v0Size) {
        return this.initS1[y - this.offset1] <= this.initDomSize0 - v0Size;
    }

    public boolean testDeepakConditionV0(int x, int v1Size) {
        return this.initS0[x - this.offset0] <= this.initDomSize1 - v1Size;
    }

    public int getSupportV1(int y) {
        return this.currentSupport1[y - this.offset1];
    }

    public int getSupportV0(int x) {
        return this.currentSupport0[x - this.offset0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reviseV1() throws ContradictionException {
        int v0Size = this.v0Domain.getSize();
        if (this.minS1 <= this.initDomSize0 - v0Size) {
            int left;
            DisposableIntIterator itv1 = this.v1Domain.getIterator();
            int right = left = Integer.MIN_VALUE;
            try {
                while (itv1.hasNext()) {
                    int y = itv1.next();
                    if (!this.testDeepakConditionV1(y, v0Size) || this.v0Domain.contains(this.getSupportV1(y))) continue;
                    boolean found = false;
                    int support = 0;
                    DisposableIntIterator itv0 = this.v0Domain.getIterator();
                    while (!found && itv0.hasNext()) {
                        support = itv0.next();
                        if (!this.relation.isConsistent(support, y)) continue;
                        found = true;
                    }
                    itv0.dispose();
                    if (found) {
                        this.storeSupportV1(support, y);
                        continue;
                    }
                    if (y == right + 1) {
                        right = y;
                        continue;
                    }
                    this.v1.removeInterval(left, right, this, false);
                    left = right = y;
                }
                this.v1.removeInterval(left, right, this, false);
            }
            finally {
                itv1.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reviseV0() throws ContradictionException {
        int v1Size = this.v1Domain.getSize();
        if (this.minS0 <= this.initDomSize1 - v1Size) {
            int left;
            DisposableIntIterator itv0 = this.v0Domain.getIterator();
            int right = left = Integer.MIN_VALUE;
            try {
                while (itv0.hasNext()) {
                    int x = itv0.next();
                    if (!this.testDeepakConditionV0(x, v1Size) || this.v1Domain.contains(this.getSupportV0(x))) continue;
                    boolean found = false;
                    int support = 0;
                    DisposableIntIterator itv1 = this.v1Domain.getIterator();
                    while (!found && itv1.hasNext()) {
                        support = itv1.next();
                        if (!this.relation.isConsistent(x, support)) continue;
                        found = true;
                    }
                    itv1.dispose();
                    if (found) {
                        this.storeSupportV0(support, x);
                        continue;
                    }
                    if (x == right + 1) {
                        right = x;
                        continue;
                    }
                    this.v0.removeInterval(left, right, this, false);
                    left = right = x;
                }
                this.v0.removeInterval(left, right, this, false);
            }
            finally {
                itv0.dispose();
            }
        }
    }

    public void storeSupportV0(int support, int x) {
        this.currentSupport0[x - this.offset0] = support;
        this.currentSupport1[support - this.offset1] = x;
    }

    public void storeSupportV1(int support, int y) {
        this.currentSupport1[y - this.offset1] = support;
        this.currentSupport0[support - this.offset0] = y;
    }

    public void init() {
        this.offset0 = this.v0.getInf();
        this.offset1 = this.v1.getInf();
        this.currentSupport0 = new int[this.v0.getSup() - this.v0.getInf() + 1];
        this.currentSupport1 = new int[this.v1.getSup() - this.v1.getInf() + 1];
        this.initS0 = new int[this.v0.getSup() - this.v0.getInf() + 1];
        this.initS1 = new int[this.v1.getSup() - this.v1.getInf() + 1];
        this.initDomSize0 = this.v0.getDomainSize();
        this.initDomSize1 = this.v1.getDomainSize();
        Arrays.fill(this.currentSupport0, -1);
        Arrays.fill(this.currentSupport1, -1);
        this.fastInitNbSupports(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void awake() throws ContradictionException {
        DisposableIntIterator itv1;
        int left;
        this.init();
        DisposableIntIterator itv0 = this.v0Domain.getIterator();
        int right = left = Integer.MIN_VALUE;
        int support = 0;
        boolean found = false;
        try {
            while (itv0.hasNext()) {
                itv1 = this.v1Domain.getIterator();
                int val0 = itv0.next();
                while (itv1.hasNext()) {
                    int val1 = itv1.next();
                    if (!this.relation.isConsistent(val0, val1)) continue;
                    support = val1;
                    found = true;
                    break;
                }
                itv1.dispose();
                if (!found) {
                    if (val0 == right + 1) {
                        right = val0;
                    } else {
                        this.v0.removeInterval(left, right, this, false);
                        left = right = val0;
                    }
                } else {
                    this.storeSupportV0(support, val0);
                }
                found = false;
            }
            this.v0.removeInterval(left, right, this, false);
        }
        finally {
            itv0.dispose();
        }
        found = false;
        itv1 = this.v1Domain.getIterator();
        right = Integer.MIN_VALUE;
        left = Integer.MIN_VALUE;
        try {
            while (itv1.hasNext()) {
                itv0 = this.v0Domain.getIterator();
                int val1 = itv1.next();
                while (itv0.hasNext()) {
                    int val0 = itv0.next();
                    if (!this.relation.isConsistent(val0, val1)) continue;
                    support = val0;
                    found = true;
                    break;
                }
                itv0.dispose();
                if (!found) {
                    if (val1 == right + 1) {
                        right = val1;
                    } else {
                        this.v1.removeInterval(left, right, this, false);
                        left = right = val1;
                    }
                } else {
                    this.storeSupportV1(support, val1);
                }
                found = false;
            }
            this.v1.removeInterval(left, right, this, false);
        }
        finally {
            itv1.dispose();
        }
    }

    @Override
    public void propagate() throws ContradictionException {
        this.reviseV0();
        this.reviseV1();
    }

    @Override
    public void awakeOnRemovals(int idx, DisposableIntIterator deltaDomain) throws ContradictionException {
        this.revise(idx);
    }

    @Override
    public void awakeOnInf(int idx) throws ContradictionException {
        this.revise(idx);
    }

    @Override
    public void awakeOnSup(int idx) throws ContradictionException {
        this.revise(idx);
    }

    @Override
    public void awakeOnRem(int idx, int x) throws ContradictionException {
        this.revise(idx);
    }

    @Override
    public void awakeOnBounds(int varIndex) throws ContradictionException {
        this.revise(varIndex);
    }

    public void revise(int idx) throws ContradictionException {
        if (idx == 0) {
            this.reviseV1();
        } else {
            this.reviseV0();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void awakeOnInst(int idx) throws ContradictionException {
        if (idx == 0) {
            int value = this.v0.getVal();
            DisposableIntIterator iterator = this.v1Domain.getIterator();
            int right = Integer.MIN_VALUE;
            int left = Integer.MIN_VALUE;
            try {
                while (iterator.hasNext()) {
                    int val = iterator.next();
                    if (this.relation.isConsistent(value, val)) continue;
                    if (val == right + 1) {
                        right = val;
                        continue;
                    }
                    this.v1.removeInterval(left, right, this, false);
                    left = right = val;
                }
                this.v1.removeInterval(left, right, this, false);
            }
            finally {
                iterator.dispose();
            }
        }
        int value = this.v1.getVal();
        DisposableIntIterator iterator = this.v0Domain.getIterator();
        int right = Integer.MIN_VALUE;
        int left = Integer.MIN_VALUE;
        try {
            while (iterator.hasNext()) {
                int val = iterator.next();
                if (this.relation.isConsistent(val, value)) continue;
                if (val == right + 1) {
                    right = val;
                    continue;
                }
                if (val <= right + 1) continue;
                this.v0.removeInterval(left, right, this, false);
                left = right = val;
            }
            this.v0.removeInterval(left, right, this, false);
        }
        finally {
            iterator.dispose();
        }
    }

    @Override
    public String pretty() {
        StringBuilder sb = new StringBuilder();
        sb.append("AC3rm(").append(this.v0.pretty()).append(", ").append(this.v1.pretty()).append(", ").append(this.relation.getClass().getSimpleName()).append(")");
        return sb.toString();
    }
}

