/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.integer;

import choco.IPretty;
import choco.kernel.common.util.iterators.DisposableIntIterator;
import choco.kernel.common.util.tools.StringUtils;
import choco.kernel.memory.IEnvironment;
import choco.kernel.memory.IStateInt;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.constraints.integer.AbstractLargeIntSConstraint;
import choco.kernel.solver.propagation.event.ConstraintEvent;
import choco.kernel.solver.variables.integer.IntDomainVar;

public final class ElementVG
extends AbstractLargeIntSConstraint {
    protected IStateInt[] lastInf;
    protected IStateInt[] lastSup;
    private final IEnvironment environment;
    private final int offset;

    public ElementVG(IntDomainVar[] vars, int offset, IEnvironment environment) {
        super(ConstraintEvent.QUADRATIC, vars);
        this.environment = environment;
        this.offset = offset;
        this.initElementV();
    }

    private void initElementV() {
        this.lastInf = new IStateInt[((IntDomainVar[])this.vars).length + 2];
        this.lastSup = new IStateInt[((IntDomainVar[])this.vars).length + 2];
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        Object res = super.clone();
        ((ElementVG)res).initElementV();
        return res;
    }

    @Override
    public String toString() {
        return "eltV";
    }

    @Override
    public String pretty() {
        return this.getValueVar().toString() + " = nth(" + this.getIndexVar().toString() + ", " + StringUtils.pretty((IPretty[])this.vars, 0, ((IntDomainVar[])this.vars).length - 3) + ')';
    }

    protected IntDomainVar getIndexVar() {
        return ((IntDomainVar[])this.vars)[((IntDomainVar[])this.vars).length - 2];
    }

    protected IntDomainVar getValueVar() {
        return ((IntDomainVar[])this.vars)[((IntDomainVar[])this.vars).length - 1];
    }

    @Override
    public boolean isSatisfied() {
        return ((IntDomainVar[])this.vars)[this.getIndexVar().getVal()].getVal() == this.getValueVar().getVal();
    }

    protected void updateValueFromIndex(int idx) throws ContradictionException {
        int left;
        IntDomainVar idxVar = this.getIndexVar();
        IntDomainVar valVar = this.getValueVar();
        int right = left = Integer.MIN_VALUE;
        int v = ((IntDomainVar[])this.vars)[idx].getInf();
        while (v < ((IntDomainVar[])this.vars)[idx].getSup()) {
            if (valVar.canBeInstantiatedTo(v)) {
                boolean possibleV = false;
                DisposableIntIterator it = idxVar.getDomain().getIterator();
                while (it.hasNext() && !possibleV) {
                    int tentativeIdx = it.next();
                    if (!((IntDomainVar[])this.vars)[tentativeIdx + this.offset].canBeInstantiatedTo(v)) continue;
                    possibleV = true;
                    break;
                }
                it.dispose();
                if (!possibleV) {
                    if (v == right + 1) {
                        right = v;
                    } else {
                        valVar.removeInterval(left, right, this, false);
                        left = v;
                        right = v;
                    }
                }
            }
            v = ((IntDomainVar[])this.vars)[idx].getNextDomainValue(v);
        }
        valVar.removeInterval(left, right, this, false);
    }

    protected void updateValueFromIndex() throws ContradictionException {
        IntDomainVar idxVar = this.getIndexVar();
        IntDomainVar valVar = this.getValueVar();
        int minval = Integer.MAX_VALUE;
        int maxval = Integer.MIN_VALUE;
        DisposableIntIterator iter = idxVar.getDomain().getIterator();
        while (iter.hasNext()) {
            int feasibleIndex = iter.next();
            minval = Math.min(minval, ((IntDomainVar[])this.vars)[feasibleIndex + this.offset].getInf());
            maxval = Math.max(maxval, ((IntDomainVar[])this.vars)[feasibleIndex + this.offset].getSup());
        }
        iter.dispose();
        valVar.updateInf(minval, this, false);
        valVar.updateSup(maxval, this, false);
        if (valVar.hasEnumeratedDomain()) {
            int v = valVar.getInf();
            while (v < valVar.getSup()) {
                boolean possibleV = false;
                DisposableIntIterator it = idxVar.getDomain().getIterator();
                while (it.hasNext() && !possibleV) {
                    int tentativeIdx = it.next();
                    if (!((IntDomainVar[])this.vars)[tentativeIdx + this.offset].canBeInstantiatedTo(v)) continue;
                    possibleV = true;
                    break;
                }
                it.dispose();
                if (!possibleV) {
                    valVar.removeVal(v, this, false);
                }
                v = valVar.getNextDomainValue(v);
            }
        }
    }

    protected void updateIndexFromValue(int v) throws ContradictionException {
        IntDomainVar idxVar = this.getIndexVar();
        IntDomainVar valVar = this.getValueVar();
        if (idxVar.isInstantiated()) {
            this.equalityBehaviour();
        } else {
            int left;
            int right = left = Integer.MIN_VALUE;
            int idx = idxVar.getInf();
            while (idx < idxVar.getSup()) {
                if (!valVar.canBeEqualTo(((IntDomainVar[])this.vars)[idx + this.offset])) {
                    if (idx == right + 1) {
                        right = idx;
                    } else {
                        valVar.removeInterval(left, right, this, false);
                        left = idx;
                        right = idx;
                    }
                }
                idx = idxVar.getNextDomainValue(idx);
            }
            valVar.removeInterval(left, right, this, false);
        }
    }

    protected void updateIndexFromValue() throws ContradictionException {
        IntDomainVar idxVar = this.getIndexVar();
        IntDomainVar valVar = this.getValueVar();
        int minFeasibleIndex = Math.max(0 - this.offset, idxVar.getInf());
        int maxFeasibleIndex = Math.min(idxVar.getSup(), ((IntDomainVar[])this.vars).length - 3 - this.offset);
        boolean forceAwake = false;
        if (valVar.hasEnumeratedDomain()) {
            forceAwake = true;
        }
        while (idxVar.canBeInstantiatedTo(minFeasibleIndex) && !valVar.canBeEqualTo(((IntDomainVar[])this.vars)[minFeasibleIndex + this.offset])) {
            ++minFeasibleIndex;
        }
        idxVar.updateInf(minFeasibleIndex, this, forceAwake);
        while (idxVar.canBeInstantiatedTo(maxFeasibleIndex) && !valVar.canBeEqualTo(((IntDomainVar[])this.vars)[maxFeasibleIndex + this.offset])) {
            --maxFeasibleIndex;
        }
        idxVar.updateSup(maxFeasibleIndex, this, forceAwake);
        if (idxVar.hasEnumeratedDomain()) {
            for (int i = minFeasibleIndex + 1; i < maxFeasibleIndex - 1; ++i) {
                if (!idxVar.canBeInstantiatedTo(i) || valVar.canBeEqualTo(((IntDomainVar[])this.vars)[i + this.offset])) continue;
                idxVar.removeVal(i, this, forceAwake);
            }
        }
        if (idxVar.isInstantiated()) {
            this.equalityBehaviour();
        }
    }

    protected void updateVariable(int index, int value) throws ContradictionException {
        boolean existsSupport = false;
        IntDomainVar idxVar = this.getIndexVar();
        IntDomainVar valVar = this.getValueVar();
        DisposableIntIterator it = idxVar.getDomain().getIterator();
        while (it.hasNext() && !existsSupport) {
            int feasibleIndex = it.next() + this.offset;
            if (!((IntDomainVar[])this.vars)[feasibleIndex].canBeInstantiatedTo(value)) continue;
            existsSupport = true;
        }
        it.dispose();
        if (!existsSupport) {
            valVar.removeVal(value, this, true);
        }
    }

    protected void equalityBehaviour() throws ContradictionException {
        int val;
        int right;
        int left;
        assert (this.getIndexVar().isInstantiated());
        int indexVal = this.getIndexVar().getVal();
        IntDomainVar valVar = this.getValueVar();
        IntDomainVar targetVar = ((IntDomainVar[])this.vars)[indexVal + this.offset];
        valVar.updateInf(targetVar.getInf(), this, false);
        valVar.updateSup(targetVar.getSup(), this, false);
        targetVar.updateInf(valVar.getInf(), this, false);
        targetVar.updateSup(valVar.getSup(), this, false);
        if (targetVar.hasEnumeratedDomain()) {
            right = left = Integer.MIN_VALUE;
            val = valVar.getInf();
            while (val < valVar.getSup()) {
                if (!targetVar.canBeInstantiatedTo(val)) {
                    if (val == right + 1) {
                        right = val;
                    } else {
                        valVar.removeInterval(left, right, this, false);
                        left = val;
                        right = val;
                    }
                }
                val = valVar.getNextDomainValue(val);
            }
            valVar.removeInterval(left, right, this, false);
        }
        if (valVar.hasEnumeratedDomain()) {
            right = left = Integer.MIN_VALUE;
            val = targetVar.getInf();
            while (val < targetVar.getSup()) {
                if (!valVar.canBeInstantiatedTo(val)) {
                    if (val == right + 1) {
                        right = val;
                    } else {
                        targetVar.removeInterval(left, right, this, false);
                        left = val;
                        right = val;
                    }
                }
                val = targetVar.getNextDomainValue(val);
            }
            targetVar.removeInterval(left, right, this, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void awake() throws ContradictionException {
        int i;
        int left;
        int i2;
        int n = ((IntDomainVar[])this.vars).length;
        IntDomainVar idxVar = this.getIndexVar();
        IntDomainVar valVar = this.getValueVar();
        int minval = Integer.MAX_VALUE;
        int maxval = Integer.MIN_VALUE;
        for (i2 = 0; i2 < n - 2; ++i2) {
            minval = Math.min(minval, ((IntDomainVar[])this.vars)[i2].getInf());
            maxval = Math.max(maxval, ((IntDomainVar[])this.vars)[i2].getSup());
            this.lastInf[i2] = this.environment.makeInt(((IntDomainVar[])this.vars)[i2].getInf());
            this.lastSup[i2] = this.environment.makeInt(((IntDomainVar[])this.vars)[i2].getSup());
        }
        int offset = minval;
        int heigth = maxval - offset + 1;
        int[] value = new int[n - 2];
        int[] occur = new int[n - 2];
        int[] firstPos = new int[n - 2];
        int[] redirect = new int[heigth];
        for (i2 = 0; i2 < heigth; ++i2) {
            redirect[i2] = -1;
        }
        int nbVal = 0;
        DisposableIntIterator iter = idxVar.getDomain().getIterator();
        while (iter.hasNext()) {
            int feasibleIndex = iter.next();
            DisposableIntIterator iter2 = ((IntDomainVar[])this.vars)[feasibleIndex].getDomain().getIterator();
            while (iter2.hasNext()) {
                int feasibleValue = iter2.next();
                if (redirect[feasibleValue - offset] == -1) {
                    value[nbVal] = feasibleValue;
                    redirect[feasibleValue - offset] = nbVal;
                    occur[nbVal] = 1;
                    firstPos[nbVal] = feasibleIndex;
                    ++nbVal;
                    continue;
                }
                occur[redirect[feasibleValue - offset]] = occur[redirect[feasibleValue - offset]] + 1;
            }
            iter2.dispose();
        }
        iter.dispose();
        int right = left = Integer.MIN_VALUE;
        for (i = 0; i < nbVal; ++i) {
            right = left = Integer.MIN_VALUE;
            for (int j = 0; j < n - 2; ++j) {
                if (!((IntDomainVar[])this.vars)[j].canBeInstantiatedTo(value[i]) || ((IntDomainVar[])this.vars)[j].getDomainSize() != 1) continue;
                if (j == right + 1) {
                    right = j;
                    continue;
                }
                idxVar.removeInterval(left, right, this, false);
                left = j;
                right = j;
            }
            idxVar.removeInterval(left, right, this, false);
        }
        for (int j = 0; j < n - 2; ++j) {
            right = left = Integer.MIN_VALUE;
            for (int i3 = 0; i3 < nbVal; ++i3) {
                if (!((IntDomainVar[])this.vars)[j].canBeInstantiatedTo(value[i3]) || idxVar.getDomainSize() != 1) continue;
                if (value[i3] == right + 1) {
                    right = value[i3];
                    continue;
                }
                ((IntDomainVar[])this.vars)[j].removeInterval(left, right, this, false);
                left = value[i3];
                right = value[i3];
            }
            ((IntDomainVar[])this.vars)[j].removeInterval(left, right, this, false);
        }
        for (i = 0; i < nbVal; ++i) {
            int val = value[i];
            if (!valVar.canBeInstantiatedTo(val)) continue;
            while (occur[i] > 1 && !idxVar.canBeInstantiatedTo(firstPos[i])) {
                occur[i] = occur[i] - 1;
                int j = firstPos[i] + 1;
                while (!((IntDomainVar[])this.vars)[j].canBeInstantiatedTo(val)) {
                    ++j;
                }
                firstPos[i] = j;
            }
            if (occur[i] != 1 || idxVar.canBeInstantiatedTo(firstPos[i])) continue;
            if (val == right + 1) {
                right = val;
                continue;
            }
            valVar.removeInterval(left, right, this, false);
            left = val;
            right = val;
        }
        valVar.removeInterval(left, right, this, false);
        iter = idxVar.getDomain().getIterator();
        right = Integer.MIN_VALUE;
        left = Integer.MIN_VALUE;
        try {
            while (iter.hasNext()) {
                int idx = iter.next();
                if (valVar.canBeEqualTo(((IntDomainVar[])this.vars)[idx])) continue;
                if (idx == right + 1) {
                    right = idx;
                    continue;
                }
                valVar.removeInterval(left, right, this, false);
                left = idx;
                right = idx;
            }
            valVar.removeInterval(left, right, this, false);
        }
        finally {
            iter.dispose();
        }
        this.lastInf[n - 2] = this.environment.makeInt(idxVar.getInf());
        if (n < idxVar.getSup()) {
            idxVar.updateSup(n, this, false);
            this.lastSup[n - 2] = this.environment.makeInt(n);
        } else {
            this.lastSup[n - 2] = this.environment.makeInt(idxVar.getSup());
        }
        if (offset > valVar.getInf()) {
            valVar.updateInf(offset, this, false);
            this.lastInf[n - 1] = this.environment.makeInt(offset);
        } else {
            this.lastInf[n - 1] = this.environment.makeInt(valVar.getInf());
        }
        if (valVar.getSup() > heigth + offset - 1) {
            valVar.updateSup(heigth + offset - 1, this, false);
            this.lastSup[n - 1] = this.environment.makeInt(heigth + offset - 1);
        } else {
            this.lastSup[n - 1] = this.environment.makeInt(valVar.getSup());
        }
        right = Integer.MIN_VALUE;
        left = Integer.MIN_VALUE;
        for (i = offset; i < heigth + offset - 1; ++i) {
            if (!valVar.canBeInstantiatedTo(i) || redirect[i - offset] != -1) continue;
            if (i == right + 1) {
                right = i;
                continue;
            }
            valVar.removeInterval(left, right, this, false);
            left = i;
            right = i;
        }
        valVar.removeInterval(left, right, this, false);
    }

    @Override
    public void awakeOnInf(int idx) throws ContradictionException {
        IntDomainVar idxVar = this.getIndexVar();
        IntDomainVar valVar = this.getValueVar();
        if (idx == ((IntDomainVar[])this.vars).length - 2) {
            if (idxVar.isInstantiated()) {
                this.equalityBehaviour();
            } else {
                int minIndex = idxVar.getInf();
                for (int index = this.lastInf[((IntDomainVar[])this.vars).length - 2].get(); index < minIndex; ++index) {
                    this.updateValueFromIndex(index);
                }
                this.lastInf[((IntDomainVar[])this.vars).length - 2].set(minIndex);
            }
        } else if (idx == ((IntDomainVar[])this.vars).length - 1) {
            if (idxVar.isInstantiated()) {
                int idxVal = idxVar.getVal();
                ((IntDomainVar[])this.vars)[idxVal + this.offset].updateInf(valVar.getInf(), this, false);
            } else {
                int minVar = valVar.getInf();
                for (int index = this.lastInf[((IntDomainVar[])this.vars).length - 1].get(); index < minVar; ++index) {
                    this.updateIndexFromValue(index);
                }
                this.lastInf[((IntDomainVar[])this.vars).length - 1].set(minVar);
            }
        } else if (idxVar.isInstantiated()) {
            int idxVal = idxVar.getVal();
            if (idx == idxVal + this.offset) {
                valVar.updateInf(((IntDomainVar[])this.vars)[idx].getInf(), this, false);
            }
        } else if (idxVar.canBeInstantiatedTo(idx - this.offset)) {
            if (!valVar.canBeEqualTo(((IntDomainVar[])this.vars)[idx])) {
                idxVar.removeVal(idx - this.offset, this, true);
            } else {
                int minVar = ((IntDomainVar[])this.vars)[idx].getInf();
                for (int index = this.lastInf[idx].get(); index < minVar; ++index) {
                    this.updateVariable(idx, index);
                }
                this.lastInf[idx].set(minVar);
            }
        }
    }

    @Override
    public void awakeOnSup(int idx) throws ContradictionException {
        IntDomainVar idxVar = this.getIndexVar();
        IntDomainVar valVar = this.getValueVar();
        if (idx == ((IntDomainVar[])this.vars).length - 2) {
            if (idxVar.isInstantiated()) {
                this.equalityBehaviour();
            } else {
                int maxIndex = this.lastSup[((IntDomainVar[])this.vars).length - 2].get();
                for (int index = idxVar.getSup() + 1; index <= maxIndex; ++index) {
                    this.updateValueFromIndex(index);
                }
                this.lastSup[((IntDomainVar[])this.vars).length - 2].set(idxVar.getSup());
            }
        } else if (idx == ((IntDomainVar[])this.vars).length - 1) {
            if (idxVar.isInstantiated()) {
                int idxVal = idxVar.getVal();
                ((IntDomainVar[])this.vars)[idxVal + this.offset].updateSup(valVar.getSup(), this, false);
            } else {
                int maxVar = this.lastSup[((IntDomainVar[])this.vars).length - 1].get();
                for (int index = valVar.getSup() + 1; index <= maxVar; ++index) {
                    this.updateIndexFromValue(index);
                }
                this.lastSup[((IntDomainVar[])this.vars).length - 1].set(valVar.getSup());
            }
        } else if (idxVar.isInstantiated()) {
            int idxVal = idxVar.getVal();
            if (idx == idxVal + this.offset) {
                valVar.updateSup(((IntDomainVar[])this.vars)[idx].getSup(), this, false);
            }
        } else if (idxVar.canBeInstantiatedTo(idx - this.offset)) {
            if (!valVar.canBeEqualTo(((IntDomainVar[])this.vars)[idx])) {
                idxVar.removeVal(idx - this.offset, this, true);
            } else {
                int maxVar = this.lastSup[idx].get();
                for (int index = ((IntDomainVar[])this.vars)[idx].getSup() + 1; index < maxVar; ++index) {
                    this.updateVariable(idx, index);
                }
                this.lastSup[idx].set(((IntDomainVar[])this.vars)[idx].getSup());
            }
        }
    }

    @Override
    public void awakeOnInst(int idx) throws ContradictionException {
        IntDomainVar idxVar = this.getIndexVar();
        IntDomainVar valVar = this.getValueVar();
        if (idx == ((IntDomainVar[])this.vars).length - 2) {
            this.equalityBehaviour();
        } else if (idx == ((IntDomainVar[])this.vars).length - 1) {
            if (idxVar.isInstantiated()) {
                int idxVal = idxVar.getVal();
                ((IntDomainVar[])this.vars)[idxVal + this.offset].instantiate(valVar.getVal(), this, false);
            } else {
                int minVar = valVar.getInf();
                for (int index = this.lastInf[((IntDomainVar[])this.vars).length - 1].get(); index < minVar; ++index) {
                    this.updateIndexFromValue(index);
                }
                this.lastInf[((IntDomainVar[])this.vars).length - 1].set(minVar);
                int maxVar = this.lastSup[((IntDomainVar[])this.vars).length - 1].get();
                for (int index = valVar.getSup() + 1; index <= maxVar; ++index) {
                    this.updateIndexFromValue(index);
                }
                this.lastSup[((IntDomainVar[])this.vars).length - 1].set(valVar.getSup());
            }
        } else if (idxVar.isInstantiated()) {
            int idxVal = idxVar.getVal();
            if (idx == idxVal + this.offset) {
                valVar.instantiate(((IntDomainVar[])this.vars)[idx].getVal(), this, false);
            }
        } else if (idxVar.canBeInstantiatedTo(idx - this.offset)) {
            if (!valVar.canBeEqualTo(((IntDomainVar[])this.vars)[idx])) {
                idxVar.removeVal(idx - this.offset, this, true);
            } else {
                int minVar = ((IntDomainVar[])this.vars)[idx].getInf();
                for (int index = this.lastInf[idx].get(); index < minVar; ++index) {
                    this.updateVariable(idx, index);
                }
                this.lastInf[idx].set(minVar);
                int maxVar = this.lastSup[idx].get();
                for (int index = ((IntDomainVar[])this.vars)[idx].getSup() + 1; index < maxVar; ++index) {
                    this.updateVariable(idx, index);
                }
                this.lastSup[idx].set(((IntDomainVar[])this.vars)[idx].getSup());
            }
        }
    }

    @Override
    public void awakeOnRem(int idx, int x) throws ContradictionException {
        IntDomainVar idxVar = this.getIndexVar();
        IntDomainVar valVar = this.getValueVar();
        if (idx == ((IntDomainVar[])this.vars).length - 2) {
            this.updateValueFromIndex(x);
        } else if (idx == ((IntDomainVar[])this.vars).length - 1) {
            if (idxVar.isInstantiated()) {
                int idxVal = idxVar.getVal();
                ((IntDomainVar[])this.vars)[idxVal + this.offset].removeVal(x, this, false);
            } else {
                this.updateIndexFromValue(x);
            }
        } else if (idxVar.isInstantiated()) {
            int idxVal = idxVar.getVal();
            if (idx == idxVal + this.offset) {
                valVar.removeVal(x, this, false);
            }
        } else if (idxVar.canBeInstantiatedTo(idx - this.offset) && valVar.hasEnumeratedDomain()) {
            this.updateVariable(idx, x);
        }
    }

    @Override
    public Boolean isEntailed() {
        int feasibleIndex;
        DisposableIntIterator it;
        Boolean isEntailed = null;
        IntDomainVar idxVar = this.getIndexVar();
        IntDomainVar valVar = this.getValueVar();
        if (valVar.isInstantiated() && idxVar.getInf() + this.offset >= 0 && idxVar.getSup() + this.offset < ((IntDomainVar[])this.vars).length - 2) {
            boolean allEqualToValVar = true;
            it = idxVar.getDomain().getIterator();
            while (it.hasNext()) {
                feasibleIndex = it.next() + this.offset;
                if (((IntDomainVar[])this.vars)[feasibleIndex].isInstantiatedTo(valVar.getVal())) continue;
                allEqualToValVar = false;
            }
            it.dispose();
            if (allEqualToValVar) {
                isEntailed = Boolean.TRUE;
            }
        }
        if (isEntailed != Boolean.TRUE) {
            boolean existsSupport = false;
            it = idxVar.getDomain().getIterator();
            while (it.hasNext()) {
                feasibleIndex = it.next() + this.offset;
                if (feasibleIndex < 0 || feasibleIndex >= ((IntDomainVar[])this.vars).length - 2 || !valVar.canBeEqualTo(((IntDomainVar[])this.vars)[feasibleIndex])) continue;
                existsSupport = true;
            }
            it.dispose();
            if (!existsSupport) {
                isEntailed = Boolean.FALSE;
            }
        }
        return isEntailed;
    }

    @Override
    public void propagate() throws ContradictionException {
    }
}

