<xsl:transform version="1.0"
               xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<xsl:import href="common.xsl"/>

<xsl:variable name="edition">Complete Home Edition</xsl:variable>
<xsl:variable name="web-images">.</xsl:variable>
<xsl:variable name="base-location">http://theory.uwinnipeg.ca/scripts/CTAN</xsl:variable>
<xsl:variable name="base-locale">.</xsl:variable>
  <xsl:variable name="datestamp">
    <xsl:value-of select="@datestamp"/>
  </xsl:variable>
  <xsl:variable name="ctandist">
    <xsl:value-of select="distribution/ctan"/>
  </xsl:variable>
  <xsl:variable name="texlivedist">
    <xsl:value-of select="distribution/texlive"/>
  </xsl:variable>
  <xsl:variable name="homepage">
    <xsl:value-of select="about/home"/>
  </xsl:variable>

<xsl:template match="catalogue">
  <xsl:comment>This file is automatically generated. Do not edit!</xsl:comment>
  <html>
  <xsl:call-template name="header"/>
    <BODY BGCOLOR="white">
      <xsl:call-template name="title"/>
    <xsl:call-template name="author"/>
      <xsl:call-template name="welcome"/>
      <xsl:call-template name="icons"/>
      <xsl:call-template name="copyright"/>
      <HR/>
      <xsl:apply-templates select="entry">
        <xsl:sort select="@id"/>
      </xsl:apply-templates>
      <HR/>
    </BODY>
  </html>
</xsl:template>

<!-- PROCESS AN ENTRY -->

<xsl:template match="entry">
  <!-- Had to record the datestamp as a variable since I could not get
       the @datestamp value after processing any children templates? -->
  <xsl:variable name="datestamp">
    <xsl:value-of select="@datestamp"/>
  </xsl:variable>
  <xsl:variable name="ctandist">
    <xsl:value-of select="distribution/ctan"/>
  </xsl:variable>
  <xsl:variable name="texlivedist">
    <xsl:value-of select="distribution/texlive"/>
  </xsl:variable>
  <xsl:variable name="homepage">
    <xsl:value-of select="about/home"/>
  </xsl:variable>

  <TABLE CELLPADDING="3" WIDTH="100%">

  
  <!-- HEADING -->

    <TR>
      <TH ALIGN="left" VALIGN="top" ROWSPAN="4" WIDTH="20%">
        <BIG>
          <A NAME="{@id}">
            <xsl:apply-templates select="about/name"/>
          </A>
        </BIG>
      </TH>

  <!-- CAPTION -->

      <TD ALIGN="left" VALIGN="bottom" COLSPAN="2" WIDTH="80%">
        <STRONG>
          <EM>
            <xsl:value-of select="about/caption"/>
          </EM>
        </STRONG>
      </TD>
    </TR>

  <!-- ABSTRACT -->

  <TR>
    <TD COLSPAN="2" WIDTH="80%">
      <xsl:if test="description/abstract">
        <xsl:apply-templates select="description/abstract"/>
      </xsl:if>
      <xsl:if test="about/author/name">
	<xsl:text> This package was implemented by </xsl:text>
        <xsl:apply-templates select="about/author"/>
	<xsl:text> catalogued for </xsl:text><A HREF="http://www.ctan.org">CTAN</A>
	<xsl:text>.</xsl:text>
      </xsl:if>
      <xsl:if test="about/xref">
        <SMALL><EM>
        <xsl:text> See also</xsl:text>
          <xsl:apply-templates select="about/xref"/>
        </EM></SMALL>
      </xsl:if>
    </TD>
  </TR>

  <!-- BUTTONS -->

  <!-- xsl:call-template name="buttons"/ -->

  <TR>

    <TD ALIGN="left" WIDTH="30%">

    <!-- CTAN -->

    <!-- I should test for what looks like a file name, and if it is
    not a file name, but looks like a directory then I should add the
    trailing slash if it is not already present. -->

    <xsl:if test="distribution/ctan">
      <!--A HREF="{$base-location}/{distribution/ctan}/"-->
      <A HREF="{$base-location}/{$ctandist}/">
        <IMG SRC="{$web-images}/dir.png" 
	     BORDER="0" WIDTH="20" HEIGHT="20" 
             ALT="Visit CTAN:{$ctandist}/"/>
      </A>
    </xsl:if>

    <!-- HOME -->

    <xsl:if test="about/home">
      <A HREF="{$homepage}">
        <IMG SRC="{$web-images}/home.png"
	     BORDER="0" WIDTH="20" HEIGHT="20" ALT="Visit the Package's Home Page"/> 
      </A>
    </xsl:if>

    <!-- DOCUMENTATION -->

    <xsl:if test="description/documentation">
      <xsl:apply-templates select="description/documentation"/>
    </xsl:if>

    <!-- Do each of the documentation entries here -->

    <!-- DOWNLOAD FROM CTAN -->

    <xsl:if test="distribution/ctan">

      <!-- DOWNLOAD SEARCH -->

      <A HREF="{$web-search}/{$ctandist}.tar.gz">
        <IMG SRC="{$web-images}/search.png"
	     BORDER="0" ALT="Download from somewhere nearby (Search)"/>
      </A>

      <!-- DOWNLOAD DANTE -->

      <A HREF="{$dante}/{$ctandist}.tar.gz">
        <IMG SRC="{$web-images}/tar.png"
	     BORDER="0" ALT="Download from Dante"/>
      </A>

    </xsl:if>

    <!-- TEXLIVE -->

    <xsl:if test="distribution/texlive">
      <IMG SRC="{$web-images}/texlive.png "
	   ALT="Included in TeXLive distribution in {$texlivedist}" 
	   BORDER="0" WIDTH="18" HEIGHT="18"/>
    </xsl:if>

  </TD>

  <TD ALIGN="right" valign="bottom" WIDTH="50%">
    <SMALL>
      <EM>
        <xsl:text>License: </xsl:text>
        <STRONG>
          <xsl:apply-templates select="about/license"/>
        </STRONG>
         <xsl:if test="about/version/number">
           <xsl:apply-templates select="about/version/number"/>
         </xsl:if>
         <!--xsl:choose>
         <xsl:when test="about/version/released">
           <xsl:apply-templates select="about/version/released"/>
         </xsl:when>
         <xsl:otherwise-->
            <xsl:text> Catalogued: </xsl:text>
            <STRONG>
            <xsl:value-of select="$datestamp"/>
            </STRONG>
         <!--/xsl:otherwise>
         </xsl:choose-->
      </EM>
    </SMALL>
  </TD>
  
  </TR>

  <TR><TD COLSPAN="2" WIDTH="80%" VALIGN="top" HEIGHT="1"><HR/></TD></TR>

</TABLE>

</xsl:template>

<xsl:template match="about/license">
  <xsl:choose>
    <xsl:when test="@type">
      <A HREF="licenses.{@type}.html">
        <xsl:value-of select="@type"/>
      </A>
    </xsl:when>
    <xsl:otherwise>
      <A HREF="licenses.html#unknown">unknown</A>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template match="about/xref">
  <xsl:text> </xsl:text>
  <A HREF="#{@refid}"> <xsl:value-of select="@refid"/></A>
</xsl:template>

<xsl:template match="about/author">
  <xsl:if test="name='unknown'">
    <xsl:text>an author </xsl:text>
  </xsl:if>
  <xsl:if test="name">
    <xsl:apply-templates select="name"/><xsl:text> and </xsl:text>
  </xsl:if>
</xsl:template>

</xsl:transform>


